/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.entity;

import java.util.ArrayList;
import java.util.List;
import kd.occ.ocpos.common.entity.StopPointEntity;
import kd.occ.ocpos.common.util.promotion.CommonUtils;
import kd.occ.ocpos.common.util.promotion.DateFormatUtils;

public class StopWatchEntity {
    private String name;
    private long start;
    private List<StopPointEntity> points;

    public StopWatchEntity() {
    }

    private StopWatchEntity(String name, long start, List<StopPointEntity> points) {
        this.name = name;
        this.start = start;
        this.points = points;
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public List<StopPointEntity> getPoints() {
        return this.points;
    }

    public static StopWatchEntity startStopWatch(String name) {
        if (CommonUtils.isEmpty(name)) {
            name = "\u4efb\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return new StopWatchEntity(name, DateFormatUtils.getCurrentTime(), new ArrayList<StopPointEntity>());
    }

    public void addPoint(String pointName, StopWatchEntity sw) {
        if (CommonUtils.isEmpty(pointName)) {
            return;
        }
        sw.getPoints().add(new StopPointEntity(pointName, DateFormatUtils.getCurrentTime()));
    }

    public String print(StopWatchEntity watch) {
        long stop;
        if (CommonUtils.isEmpty(watch.getName())) {
            return "";
        }
        if (watch.getPoints().size() > 0) {
            int len = watch.getPoints().size() - 1;
            stop = watch.getPoints().get(len).getConsume();
        } else {
            stop = DateFormatUtils.getCurrentTime();
        }
        StringBuilder s = new StringBuilder(String.format("%s,total %s:", watch.getName(), (stop - watch.getStart()) / 1000L));
        long start = watch.getStart();
        for (StopPointEntity StopPointEntity2 : watch.getPoints()) {
            s.append(String.format(" [%s:%s] ", StopPointEntity2.getName(), StopPointEntity2.getConsume() - start));
            start = StopPointEntity2.getConsume();
        }
        return s.toString();
    }
}

