/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.enums;

import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;

public enum PosOrderTypeEnum {
    Bill("ocpos_saleorder", BillTypeEnum.RETAIL.getId(), ReceiveTypeEnum.GENERALCOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    SALE("ocpos_saleorder_bill", BillTypeEnum.RETAIL.getId(), ReceiveTypeEnum.GENERALCOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    BOOK("ocpos_saleorder_book", BillTypeEnum.RESERVE.getId(), ReceiveTypeEnum.GENERALCOLLECTION.getValue(), BizTypeEnum.SALEORDER.getValue()),
    CVT("ocpos_saleorder_cvtsale", BillTypeEnum.CVTSALE.getId(), ReceiveTypeEnum.GENERALCOLLECTION.getValue(), BizTypeEnum.ORDERCONVERTSALE.getValue()),
    STORE("ocpos_saleorder_store", BillTypeEnum.STORE.getId(), ReceiveTypeEnum.GUIDECOLLECTION.getValue(), BizTypeEnum.GUIDEORDER.getValue()),
    STORE_GUIDE("ocpos_saleorder_guide", BillTypeEnum.GUIDE.getId(), ReceiveTypeEnum.GUIDECOLLECTION.getValue(), BizTypeEnum.GUIDEORDER.getValue()),
    STORE_GROUP("ocpos_saleorder_group", BillTypeEnum.GROUP.getId(), ReceiveTypeEnum.GROUPCOLLECTION.getValue(), BizTypeEnum.GROUPORDER.getValue()),
    FINAL("ocpos_saleorder_final", BillTypeEnum.FINAL.getId(), ReceiveTypeEnum.SALEBALANCECOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    FINAL_BILL("ocpos_saleorder_billfinal", BillTypeEnum.FINAL.getId(), ReceiveTypeEnum.SALEBALANCECOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    FINAL_BOOK("ocpos_saleorder_bookfinal", BillTypeEnum.RESERVEFINAL.getId(), ReceiveTypeEnum.RESERVEBALANCECOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    FINAL_CREDIT("ocpos_saleorder_credit", BillTypeEnum.CREDIT.getId(), ReceiveTypeEnum.SALECREDITCOLLECTION.getValue(), BizTypeEnum.SALEBILL.getValue()),
    CHANGE("ocpos_salechange", BillTypeEnum.CHANGE.getId(), ReceiveTypeEnum.EXCHANGECOLLECTION.getValue(), BizTypeEnum.CHANGE.getValue()),
    RETURN("ocpos_saleorder_return", BillTypeEnum.RETURN.getId(), ReceiveTypeEnum.SALECOLLECTION.getValue(), BizTypeEnum.SALERETURN.getValue());

    String formId;
    long billTypeId;
    long receivingTypeId;
    String bizType;

    private PosOrderTypeEnum(String formId, long billTypeId, long receivingTypeId, String bizType) {
        this.formId = formId;
        this.billTypeId = billTypeId;
        this.receivingTypeId = receivingTypeId;
        this.bizType = bizType;
    }

    public String getFormId() {
        return this.formId;
    }

    public long getBillTypeId() {
        return this.billTypeId;
    }

    public long getReceivingTypeId() {
        return this.receivingTypeId;
    }

    public String getBizType() {
        return this.bizType;
    }

    public static long getBillTypeIdByFormId(String formId) {
        long billTypeId = 0L;
        for (PosOrderTypeEnum type : PosOrderTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)formId, (CharSequence)type.getFormId())) continue;
            billTypeId = type.getBillTypeId();
            break;
        }
        return billTypeId;
    }

    public static long getReceivingTypeIdByFormId(String formId) {
        long receivingTypeId = 0L;
        for (PosOrderTypeEnum type : PosOrderTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)formId, (CharSequence)type.getFormId())) continue;
            receivingTypeId = type.getReceivingTypeId();
            break;
        }
        return receivingTypeId;
    }

    public static String getBizTypeByFormId(String formId) {
        String bizType = "";
        for (PosOrderTypeEnum type : PosOrderTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)formId, (CharSequence)type.getFormId())) continue;
            bizType = type.getBizType();
            break;
        }
        return bizType;
    }
}

