/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;
import kd.occ.ocpos.common.enums.ReturnModelEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.JsonUtil;
import kd.occ.ocpos.common.util.PayUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class CommonUtils {
    private static String[] paymentCols = new String[]{"number", "name", "isinvoice", "noenternumber", "rewardpoints", "iscoupon", "isintegratedfnc", "creator", "createtime", "modifier", "modifytime", "audittime", "reviewer", "id", "issyspreset", "enable", "paywaytype", "service", "ismaindisplay", "displayseq", "isallowfinalpay"};
    private static final LinkedHashSet<String> INV_FIELD_LIST = new LinkedHashSet();
    private static Log logger;

    public static BigDecimal getCurrencyRate(long payCurrencyId, long targetCurrencyId) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (payCurrencyId == targetCurrencyId) {
            return BigDecimal.ONE;
        }
        QFilter exOrgCurfilter = new QFilter("orgcur", "=", (Object)payCurrencyId);
        QFilter exCurfilter = new QFilter("cur", "=", (Object)targetCurrencyId);
        QFilter[] exFilters = new QFilter[]{exOrgCurfilter, exCurfilter};
        DynamicObject exchangeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"excval", (QFilter[])exFilters);
        if (exchangeRate != null) {
            exChangeRate = exchangeRate.getBigDecimal("excval");
        } else {
            QFilter orgCurfilter = new QFilter("orgcur", "=", (Object)targetCurrencyId);
            QFilter curfilter = new QFilter("cur", "=", (Object)payCurrencyId);
            QFilter[] filters = new QFilter[]{orgCurfilter, curfilter};
            DynamicObject changeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"indirectexrate", (QFilter[])filters);
            if (changeRate != null) {
                exChangeRate = changeRate.getBigDecimal("indirectexrate");
            }
        }
        return exChangeRate;
    }

    public static List<DynamicObject> getPaymentModeList(String range) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        if (StringUtils.equalsIgnoreCase((CharSequence)range, (CharSequence)"main")) {
            filter.and("ismaindisplay", "=", (Object)"1");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)range, (CharSequence)"more")) {
            filter.and("ismaindisplay", "=", (Object)"0");
        }
        filter.and("id", "not in", Arrays.asList(14L, 19L, 20L, 27L, 30L));
        return QueryServiceHelper.query((String)"ocdbd_paymode", (String)CommonUtils.getQuerySelectColNames(paymentCols), (QFilter[])filter.toArray(), (String)"displayseq");
    }

    private static String getQuerySelectColNames(String[] colNames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colNames.length; ++i) {
            sb.append(colNames[i]).append(',');
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    public static DynamicObject getDefaultDeliveryStock(DynamicObject branch) {
        QFilter filter = F7Util.getStockIdFilter(branch);
        filter.and("isdelivery", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"Id", (QFilter[])filter.toArray());
    }

    public static List<Long> getNoElectricPayList() {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("iselectronicpay", "=", (Object)"0");
        QFilter serviceFilter = new QFilter("service", "=", (Object)" ");
        serviceFilter.or("service", "is null", (Object)"");
        filter.and(serviceFilter);
        DynamicObject[] noElectricPayWays = BusinessDataServiceHelper.load((String)"ocdbd_paymode", (String)"id", (QFilter[])filter.toArray());
        if (noElectricPayWays == null || noElectricPayWays.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(noElectricPayWays).map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x)).distinct().collect(Collectors.toList());
    }

    public static boolean checkBranchIsBlank(IFormView view, long branchId) {
        if (branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u5355\u95e8\u5e97\u3002", (IFormView)view);
            return true;
        }
        return false;
    }

    public static boolean checkBizOrg(IFormView view, long bizOrgId) {
        if (bizOrgId == 0L) {
            view.showErrorNotification("\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002");
            return true;
        }
        return false;
    }

    public static void updateReceivableAmount(IDataModel model, DynamicObject entryEntity) {
        DynamicObject dataEntity = model.getDataEntity();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        CommonUtils.updateReceivableAmount(entryEntity, orgId, branchId, billTypeId);
    }

    public static void updateExpectFinalAmount(DynamicObject entryItem) {
        boolean isReceivable = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"isbook");
        BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"deposit");
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal manualDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"manualdiscount");
        BigDecimal receExpectFinalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"receexpectfinalamount");
        if (isReceivable) {
            BigDecimal expectFinalAmount = balAmount.subtract(manualDiscount).subtract(deposit);
            entryItem.set("expectfinalamount", (Object)expectFinalAmount);
            entryItem.set("noreceexpectfinalamount", (Object)expectFinalAmount.subtract(receExpectFinalAmount));
        }
    }

    public static void updateNoReceFinalAmount(DynamicObject entryItem) {
        boolean isReceivable = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"isbook");
        BigDecimal finalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"finalpayment");
        BigDecimal receivedFinalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"receivedfinalpayment");
        if (!isReceivable) {
            entryItem.set("norecefinalamount", (Object)finalPayment.subtract(receivedFinalPayment));
        }
    }

    public static void updateFinalpayment(DynamicObject entryItem) {
        BigDecimal balamount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal finalpaymentscale = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"finalpaymentscale");
        BigDecimal finalpayment = balamount.multiply(finalpaymentscale).divide(BigDecimal.valueOf(100L));
        entryItem.set("finalpayment", (Object)finalpayment);
    }

    public static void updateFinalpaymentScale(DynamicObject entryItem) {
        BigDecimal balamount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal finalpayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"finalpayment");
        BigDecimal finalpaymentscale = BigDecimal.ZERO;
        if (balamount.compareTo(BigDecimal.ZERO) != 0) {
            finalpaymentscale = finalpayment.multiply(BigDecimal.valueOf(100L)).divide(balamount, 2);
        }
        entryItem.set("finalpaymentscale", (Object)finalpaymentscale);
    }

    public static void updateDepositAmount(DynamicObject entryItem) {
        BigDecimal depositscale = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"depositscale");
        BigDecimal balamount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        entryItem.set("deposit", (Object)balamount.multiply(depositscale).divide(BigDecimal.valueOf(100L)));
    }

    public static void updateDepositscale(DynamicObject entryItem) {
        boolean isReceivable = DynamicObjectUtil.getBoolean(entryItem, "isbook");
        if (isReceivable) {
            BigDecimal deposit = DynamicObjectUtil.getBigDecimal(entryItem, "deposit");
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal(entryItem, "balamount");
            BigDecimal depositScale = BigDecimal.ZERO;
            if (balAmount.compareTo(BigDecimal.ZERO) != 0) {
                depositScale = deposit.multiply(BigDecimal.valueOf(100L)).divide(balAmount, 2, 4);
            }
            entryItem.set("depositscale", (Object)depositScale);
        }
    }

    public static void updateBalPriceAndAmount(DynamicObject entryItem) {
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"ispresent");
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal discountRate = BigDecimal.ZERO;
        if (!isPresent) {
            price = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"retailprice");
            discountRate = new BigDecimal(100);
        }
        entryItem.set("discountprice", (Object)price);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
        entryItem.set("balamount", (Object)price.multiply(saleQty));
        entryItem.set("discountrate", (Object)discountRate);
    }

    public static void setAuxAttrIdByBarCode(DynamicObject entryItem, long barCodeId) {
        DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"barcode");
        DynamicObject auxAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"auxpty");
        entryItem.set("auxattrid", (Object)auxAttr);
    }

    public static void setRetailPrice(IFormView view, DynamicObject entryEntity, long goodsId, long barCodeId, int index, boolean isEnablePricePolicy) {
        Map<String, Object> retailPriceByPolicy = CommonUtils.getRetailPrice(view, entryEntity, goodsId, barCodeId, isEnablePricePolicy);
        for (Map.Entry<String, Object> entry : retailPriceByPolicy.entrySet()) {
            String key;
            DataEntityPropertyCollection properties = entryEntity.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)(key = entry.getKey()))) continue;
            entryEntity.set(key, entry.getValue());
        }
        boolean isControlPrice = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"iscontrolprice");
        view.setEnable(Boolean.valueOf(!isControlPrice), index, new String[]{"discountprice"});
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
        if (saleQty.compareTo(BigDecimal.ZERO) == 0) {
            saleQty = BigDecimal.ONE;
        }
        entryEntity.set("saleqty", (Object)saleQty);
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"retailprice");
        entryEntity.set("amount", (Object)saleQty.multiply(retailPrice));
    }

    public static Map<String, Object> getRetailPrice(IFormView view, DynamicObject entryEntity, long goodsId, long barCodeId, boolean isEnablePricePolicy) {
        if (!isEnablePricePolicy) {
            return CommonUtils.getRetailPriceByBusDir(view, entryEntity, goodsId, barCodeId);
        }
        String date = CommonUtil.format(TimeServiceHelper.now(), TimeServiceHelper.getDateTimeFormatString());
        DynamicObject channel = (DynamicObject)view.getModel().getValue("salebranchid");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)channel);
        long priceUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
        long stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"channelstocktypeid");
        JSONObject result = CommonUtils.getPricePolicyData(goodsId, barCodeId, channelId, priceUnitId, stockTypeId, date);
        HashMap<String, Object> policyResult = new HashMap<String, Object>(5);
        if (result != null) {
            JSONObject pricePolicyResult = result.getJSONObject("data");
            logger.info("\u5f00\u5355\u53d6\u4ef7\u8fd4\u53c2\uff1a" + JsonUtil.toJson(pricePolicyResult));
            if (pricePolicyResult != null) {
                BigDecimal retailPrice = pricePolicyResult.getBigDecimal("price");
                if (retailPrice == null || retailPrice.compareTo(BigDecimal.ZERO) <= 0) {
                    return CommonUtils.getRetailPriceByBusDir(view, entryEntity, goodsId, barCodeId);
                }
                policyResult.put("retailprice", retailPrice);
                boolean isControlPrice = pricePolicyResult.getBoolean("controllerPrice");
                policyResult.put("iscontrolprice", isControlPrice);
                String priceType = pricePolicyResult.getString("priceTypeName");
                policyResult.put("pricetypename", priceType);
                long priceTypeId = pricePolicyResult.getLongValue("priceTypeId");
                policyResult.put("pricetype", priceTypeId);
                long saleAttrId = pricePolicyResult.getLongValue("itemSaleAttrId");
                if (saleAttrId > 0L) {
                    DynamicObject saleAttr = BusinessDataServiceHelper.loadSingle((Object)saleAttrId, (String)"ocdbd_item_saleattr");
                    policyResult.put("saleattr", saleAttr);
                }
                return policyResult;
            }
            return CommonUtils.getRetailPriceByBusDir(view, entryEntity, goodsId, barCodeId);
        }
        return CommonUtils.getRetailPriceByBusDir(view, entryEntity, goodsId, barCodeId);
    }

    public static JSONObject getPricePolicyData(long goodsId, long barCodeId, long channelId, long priceUnitId, long stockTypeId, String date) {
        JSONObject param = new JSONObject();
        param.put("itemId", (Object)String.valueOf(goodsId));
        param.put("barcode", (Object)String.valueOf(barCodeId));
        param.put("channel", (Object)String.valueOf(channelId));
        param.put("priceUnit", (Object)String.valueOf(priceUnitId));
        param.put("stockType", (Object)String.valueOf(stockTypeId));
        param.put("bizDate", (Object)date);
        param.put("store", (Object)Boolean.TRUE);
        logger.info("\u5f00\u5355\u53d6\u4ef7\u4f20\u53c2\uff1a" + JsonUtil.toJson(param));
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdpm", (String)"PricePolicyService", (String)"matchPricePolicy", (Object[])new Object[]{JsonUtil.toJson(param)});
    }

    public static void setRetailPriceByBusDir(IFormView view, DynamicObject entryItem, long goodsId, long barCodeId, int index) {
        Map<String, Object> retailPriceByBusDir = CommonUtils.getRetailPriceByBusDir(view, entryItem, goodsId, barCodeId);
        for (Map.Entry<String, Object> entry : retailPriceByBusDir.entrySet()) {
            entryItem.set(entry.getKey(), entry.getValue());
        }
        view.setEnable(Boolean.TRUE, index, new String[]{"discountprice"});
    }

    public static Map<String, Object> getRetailPriceByBusDir(IFormView view, DynamicObject entryItem, long goodsId, long barCodeId) {
        DynamicObject branch = (DynamicObject)view.getModel().getValue("salebranchid");
        DynamicObject currency = (DynamicObject)view.getModel().getValue("currencyid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
        QFilter filter = F7Util.getGoodsInfoFilter(goodsId, branchId, barCodeId, currencyId);
        String selectFields = "Id,retailprice";
        DynamicObject salItem = QueryServiceHelper.queryOne((String)"ocdbd_itemsale_content", (String)selectFields, (QFilter[])filter.toArray());
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)salItem, (String)"retailprice");
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("retailprice", retailPrice);
        result.put("iscontrolprice", Boolean.FALSE);
        result.put("pricetypename", "");
        result.put("pricetype", 0L);
        result.put("saleattr", null);
        return result;
    }

    public static boolean isExistField(IFormView view, String key) {
        String formId = view.getEntityId();
        MainEntityType mEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        List lstFieldKey = mEntityType.getAllFields().values().stream().map(IMetadata::getName).collect(Collectors.toList());
        return lstFieldKey.contains(key);
    }

    public static void updateLastBillAmount(String billType, String sourceBillType, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        DynamicObject doLastBill = null;
        ArrayList<DynamicObject> lstLastBill = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection(dataEntity, "goodsentryentity");
            if (ObjectUtils.isEmpty((Object)docGoodsEntry)) {
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceBillType);
            Object[] fieldKeys = entityType.getAllFields().values().stream().map(IMetadata::getName).toArray();
            QFilter filter = new QFilter("Id", "in", (Object)docGoodsEntry.stream().map(x -> x.getString("entrysrcbillid")).toArray());
            DynamicObject[] billData = BusinessDataServiceHelper.load((String)sourceBillType, (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
            if (billData.length == 0) {
                return;
            }
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                DynamicObject doLastEntry;
                DynamicObjectCollection docLastEntry;
                DynamicObject doSrcGoodsEntry;
                DynamicObjectCollection docSrcGoodsEntry;
                DynamicObject doSrcSaleOrder;
                BigDecimal receivedFinalPayment = BigDecimal.ZERO;
                String srcBillNo = DynamicObjectUtil.getString(doGoodsEntry, "entrysrcbillno");
                Long lSrcBillEntryID = DynamicObjectUtil.getLong(doGoodsEntry, "srcbillentryid");
                DynamicObjectUtil.getBigDecimal(doGoodsEntry, "linereceivableamount");
                if (StringUtils.isEmpty((CharSequence)srcBillNo) || (doSrcSaleOrder = (DynamicObject)Arrays.stream(billData).filter(x -> x.getString("billno").equals(srcBillNo)).findFirst().orElse(null)) == null || ObjectUtils.isEmpty((Object)(docSrcGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection(doSrcSaleOrder, "goodsentryentity"))) || (doSrcGoodsEntry = (DynamicObject)docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtil.getPkValue(x).equals(lSrcBillEntryID)).findFirst().orElse(null)) == null) continue;
                DynamicObjectUtil.getLong(doSrcGoodsEntry, "lastbillid");
                Long lastBillEntryID = DynamicObjectUtil.getLong(doSrcGoodsEntry, "lastbillentryid");
                if (doLastBill == null || ObjectUtils.isEmpty((Object)(docLastEntry = DynamicObjectUtil.getDynamicObjectCollection(doLastBill, "entryentity"))) || (doLastEntry = (DynamicObject)docLastEntry.stream().filter(x -> DynamicObjectUtil.getPkValue(x).equals(lastBillEntryID)).findFirst().orElse(null)) == null) continue;
                doLastEntry.set("recfinalamount", (Object)receivedFinalPayment);
                lstLastBill.add(doLastEntry);
            }
        }
        if (lstLastBill.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])lstLastBill.toArray(new DynamicObject[lstLastBill.size()]));
        }
    }

    public static void updateBaseInfoAmount(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        long receivingTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"receivingtype");
        if (receivingTypeId == ReceiveTypeEnum.SALECREDITCOLLECTION.getValue()) {
            BigDecimal sumArEntryAmount = BigDecimal.ZERO;
            DynamicObjectCollection arEntryEntities = dataEntity.getDynamicObjectCollection("arentryentity");
            if (CollectionUtils.isEmpty((Collection)arEntryEntities)) {
                if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"depositamount")) {
                    CommonUtils.updateValue(view, "depositamount", BigDecimal.ZERO);
                }
                if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"endpayamount")) {
                    CommonUtils.updateValue(view, "endpayamount", BigDecimal.ZERO);
                }
            }
            for (DynamicObject arEntryItem : arEntryEntities) {
                BigDecimal arEntryAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)arEntryItem, (String)"arentryamount");
                sumArEntryAmount = sumArEntryAmount.add(arEntryAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumamount")) {
                CommonUtils.updateValue(view, "sumamount", sumArEntryAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumbalamount")) {
                CommonUtils.updateValue(view, "sumbalamount", sumArEntryAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"receivableamount")) {
                CommonUtils.updateValue(view, "receivableamount", sumArEntryAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumdiscount")) {
                CommonUtils.updateValue(view, "sumdiscount", BigDecimal.ZERO);
            }
        } else {
            String bizType = dataEntity.getString("biztype");
            boolean isConvert = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue());
            BigDecimal sumAmount = BigDecimal.ZERO;
            BigDecimal sumBalAmount = BigDecimal.ZERO;
            BigDecimal sumPreAmount = BigDecimal.ZERO;
            BigDecimal finalHeadDepositAmount = BigDecimal.ZERO;
            BigDecimal finalHeadReceivableAmount = BigDecimal.ZERO;
            BigDecimal finalHeadEndPayAmount = BigDecimal.ZERO;
            BigDecimal finalHeadDepositPayAmount = BigDecimal.ZERO;
            DynamicObjectCollection entryData = dataEntity.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject entryItem : entryData) {
                BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"amount");
                sumAmount = sumAmount.add(amount);
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
                sumBalAmount = sumBalAmount.add(balAmount);
                BigDecimal preAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"deposit");
                sumPreAmount = sumPreAmount.add(preAmount);
                finalHeadDepositAmount = finalHeadDepositAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"deposit"));
                finalHeadReceivableAmount = finalHeadReceivableAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"linereceivableamount"));
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"isbook");
                finalHeadEndPayAmount = isBook ? finalHeadEndPayAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"balamount").subtract(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"deposit")).subtract(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"manualdiscount"))) : finalHeadEndPayAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"finalpayment"));
                if (!isConvert) continue;
                finalHeadDepositPayAmount = finalHeadDepositPayAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"receexpectfinalamount")).add(DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"deposit"));
            }
            BigDecimal sumDiscount = sumAmount.subtract(sumBalAmount);
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumamount")) {
                CommonUtils.updateValue(view, "sumamount", sumAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumbalamount")) {
                CommonUtils.updateValue(view, "sumbalamount", sumBalAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"sumdiscount")) {
                CommonUtils.updateValue(view, "sumdiscount", sumDiscount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"preamount")) {
                CommonUtils.updateValue(view, "preamount", sumPreAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"endpayamount")) {
                CommonUtils.updateValue(view, "endpayamount", finalHeadEndPayAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"receivableamount")) {
                CommonUtils.updateValue(view, "receivableamount", finalHeadReceivableAmount);
            }
            if (DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"depositamount")) {
                CommonUtils.updateValue(view, "depositamount", finalHeadDepositAmount);
            }
            if (isConvert && DynamicObjectUtils.contain((DynamicObject)dataEntity, (String)"depositpayamount")) {
                CommonUtils.updateValue(view, "depositpayamount", finalHeadDepositPayAmount);
            }
        }
    }

    public static void updateValue(IFormView view, String key, Object value) {
        view.getModel().beginInit();
        view.getModel().setValue(key, value);
        view.updateView(key);
        view.getModel().endInit();
    }

    public static boolean checkOrderType(IDataModel model) {
        boolean isStore;
        DynamicObject billType = (DynamicObject)model.getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        boolean isSaleBill = billTypeId == BillTypeEnum.RETAIL.getId();
        boolean isCvtSale = billTypeId == BillTypeEnum.CVTSALE.getId();
        boolean bl = isStore = billTypeId == BillTypeEnum.STORE.getId();
        return !isSaleBill && !isCvtSale && !isStore;
    }

    public static DynamicObject getStockPositionByStockId(DynamicObject stock) {
        if (stock == null) {
            return null;
        }
        DynamicObjectCollection stockPositions = CommonUtils.getStockPositions(DynamicObjectUtils.getPkValue((DynamicObject)stock));
        DynamicObject stockPosition = null;
        int count = stockPositions.size();
        if (count == 1) {
            stockPosition = (DynamicObject)stockPositions.get(0);
        } else if (count > 1) {
            stockPosition = stockPositions.stream().filter(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isdefault")).findFirst().orElse(null);
        }
        return stockPosition;
    }

    private static DynamicObjectCollection getStockPositions(long stockId) {
        QFilter filter = F7Util.getStockPositionidFilter(stockId);
        return QueryServiceHelper.query((String)"ococic_location", (String)"Id,isdefault", (QFilter[])filter.toArray());
    }

    private static BigDecimal getLineReturnAmount(DynamicObject entryEntity, long orgId, long branchId, long billTypeId) {
        BigDecimal lineReturnAmount;
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"balamount");
        BigDecimal manualDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"manualdiscount");
        String cashCouponReturnMode = SystemParamUtil.getReturnMode(orgId, branchId, "cashcouponreturnmode");
        BigDecimal couponDiscount = BigDecimal.ZERO;
        if (!StringUtils.equals((CharSequence)cashCouponReturnMode, (CharSequence)ReturnModelEnum.CustomerCompensation.getValue()) && !StringUtils.equals((CharSequence)cashCouponReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue())) {
            couponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"coupondiscount");
        }
        String pointReturnMode = SystemParamUtil.getReturnMode(orgId, branchId, "pointreturnmode");
        BigDecimal integralDistAmount = BigDecimal.ZERO;
        if (!StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)ReturnModelEnum.CustomerCompensation.getValue()) && !StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue())) {
            integralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"integraldistamount");
        }
        BigDecimal finalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"finalpayment");
        BigDecimal receivedFinalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"receivedfinalpayment");
        BigDecimal receExpectFinalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"receexpectfinalamount");
        BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            String returnMode;
            switch (returnMode = CommonUtils.getReturnMode(orgId, branchId)) {
                case "01": 
                case "02": {
                    BigDecimal discountAmt = manualDiscount.add(couponDiscount);
                    if (!isBook) {
                        lineReturnAmount = balAmount.subtract(discountAmt).subtract(finalPayment).add(receivedFinalPayment);
                        break;
                    }
                    lineReturnAmount = deposit.subtract(discountAmt).add(receExpectFinalAmount);
                    break;
                }
                case "10": 
                case "20": {
                    BigDecimal discountAmt = manualDiscount.add(integralDistAmount);
                    if (!isBook) {
                        lineReturnAmount = balAmount.subtract(discountAmt).subtract(finalPayment).add(receivedFinalPayment);
                        break;
                    }
                    lineReturnAmount = deposit.subtract(discountAmt).add(receExpectFinalAmount);
                    break;
                }
                case "11": 
                case "12": 
                case "21": 
                case "22": {
                    if (!isBook) {
                        lineReturnAmount = balAmount.subtract(manualDiscount).subtract(finalPayment).add(receivedFinalPayment);
                        break;
                    }
                    lineReturnAmount = deposit.subtract(manualDiscount).add(receExpectFinalAmount);
                    break;
                }
                default: {
                    BigDecimal discountAmt = manualDiscount.add(couponDiscount).add(integralDistAmount);
                    if (!isBook) {
                        lineReturnAmount = balAmount.subtract(discountAmt).subtract(finalPayment).add(receivedFinalPayment);
                        break;
                    }
                    lineReturnAmount = deposit.subtract(discountAmt).add(receExpectFinalAmount);
                    break;
                }
            }
        } else {
            lineReturnAmount = isBook ? deposit : balAmount.subtract(finalPayment).subtract(manualDiscount).subtract(integralDistAmount).subtract(couponDiscount);
        }
        return lineReturnAmount;
    }

    private static String getReturnMode(long orgId, long branchId) {
        String cashCouponReturnMode = SystemParamUtil.getReturnMode(orgId, branchId, "cashcouponreturnmode");
        String pointReturnMode = SystemParamUtil.getReturnMode(orgId, branchId, "pointreturnmode");
        return cashCouponReturnMode + pointReturnMode;
    }

    private static void updateReceivableAmount(DynamicObject entryEntity, long orgId, long branchId, long billTypeId) {
        BigDecimal lineReturnAmount = CommonUtils.getLineReturnAmount(entryEntity, orgId, branchId, billTypeId);
        entryEntity.set("linereceivableamount", (Object)lineReturnAmount);
    }

    public static DynamicObject getClassstdApply(String applyplatform) {
        QFilter qFilter = new QFilter("applyplatform", "=", (Object)applyplatform);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocdbd_classstdapply");
        Object[] fieldKeys = entityType.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return QueryServiceHelper.queryOne((String)"ocdbd_classstdapply", (String)StringUtils.join((Object[])fieldKeys, (String)","), (QFilter[])qFilter.toArray());
    }

    @Deprecated
    public static boolean doService(IFormView view, String cloudId, String appId, String serviceName, String functionName, Object objParam) {
        boolean result = false;
        try {
            JSONObject jObj = (JSONObject)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)functionName, (Object[])new Object[]{objParam});
            if (jObj == null) {
                view.showErrorNotification("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1anull");
            } else if (StringUtils.equals((CharSequence)"ocgcm", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("success"), (CharSequence)"true")) {
                    result = true;
                } else {
                    String message = jObj.getString("message");
                    view.showErrorNotification("\u793c\u5238\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    result = false;
                }
            } else if (StringUtils.equals((CharSequence)"ocric", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("code"), (CharSequence)"0")) {
                    result = true;
                } else {
                    String message = jObj.getString("message");
                    view.showErrorNotification("\u79ef\u5206\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    result = false;
                }
            }
        }
        catch (Exception ex) {
            view.showErrorNotification("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ex.getMessage());
            result = false;
        }
        return result;
    }

    public static JSONObject doService(String cloudId, String appId, String serviceName, String functionName, Object objParam) {
        JSONObject jsonResult = new JSONObject();
        boolean success = false;
        String message = "";
        try {
            JSONObject jObj = (JSONObject)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)functionName, (Object[])new Object[]{objParam});
            if (jObj == null) {
                message = "\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1anull";
            } else if (StringUtils.equals((CharSequence)"ocgcm", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("success"), (CharSequence)"true")) {
                    success = true;
                } else {
                    success = false;
                    message = "\u793c\u5238\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jObj.getString("message");
                }
            } else if (StringUtils.equals((CharSequence)"ocric", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("code"), (CharSequence)"0")) {
                    success = true;
                } else {
                    success = false;
                    message = "\u79ef\u5206\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jObj.getString("message");
                }
            }
        }
        catch (Exception ex) {
            success = false;
            message = "\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ex.getMessage();
        }
        jsonResult.put("success", (Object)success);
        jsonResult.put("message", (Object)message);
        return jsonResult;
    }

    public static Object getDeptObj(DynamicObject saler) {
        DynamicObject user;
        if (ObjectUtils.isEmpty((Object)saler)) {
            return null;
        }
        long userId = saler.getDynamicObject("sysuser").getLong("id");
        try {
            user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        }
        catch (Exception ex) {
            user = null;
        }
        if (ObjectUtils.isEmpty((Object)user)) {
            return null;
        }
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)user, (String)"entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        return DynamicObjectUtils.get((DynamicObject)((DynamicObject)entryEntity.get(0)), (String)"dpt");
    }

    public static List<DynamicObject> getBarCodeByGoodsId(long branchId, long currencyId, long goodsId) {
        if (goodsId == 0L) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = F7Util.getBarCodeByGoodsIdFilter(branchId, currencyId, goodsId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_item_barcode", (QFilter[])filter.toArray());
        return new ArrayList<DynamicObject>(map.values());
    }

    public static void clearEntryValue(IFormView view, int index, boolean isReserve, boolean isPresent) {
        DynamicObjectCollection entry = view.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return;
        }
        DynamicObject entryItem = (DynamicObject)entry.get(index);
        DynamicObject saleMan = null;
        Object dept = null;
        if (!isPresent) {
            DynamicObjectCollection deliveryEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery");
            deliveryEntry.clear();
            view.updateView("salesorderdelivery");
            saleMan = (DynamicObject)view.getModel().getValue("saler");
            dept = CommonUtils.getDeptObj(saleMan);
        }
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (INV_FIELD_LIST.contains(key) || StringUtils.equals((CharSequence)key, (CharSequence)"id")) continue;
            if (property instanceof BasedataProp) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)"goodssaler") && !ObjectUtils.isEmpty((Object)saleMan)) {
                    entryItem.set(key, (Object)saleMan);
                    continue;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"saledepartment") && !ObjectUtils.isEmpty((Object)dept)) {
                    entryItem.set(key, dept);
                    continue;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"goodsid") || StringUtils.equals((CharSequence)key, (CharSequence)"barcode")) continue;
                entryItem.set(key, null);
                continue;
            }
            if (property instanceof TextProp) {
                entryItem.set(key, null);
                continue;
            }
            if (property instanceof DecimalProp) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)"discountrate")) {
                    entryItem.set(key, (Object)new BigDecimal(100));
                    continue;
                }
                entryItem.set(key, (Object)BigDecimal.ZERO);
                continue;
            }
            if (property instanceof BooleanProp) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)"isbook")) {
                    entryItem.set(key, (Object)isReserve);
                    continue;
                }
                entryItem.set(key, (Object)Boolean.FALSE);
                continue;
            }
            if (!(property instanceof LongProp)) continue;
            if (StringUtils.equals((CharSequence)key, (CharSequence)"goodssaler_id") && !ObjectUtils.isEmpty((Object)saleMan)) {
                entryItem.set(key, (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleMan));
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"saledepartment_id") && !ObjectUtils.isEmpty((Object)dept)) {
                entryItem.set(key, (Object)DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)dept)));
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"goodsid_id") || StringUtils.equals((CharSequence)key, (CharSequence)"barcode_id")) continue;
            entryItem.set(key, (Object)0L);
        }
        view.updateView("goodsentryentity", index);
    }

    public static void clearGoodsPromoteEntry(DynamicObjectCollection docGoodsEntry) {
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObjectCollection docPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
            if (!CollectionUtils.isEmpty((Collection)docPromote)) {
                doGoodsEntry.set("promotiondiscount", (Object)BigDecimal.ZERO);
            }
            docPromote.clear();
        }
    }

    public static List<Long> getItemClassIds(DynamicObject goods) {
        DynamicObjectCollection itemClass = goods.getDynamicObjectCollection("itemclassentity");
        ArrayList<Long> lstItemClassId = new ArrayList<Long>(itemClass.size());
        if (!CollectionUtils.isEmpty((Collection)itemClass)) {
            itemClass.forEach(x -> {
                long goodsClassId = DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsclasssid");
                if (goodsClassId != 0L) {
                    lstItemClassId.add(goodsClassId);
                }
            });
        }
        return lstItemClassId;
    }

    public static void clearFieldValue(String key, IDataModel model) {
        model.setValue(key, null, 0, 0);
    }

    public static void setSaleQtyEnable(IFormView view) {
        DynamicObjectCollection entryEntities = view.getModel().getEntryEntity("goodsentryentity");
        CommonUtils.setSaleQtyEnable(view, entryEntities);
    }

    public static void setSaleQtyEnable(IFormView view, DynamicObjectCollection entryEntities) {
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObject billType = (DynamicObject)view.getModel().getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        for (DynamicObject entryEntity : entryEntities) {
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
            int index = seq > 0 ? seq - 1 : 0;
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            if (billTypeId == BillTypeEnum.RETURN.getId()) {
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
                view.setEnable(Boolean.valueOf(!isPresent && !isEnableSerial), index, new String[]{"saleqty"});
                continue;
            }
            view.setEnable(Boolean.valueOf(!isEnableSerial), index, new String[]{"saleqty"});
        }
    }

    public static void quoTypeControl(IFormView view, String quoType) {
        switch (quoType) {
            case "A": {
                view.setVisible(Boolean.FALSE, new String[]{"pnl_company"});
                view.setVisible(Boolean.TRUE, new String[]{"invoicetype", "pnl_person", "pnl_invoicedetail"});
                FormViewUtil.setMustInput(view, true, "invoicetype");
                CommonUtils.clearCompanyInvoiceInfo(view);
                break;
            }
            case "B": {
                view.setVisible(Boolean.FALSE, new String[]{"pnl_person"});
                view.setVisible(Boolean.TRUE, new String[]{"invoicetype", "pnl_company", "pnl_invoicedetail"});
                FormViewUtil.setMustInput(view, true, "invoicetype");
                CommonUtils.clearPersonInvoiceInfo(view);
                break;
            }
            default: {
                view.setVisible(Boolean.FALSE, new String[]{"invoicetype", "pnl_person", "pnl_company", "pnl_invoicedetail"});
                view.getModel().setValue("invoicetype", null);
                view.getModel().setValue("invoicenumber", null);
                FormViewUtil.setMustInput(view, false, "invoicetype");
                CommonUtils.clearPersonInvoiceInfo(view);
                CommonUtils.clearCompanyInvoiceInfo(view);
            }
        }
    }

    public static void setEnableAboutCvt(IFormView view) {
        boolean isNotConfirm;
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CVTSALE.getId() && !(isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm"))) {
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            view.setEnable(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)entryEntities)), new String[]{"adv_modify"});
        }
    }

    private static void clearPersonInvoiceInfo(IFormView view) {
        view.getModel().setValue("name", null);
        view.getModel().setValue("phonenumber", null);
        view.getModel().setValue("email", null);
    }

    private static void clearCompanyInvoiceInfo(IFormView view) {
        view.getModel().setValue("enterprisename", null);
        view.getModel().setValue("taxnumber", null);
        view.getModel().setValue("enterpriseaddr", null);
        view.getModel().setValue("enterprisetel", null);
        view.getModel().setValue("bank", null);
        view.getModel().setValue("bankaccount", null);
        view.getModel().setValue("enterprisephone", null);
        view.getModel().setValue("enterpriseemail", null);
    }

    public static boolean isChangeReturnOrReturn(DynamicObject dataEntity, DynamicObject entryEntity) {
        IDataEntityProperty property = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"basebilltype");
        long billTypeId = 0L;
        if (property instanceof BasedataProp) {
            billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        } else if (property instanceof BigIntProp) {
            billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        } else if (property instanceof TextProp) {
            String billType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"basebilltype");
            long l = billTypeId = StringUtils.isNotBlank((CharSequence)billType) ? Long.parseLong(billType) : 0L;
        }
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return true;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
            return StringUtils.equals((CharSequence)saleOption, (CharSequence)"0");
        }
        return false;
    }

    public static void buildNewBillParams(AbstractBillPlugIn plugin, DynamicObject dataEntity) {
        IPageCache pageCache = plugin.getPageCache();
        String pageId = plugin.getView().getPageId();
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        String isInit = isInitBill ? "1" : "0";
        pageCache.put(pageId + "-" + "isinitbill", isInit);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        pageCache.put(pageId + "-" + "biztype", bizType);
        long receivingTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"receivingtype");
        pageCache.put(pageId + "-" + "receivingtype", String.valueOf(receivingTypeId));
    }

    public static boolean checkEnableScopeCtrl(long branchId, long orgId, long salerId, long deptId, long goodsId) {
        boolean isEnableUserScopes = SystemParamUtil.getIsEnableUserScopes(orgId, branchId);
        if (!isEnableUserScopes) {
            return true;
        }
        Set<Long> rangeGoods = F7Util.getRangeGoods(branchId, salerId, deptId);
        return rangeGoods.contains(goodsId);
    }

    public static boolean checkMaterialInv(long materialId) {
        String extSql = String.format(" and tm.fid = %s ", materialId);
        List materialIds = PosItemUtil.getPosMaterial((String)extSql);
        return !CollectionUtils.isEmpty((Collection)materialIds);
    }

    public static boolean checkItemsInfo(AbstractFormPlugin plugin, DynamicObject dataEntity, DynamicObject entryEntity, DynamicObject goods) {
        long goodsId;
        long deptId;
        DynamicObject saler;
        long salerId;
        long orgId;
        if (goods == null) {
            return true;
        }
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"material");
        boolean isMaterialRight = CommonUtils.checkMaterialInv(materialId);
        if (!isMaterialRight) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u7ef4\u62a4\u5f53\u524d\u5546\u54c1\u6240\u5c5e\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u6216\u53d8\u66f4\u7269\u6599\u7c7b\u578b\u4e3a\u91d1\u989d/\u670d\u52a1\u7c7b\u578b\u3002", (IFormView)plugin.getView());
            return false;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isItemRight = CommonUtils.checkEnableScopeCtrl(branchId, orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid"), salerId = DynamicObjectUtils.getPkValue((DynamicObject)(saler = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodssaler")), (String)"sysuser"), deptId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"saledepartment"), goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods));
        if (!isItemRight) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u95e8\u5e97\u542f\u7528\u4e86\u4eba\u5458\u53ef\u9500\u8303\u56f4\u63a7\u5236\uff0c \u6240\u9009\u5546\u54c1\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (IFormView)plugin.getView());
            return false;
        }
        return true;
    }

    public static boolean checkSaleRoleReturnAuth(DynamicObject dataEntity) {
        long returnAuth = 1007331513446104460L;
        DynamicObject cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier");
        long cashierRoleId = DynamicObjectUtils.getPkValue((DynamicObject)cashier, (String)"cashierid");
        DynamicObjectCollection authItemData = PayUtil.getAuthItemData(cashierRoleId);
        if (CollectionUtils.isEmpty((Collection)authItemData)) {
            return false;
        }
        return authItemData.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"authority") == returnAuth && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isoperate"));
    }

    public static boolean checkReturnEqualPayAmount(BigDecimal payAmt, String payFlowId) {
        BigDecimal settleAmount;
        DynamicObject srcPaymentFlow = BusinessDataServiceHelper.loadSingle((Object)payFlowId, (String)"ocdbd_paymentflow");
        return srcPaymentFlow != null && (settleAmount = DynamicObjectUtil.getBigDecimal(srcPaymentFlow, "settleamount")).compareTo(payAmt.abs()) == 0;
    }

    public static DynamicObject getPaymentFlow(String payFlowId) {
        if (StringUtils.isBlank((CharSequence)payFlowId)) {
            return new DynamicObject();
        }
        return BusinessDataServiceHelper.loadSingle((Object)payFlowId, (String)"ocdbd_paymentflow");
    }

    static {
        INV_FIELD_LIST.add("keeperid");
        INV_FIELD_LIST.add("keepertype");
        INV_FIELD_LIST.add("ownerid");
        INV_FIELD_LIST.add("ownertype");
        logger = LogFactory.getLog(CommonUtils.class);
    }
}

