/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.saleorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.util.F7Util;

public class InventoryUtils {
    public static List<Long> getOwnerIds(long invOrgId) {
        if (invOrgId == 0L) {
            return new ArrayList<Long>();
        }
        List lstOwnerId = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType(), (Long)invOrgId);
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)invOrgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        if (isAccounting) {
            lstOwnerId.add(0, invOrgId);
        }
        return lstOwnerId.stream().distinct().collect(Collectors.toList());
    }

    public static List<Long> getInvOrgIds(long saleOrgId) {
        if (saleOrgId == 0L) {
            return new ArrayList<Long>();
        }
        List lstInvOrgId = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_SALE.getViewType(), (String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)saleOrgId);
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)saleOrgId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        if (isInventory) {
            lstInvOrgId.add(0, saleOrgId);
        }
        return lstInvOrgId.stream().distinct().collect(Collectors.toList());
    }

    public static List<Long> getInvOrgIds(long saleOrgId, String invQueryRange) {
        Long[] startedInvOrgs = (Long[])DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IStorageOrgService", (String)"getStartedInvOrgIDs", (Object[])new Object[0]);
        if (startedInvOrgs == null || startedInvOrgs.length <= 0) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> startedInvOrgIds = new ArrayList<Long>(Arrays.asList(startedInvOrgs));
        if (StringUtils.equals((CharSequence)invQueryRange, (CharSequence)"0")) {
            List<Long> invOrgIds = InventoryUtils.getInvOrgIds(saleOrgId);
            invOrgIds.retainAll(startedInvOrgIds);
            return invOrgIds;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (userHasPermOrgs != null) {
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
                hasPermOrgs.retainAll(startedInvOrgIds);
                return hasPermOrgs;
            }
            return startedInvOrgIds;
        }
        return new ArrayList<Long>(0);
    }

    public static List<Long> getInvOrgIdsByPur(long purOrgId) {
        if (purOrgId == 0L) {
            return new ArrayList<Long>();
        }
        List lstInvOrgId = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)purOrgId);
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)purOrgId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        if (isInventory) {
            lstInvOrgId.add(0, purOrgId);
        }
        return lstInvOrgId.stream().distinct().collect(Collectors.toList());
    }

    public static List<Long> getInvOrgIdsByStock(long stockId) {
        QFilter filter = F7Utils.getEnableFilter();
        filter.and("startstatus", "=", (Object)"B");
        filter.and("warehouse.id", "=", (Object)stockId);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"im_warehousesetup", (String)"org.id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new ArrayList<Long>(0);
        }
        return data.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"org.id")).distinct().collect(Collectors.toList());
    }

    public static long getDefaultOwnerId(long invOrgId) {
        long orgId = 0L;
        if (InventoryUtils.getOwnerIds(invOrgId).size() > 0) {
            orgId = InventoryUtils.getOwnerIds(invOrgId).get(0);
        }
        return orgId;
    }

    public static long getDefaultInvOrgId(long saleOrgId) {
        if (saleOrgId == 0L) {
            return 0L;
        }
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)saleOrgId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        if (isInventory) {
            return saleOrgId;
        }
        return OrgUnitServiceHelper.getToOrg((String)OrgViewTypeEnum.IS_SALE.getViewType(), (String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)saleOrgId);
    }

    public static long getDefaultInvOrgIdByPur(long purOrgId) {
        if (purOrgId == 0L) {
            return 0L;
        }
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)purOrgId, (String)OrgViewTypeEnum.IS_INVENTORY.getViewType());
        if (isInventory) {
            return purOrgId;
        }
        return OrgUnitServiceHelper.getToOrg((String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)purOrgId);
    }

    public static DynamicObject getDefaultOwner(long invOrgId) {
        try {
            long defOwnerId = InventoryUtils.getDefaultOwnerId(invOrgId);
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defOwnerId, (String)"bos_org");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static DynamicObject getDefaultInvOrg(long saleOrgId) {
        try {
            long defInvOrgId = InventoryUtils.getDefaultInvOrgId(saleOrgId);
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defInvOrgId, (String)"bos_org");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static DynamicObject getDefaultInvOrgByPur(long purOrgId) {
        try {
            long defInvOrgId = InventoryUtils.getDefaultInvOrgIdByPur(purOrgId);
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defInvOrgId, (String)"bos_org");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static DynamicObject getDefaultKeeper(long defKeepId) {
        try {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defKeepId, (String)"bos_org");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static DynamicObject getDefaultChannelStock(DynamicObject channel) {
        QFilter qFilter = F7Util.getStockIdFilter(channel);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ococic_warehouse");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject[] channelStocks = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])qFilter.toArray());
        if (channelStocks != null && channelStocks.length > 0) {
            return Arrays.stream(channelStocks).filter(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isdelivery")).findFirst().orElse(null);
        }
        return null;
    }

    public static long getDefaultChannelStockId(DynamicObject channel) {
        DynamicObject defChannelStock = InventoryUtils.getDefaultChannelStock(channel);
        return DynamicObjectUtils.getPkValue((DynamicObject)defChannelStock);
    }

    public static DynamicObject getInvOrg(DynamicObject channel) {
        DynamicObject defChannelStock = InventoryUtils.getDefaultChannelStock(channel);
        return DynamicObjectUtils.getDynamicObject((DynamicObject)defChannelStock, (String)"erpstockorgid");
    }

    public static DynamicObject getSnMainFile(String serialNum, long materialId, long auxPtyId) {
        QFilter filter = new QFilter("number", "=", (Object)serialNum);
        filter.and("material.id", "=", (Object)materialId);
        filter.and("auxpty", "=", (Object)auxPtyId);
        return QueryServiceHelper.queryOne((String)"bd_snmainfile", (String)"id, snstatus, lotnumber", (QFilter[])filter.toArray());
    }
}

