/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.saleorder;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class UnitTransferUtils {
    public static void updateMultiQuantities(IFormView view, DynamicObject entryItem, BigDecimal saleQty) {
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"materielid");
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"unit");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)unit);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"baseunit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)baseUnit);
        if (materialId == 0L || unitId == 0L || baseUnitId == 0L) {
            return;
        }
        String baseUnitName = DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name");
        BigDecimal baseUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        if (baseUnitQty.compareTo(BigDecimal.ZERO) == 0) {
            String unitName = DynamicObjectUtils.getString((DynamicObject)unit, (String)"name");
            String tip = String.format("\u6362\u7b97\u5931\u8d25,\u627e\u4e0d\u5230\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", unitName, baseUnitName);
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
            return;
        }
        entryItem.set("baseunitqty", (Object)baseUnitQty);
        UnitTransferUtils.updateOtherQuantities(view, entryItem, baseUnitQty, materialId, baseUnitId, baseUnitName);
    }

    public static void updateMultiQuantities(IFormView view, DynamicObject entryItem, DynamicObject unit) {
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"materielid");
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"baseunit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)baseUnit);
        if (materialId == 0L || baseUnitId == 0L) {
            return;
        }
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)unit);
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"baseunitqty");
        BigDecimal saleQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseUnitQty, (Long)materialId, (Long)baseUnitId, (Long)unitId);
        String baseUnitName = DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name");
        if (saleQty.compareTo(BigDecimal.ZERO) == 0) {
            String unitName = DynamicObjectUtils.getString((DynamicObject)unit, (String)"name");
            String tip = String.format("\u6362\u7b97\u5931\u8d25,\u627e\u4e0d\u5230\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", unitName, baseUnitName);
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
            return;
        }
        entryItem.set("saleqty", (Object)saleQty);
        UnitTransferUtils.updateOtherQuantities(view, entryItem, baseUnitQty, materialId, baseUnitId, baseUnitName);
    }

    public static void updateOtherQuantities(IFormView view, DynamicObject entryItem, BigDecimal baseUnitQty, long materialId, long baseUnitId, String baseUnitName) {
        DynamicObject stockUnit;
        long stockUnitId;
        DynamicObject auxUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"auxunit");
        long auxUnitId = DynamicObjectUtils.getPkValue((DynamicObject)auxUnit);
        if (auxUnitId != 0L) {
            BigDecimal auxUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseUnitQty, (Long)materialId, (Long)baseUnitId, (Long)auxUnitId);
            entryItem.set("auxunitqty", (Object)auxUnitQty);
        }
        if ((stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)(stockUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"stockunit")))) != 0L) {
            BigDecimal stockUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseUnitQty, (Long)materialId, (Long)baseUnitId, (Long)stockUnitId);
            if (stockUnitQty.compareTo(BigDecimal.ZERO) == 0) {
                String stockUnitName = DynamicObjectUtils.getString((DynamicObject)stockUnit, (String)"name");
                String tip = String.format("\u6362\u7b97\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5e93\u5b58\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", stockUnitName, baseUnitName);
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
                return;
            }
            entryItem.set("stockunitqty", (Object)stockUnitQty);
        }
    }

    public static void updateDeliveryMultiQuantities(IFormView view, DynamicObject object, BigDecimal saleQty) {
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)object, (String)"deliverymaterial");
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)object, (String)"deliverunitid");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)unit);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)object, (String)"deliverybaseunit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)baseUnit);
        if (materialId == 0L || unitId == 0L || baseUnitId == 0L) {
            return;
        }
        String baseUnitName = DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name");
        BigDecimal baseUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        if (baseUnitQty.compareTo(BigDecimal.ZERO) == 0) {
            String unitName = DynamicObjectUtils.getString((DynamicObject)unit, (String)"name");
            String tip = String.format("\u6362\u7b97\u5931\u8d25,\u627e\u4e0d\u5230\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", unitName, baseUnitName);
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
            return;
        }
        object.set("deliverybaseunitqty", (Object)baseUnitQty);
        UnitTransferUtils.updateDeliveryOtherQuantities(view, object, baseUnitQty, materialId, baseUnitId, baseUnitName);
    }

    public static void updateDeliveryOtherQuantities(IFormView view, DynamicObject object, BigDecimal baseUnitQty, long materialId, long baseUnitId, String baseUnitName) {
        DynamicObject stockUnit;
        long stockUnitId;
        DynamicObject auxUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)object, (String)"deliveryauxunit");
        long auxUnitId = DynamicObjectUtils.getPkValue((DynamicObject)auxUnit);
        if (auxUnitId != 0L) {
            BigDecimal auxUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseUnitQty, (Long)materialId, (Long)baseUnitId, (Long)auxUnitId);
            object.set("deliveryauxunitqty", (Object)auxUnitQty);
        }
        if ((stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)(stockUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)object, (String)"deliverystockunit")))) != 0L) {
            BigDecimal stockUnitQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseUnitQty, (Long)materialId, (Long)baseUnitId, (Long)stockUnitId);
            if (stockUnitQty.compareTo(BigDecimal.ZERO) == 0) {
                String stockUnitName = DynamicObjectUtils.getString((DynamicObject)stockUnit, (String)"name");
                String tip = String.format("\u6362\u7b97\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5e93\u5b58\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", stockUnitName, baseUnitName);
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
                return;
            }
            object.set("deliverystockunitqty", (Object)stockUnitQty);
        }
    }

    public static BigDecimal updateMultiQuantities(DynamicObject entity, BigDecimal saleQty) {
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entity, (String)"materielid");
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)entity, (String)"unit");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)unit);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entity, (String)"baseunit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)baseUnit);
        if (materialId == 0L || unitId == 0L || baseUnitId == 0L) {
            return saleQty;
        }
        String baseUnitName = DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name");
        return UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
    }
}

