/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.occ.ocpos.common.util.StringJoin;

public class CommonUtil {
    private static final Log LOG = LogFactory.getLog(CommonUtil.class);
    private static final Pattern P1 = Pattern.compile("^(100|[0-9]\\d|\\d)$");
    private static final Pattern P2 = Pattern.compile("^([0-9]{1,7}|[0-9]{0,7}[.][0-9]{0,2})$");

    @Deprecated
    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).size() == 0) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        if (!(form instanceof AbstractFormPlugin)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u63d2\u4ef6\u4e0d\u662fkd.bos.form.plugin.AbstractFormPlugin\u5b50\u7c7b\uff0c\u4e0d\u80fd\u4f7f\u7528FormUtils.addF7Listener", (String)"FormUtils_0", (String)"scmc-im-common", (Object[])new Object[0]), form.getClass().getSimpleName()));
        }
        AbstractFormPlugin loaclForm = (AbstractFormPlugin)form;
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)loaclForm.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public static String getPhone(String mobile) {
        if (StringUtils.isEmpty((String)mobile)) {
            return "";
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static <T> void sortList(Comparator<T> c, List<T> list) {
        Object[] a = list.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = list.listIterator();
        for (Object e : a) {
            i.next();
            i.set(e);
        }
    }

    public static String getVipCard(String card) {
        if (StringUtils.isEmpty((String)card)) {
            return "";
        }
        return card.replaceAll("(.{3})(?:.+)(.{4})", "$1****$2");
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        if (delimiter != null && elements != null) {
            StringJoin joiner = new StringJoin(delimiter);
            for (CharSequence charSequence : elements) {
                joiner.add(charSequence);
            }
            return joiner.toString();
        }
        return "";
    }

    public static String getUUIDRandom() {
        return UUID.randomUUID().toString();
    }

    public static String formatInputMoney(String input) {
        if (input == null || "".equals(input)) {
            return "";
        }
        double m = CommonUtil.formatStringToDouble(CommonUtil.formatStringPointTwo(input));
        if (String.valueOf(CommonUtil.formatStringToDouble(input)).contains("E")) {
            return "0";
        }
        return String.valueOf(m);
    }

    public static Matcher getMathBeforeSevenAfterTwo(String value) {
        return P2.matcher(value);
    }

    public static String formatInputStr(String value, String source, int dstart) {
        boolean isAddBefore = false;
        if (value.contains(".")) {
            String[] s = value.split("[.]");
            String beforeStr = "";
            if (s.length > 0) {
                beforeStr = s[0];
            }
            if (beforeStr.length() >= dstart) {
                isAddBefore = true;
            }
        }
        value = isAddBefore ? source + value : value + source;
        return value;
    }

    public static Matcher getMatchZeroHundred(String value) {
        return P1.matcher(value);
    }

    public static String formatMoney(String data) {
        double num = 0.0;
        try {
            num = Double.parseDouble(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CommonUtil.formatMoney(num);
    }

    public static String formatMoney(double data) {
        return "\uffe5" + String.format("%.2f", data);
    }

    public static String formatStringToEmpty(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        return data;
    }

    public static String formatStringToEmpty(Object data) {
        if (data == null) {
            return "";
        }
        return String.valueOf(data);
    }

    public static String formatEmptyStringZero(String formatValue) {
        return CommonUtil.formatEmptyString(formatValue, "0");
    }

    public static String formatEmptyString(String formatValue, String value) {
        if (StringUtils.isEmpty((String)formatValue)) {
            return value;
        }
        return formatValue;
    }

    public static String getMulNo(int length, int number) {
        return String.format("%0" + length + "d", number);
    }

    public static double formatStringToDouble(String data, int length) {
        double num = CommonUtil.formatStringToDouble(data);
        return CommonUtil.formatDouble(num, length, true);
    }

    public static double formatStringToShort(String data) {
        short num = 0;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            num = Short.parseShort(data);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static double formatStringToDouble(String data) {
        double num = 0.0;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            num = Double.parseDouble(data);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static String addEmpty(String one, String two, String three, int addLength) {
        int i;
        int oneLength = 18;
        int twoLength = 31;
        int threeLength = 48;
        StringBuilder totalStr = new StringBuilder();
        for (i = 0; i < oneLength - one.length(); ++i) {
            totalStr.append(' ');
        }
        totalStr.append(one);
        for (i = 0; i < twoLength - oneLength - two.length(); ++i) {
            totalStr.append(' ');
        }
        totalStr.append(two);
        for (i = 0; i < threeLength - twoLength - three.length() - addLength; ++i) {
            totalStr.append(' ');
        }
        totalStr.append(three);
        return totalStr.toString();
    }

    public static int addLength(String name) {
        return name.length() - 2;
    }

    public static double formatDouble(double price, int newScale, boolean isUp) {
        BigDecimal b3 = new BigDecimal(Double.toString(price));
        return b3.setScale(newScale, isUp ? 4 : 3).doubleValue();
    }

    public static int formatInt(double price, boolean isUp) {
        return (int)CommonUtil.formatDouble(price, 0, isUp);
    }

    public static String doubleDecimalFormat(double d) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(d);
    }

    public static String addEmpty(String left, String right, int addLength) {
        int totalLength = "---------------------------------------------".length();
        StringBuilder totalStr = new StringBuilder(left);
        if (left.length() + right.length() < totalLength) {
            for (int i = 0; i < totalLength - left.length() - right.length() - addLength; ++i) {
                totalStr.append(' ');
            }
        }
        totalStr.append(right);
        return totalStr.toString();
    }

    public static String addEmpty(String left, String right, int addLength, int addRight) {
        int totalLength = 48;
        StringBuilder totalStr = new StringBuilder(left);
        if (left.length() + right.length() < totalLength) {
            for (int i = 0; i < totalLength - left.length() - right.length() - addLength; ++i) {
                totalStr.append(' ');
            }
        }
        totalStr.append(right);
        return totalStr.toString();
    }

    public static String formatStringPointTwo(String data) {
        try {
            double result = Double.parseDouble(data);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            data = new DecimalFormat("#0.00").format(result);
            return data;
        }
        catch (Exception e) {
            LOG.error(String.format("\u3010formatStringPointTwo(String)\u3011%s", e.getMessage()));
            return "0";
        }
    }

    public static String formatStringPointTwo(double data) {
        try {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            return new DecimalFormat("#0.00").format(data);
        }
        catch (Exception e) {
            LOG.error(String.format("\u3010formatStringPointTwo(double)\u3011%s", e.getMessage()));
            return String.valueOf(data);
        }
    }

    public static String formatStringPointZero(String data) {
        try {
            double result = Double.parseDouble(data);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(0);
            df.setMinimumFractionDigits(0);
            data = new DecimalFormat("#0").format(result);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return data;
    }

    public static byte formatStringToByte(String data) {
        byte num = 0;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            return Byte.parseByte(data);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return num;
        }
    }

    public static char formatStringToCharAt(String data) {
        char num = '0';
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            return data.charAt(0);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return num;
        }
    }

    public static int formatStringToInt(String data) {
        int num = 0;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            num = Double.valueOf(data.trim()).intValue();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static int formatObjectToInt(Object data) {
        int num = 0;
        try {
            if (ObjectUtils.isEmpty((Object)data)) {
                return num;
            }
            num = Double.valueOf(String.valueOf(data).trim()).intValue();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static float formatStringToFloat(String data) {
        float num = 0.0f;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            return Float.parseFloat(data);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return num;
        }
    }

    public static long formatStringToLong(String data) {
        long num = 0L;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            num = Long.parseLong(data.trim());
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static long formatObejctToLong(Object data) {
        try {
            if (StringUtils.isEmpty((String)data.toString())) {
                return 0L;
            }
            return Long.parseLong(data.toString().trim());
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return 0L;
        }
    }

    public static int formatStringNumberToInt(String data) {
        int num = 0;
        try {
            if (StringUtils.isEmpty((String)data)) {
                return num;
            }
            double douNum = Double.parseDouble(data);
            num = (int)douNum;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return num;
    }

    public static String formatDoubleToString(double formatValue) {
        return CommonUtil.formatDoubleToString(formatValue, 2);
    }

    private static String formatDoubleToString(double formatValue, int length) {
        StringBuilder formatStr = new StringBuilder("#");
        if (length == 2) {
            formatStr.append(".##");
        } else if (length > 0) {
            formatStr.append('.');
            for (int i = 0; i < length; ++i) {
                formatStr.append('#');
            }
        }
        DecimalFormat nf = new DecimalFormat(formatStr.toString());
        return nf.format(formatValue);
    }

    public static String formatDoubleToString2(double formatValue, int length) {
        StringBuilder formatStr = new StringBuilder("#");
        if (length == 2) {
            formatStr.append(".##");
        } else if (length > 0) {
            formatStr.append('.');
            for (int i = 0; i < length; ++i) {
                formatStr.append('#');
            }
        }
        DecimalFormat nf = new DecimalFormat(formatStr.toString());
        nf.setRoundingMode(RoundingMode.HALF_UP);
        return nf.format(formatValue);
    }

    public static <T, V> List<T> setMapToList(Map<V, T> map) {
        ArrayList<T> list = new ArrayList<T>(map.size());
        Set<Map.Entry<V, T>> entryMap = map.entrySet();
        for (Map.Entry<V, T> entry : entryMap) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static boolean StringIsDouble(String data) {
        try {
            Double.parseDouble(data);
            return true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return false;
        }
    }

    public static boolean isNumber(Object obj) {
        try {
            Double.parseDouble(obj.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isZero(Object obj) {
        try {
            return 0 == BigDecimal.ZERO.compareTo(new BigDecimal(obj.toString()));
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((String)fullName)) {
            return "";
        }
        String name = fullName.substring(0, 1);
        return fullName.replaceFirst(name, "*");
    }

    public static int countLength(String line) {
        int length = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c > '\u007f') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String doubleFormat(String s) {
        double d = Double.parseDouble(s);
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(d);
    }

    public static double getPositiveValue(double value) {
        if (value >= 0.0) {
            return value;
        }
        return value * -1.0;
    }

    public static double getPositiveValue(String value) {
        double result = CommonUtil.formatStringToDouble(value);
        return CommonUtil.getPositiveValue(result);
    }

    public static boolean isNumeric(String str) {
        if (str != null && !"".equals(str.trim())) {
            return str.matches("^[0-9]*$");
        }
        return false;
    }

    public static boolean formatObjectToBoolean(Object obj) {
        try {
            return Boolean.parseBoolean(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BigDecimal formatObjectToDecimal(Object obj) {
        try {
            return new BigDecimal(obj.toString());
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static boolean checkPhone(String phone) {
        if (StringUtils.isBlank((String)phone)) {
            return false;
        }
        return phone.matches("^[1]\\d{10}$");
    }

    public static boolean checkChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (ObjectUtils.isEmpty((Object)newValue) || ObjectUtils.isEmpty((Object)oldValue)) {
            return false;
        }
        return newValue.equals(oldValue);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static <T> List<T> castList(Object obj, Class<? extends T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                String string = JSONObject.toJSONString(o);
                Object t = JSONObject.parseObject((String)string, clazz);
                result.add(t);
            }
            return result;
        }
        return null;
    }

    public static String getKeeperTypeByCode(Object type) {
        if (type == null) {
            return "";
        }
        switch (type.toString()) {
            case "bos_org": {
                return "\u5e93\u5b58\u7ec4\u7ec7";
            }
            case "bd_customer": {
                return "\u5ba2\u6237";
            }
            case "bd_supplier": {
                return "\u4f9b\u5e94\u5546";
            }
        }
        return "";
    }
}

