/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.Enumeration;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ComputerPhysicsUtil {
    private static final Log LOG = LogFactory.getLog(ComputerPhysicsUtil.class, (String)"ocpos");

    public static String getMacAddress() {
        String mac = "";
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("Windows")) {
            try {
                String line;
                String command = "cmd.exe /c ipconfig /all";
                Process p = Runtime.getRuntime().exec(command);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), "GBK"));
                while ((line = br.readLine()) != null) {
                    LOG.info("\u5f53\u524d\u547d\u4ee4:" + line);
                    if (line.indexOf("\u7269\u7406\u5730\u5740") <= 0) continue;
                    int index = line.indexOf(":") + 2;
                    mac = line.substring(index);
                    break;
                }
                br.close();
            }
            catch (IOException e) {
                throw new KDBizException("\u83b7\u53d6\u7269\u7406\u5730\u5740\u5931\u8d25");
            }
        }
        return mac;
    }

    public static String getMacAddressByNetwork() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp() || (mac = netInterface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
        }
        catch (Exception e) {
            throw new KDBizException("\u83b7\u53d6\u7269\u7406\u5730\u5740\u5931\u8d25");
        }
        return "";
    }
}

