/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.DbUtil;
import kd.occ.ocdbd.business.helper.channeluser.MemberScopeHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class F7Util {
    private static final Log LOG = LogFactory.getLog(F7Util.class);

    public static QFilter getBarCodeIdFilter(Set<Long> barCodeId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("Id", "in", barCodeId);
        return qFilter;
    }

    public static QFilter getBarCodeByGoodsIdFilter(long branchId, long currencyId, long goodsId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        List<Long> lstBarCodeId = F7Util.getBarCodeIdListByGoodsId(branchId, currencyId, goodsId);
        qFilter.and("Id", "in", (Object)lstBarCodeId.stream().distinct().toArray());
        return qFilter;
    }

    public static QFilter getGoodsInfoFilter(long goodsId, long branchId, long barcodeId, long currencyId) {
        QFilter filter = new QFilter("channelid.id", "=", (Object)branchId);
        filter.and("barcodeid.id", "=", (Object)barcodeId);
        filter.and("itemid.id", "=", (Object)goodsId);
        filter.and("currencyid.id", "=", (Object)currencyId);
        return filter;
    }

    public static QFilter getStockIdFilter(DynamicObject saleBrach) {
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        Long branchId = DynamicObjectUtil.getPkValue(saleBrach);
        qFilter.and("ownerchannelid.Id", "=", (Object)branchId);
        return qFilter;
    }

    public static QFilter getBranchSalerFilter() {
        QFilter qFilter = F7Utils.getEnableStatus();
        qFilter.and(F7Utils.getDataStatus());
        List<Long> brachIdList = OwnerUtil.getOwnerIds("iscashier");
        qFilter.and("Id", "in", brachIdList);
        return qFilter;
    }

    public static QFilter getBranchSalerFilterToStore() {
        QFilter qFilter = F7Utils.getEnableStatus();
        List<Long> brachIdList = OwnerUtil.getOwnerIds("iscashier");
        if (brachIdList == null || brachIdList.isEmpty()) {
            brachIdList = OwnerUtil.getOwnerIds("issaler");
        } else if (OwnerUtil.getOwnerIds("issaler") != null) {
            brachIdList.addAll(OwnerUtil.getOwnerIds("issaler"));
        }
        qFilter.and("Id", "in", brachIdList);
        qFilter.and("status", "=", (Object)"C");
        return qFilter;
    }

    public static QFilter getBranchIdFilter() {
        QFilter qFilter = F7Utils.getEnableStatus();
        List<Long> brachIdList = OwnerUtil.getOwnerIds(new String[0]);
        qFilter.and("Id", "in", brachIdList);
        qFilter.and("status", "=", (Object)"C");
        return qFilter;
    }

    public static QFilter getStockPositionidFilter(long warehouseid) {
        QFilter qFilter = F7Utils.getEnableStatus();
        qFilter.and("warehouseid.Id", "=", (Object)warehouseid);
        return qFilter;
    }

    public static QFilter getErpStockPositionidFilter(long erpStokId) {
        QFilter filter = F7Utils.getEnableStatus();
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        qFilter.and("id", "=", (Object)erpStokId);
        DynamicObject erpStock = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])qFilter.toArray());
        DynamicObjectCollection erpStockPositions = DynamicObjectUtil.getDynamicObjectCollection(erpStock, "entryentity");
        if (erpStockPositions != null && erpStockPositions.size() > 0) {
            filter.and("id", "in", (Object)erpStockPositions.stream().map(x -> DynamicObjectUtil.getPkValue(x, "location")).toArray());
        }
        return filter;
    }

    public static QFilter getSalerFilter(long salebranchId) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("owner", "=", (Object)salebranchId);
        filter.and("issaler", "=", (Object)"1");
        return filter;
    }

    public static QFilter getDistributionModeFilter(DynamicObject goods) {
        String operationModel = DynamicObjectUtil.getString(goods, "operationmodel");
        long[] jointModes = new long[]{926600963786061824L, 926601157210585088L};
        QFilter filter = null;
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            filter = new QFilter("id", "in", (Object)jointModes);
        } else if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"1")) {
            filter = new QFilter("id", "not in", (Object)jointModes);
        }
        return filter;
    }

    public static QFilter getSaleDeptFilter(DynamicObject saler) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        ArrayList<Long> deptF7List = new ArrayList<Long>();
        long userId = DynamicObjectUtils.getPkValue((DynamicObject)saler, (String)"sysuser");
        if (userId != 0L) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            DynamicObjectCollection entryEntities = user.getDynamicObjectCollection("entryentity");
            if (entryEntities == null) {
                return filter;
            }
            for (DynamicObject entryEntity : entryEntities) {
                deptF7List.add(entryEntity.getDynamicObject("dpt").getLong("id"));
            }
        }
        return filter.and("id", "in", deptF7List);
    }

    public static QFilter getBillTypeFilter(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        QFilter filter = null;
        switch (type) {
            case "DGD": {
                filter = new QFilter("id", "=", (Object)BillTypeEnum.STORE.getId());
                break;
            }
            case "SXD": {
                filter = new QFilter("id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.RESERVE.getId(), BillTypeEnum.CVTSALE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                break;
            }
            case "LSWKD": 
            case "RETURNSALE": 
            case "CHANGE": {
                filter = new QFilter("id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.CVTSALE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                break;
            }
            case "YDWKD": 
            case "CANCELORDER": {
                filter = new QFilter("id", "=", (Object)BillTypeEnum.RESERVE.getId());
                break;
            }
            case "CVTSALE": {
                filter = new QFilter("id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.RESERVE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                break;
            }
        }
        return filter;
    }

    public static QFilter getStockOrgFilter(long saleOrgId, String invQueryRange) {
        List<Long> invOrgIds = InventoryUtils.getInvOrgIds(saleOrgId, invQueryRange);
        if (CollectionUtils.isEmpty(invOrgIds)) {
            return F7Utils.getEveFalseFilter();
        }
        return new QFilter("id", "in", invOrgIds);
    }

    public static QFilter getMaterialInvFilter() {
        QFilter filter = new QFilter("masterid.status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("masterid.enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and(F7Utils.getCommonStatusFilter());
        return filter;
    }

    public static QFilter getMaterialFilter(String materialKey) {
        QFilter materialInvFilter = F7Util.getMaterialInvFilter();
        DynamicObjectCollection materialInvData = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])materialInvFilter.toArray());
        QFilter filter = null;
        if (materialInvData != null) {
            List materialIds = materialInvData.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"masterid")).collect(Collectors.toList());
            filter = new QFilter(materialKey, "in", materialIds);
        }
        return filter;
    }

    public static QFilter getSaleContentFilter(long branchId, long currencyId, String joinEntity, String selectField) {
        String joinSql = String.format("inner join (select distinct %s as itemid from t_ocdbd_itemcontent where fchannelid = ? and fenable = '1' AND fcurrencyid = ?) tc on tc.itemid = %s.fid", selectField, joinEntity);
        return QFilter.joinSQL((String)joinEntity, (String)joinSql, (Object[])new Object[]{branchId, currencyId});
    }

    public static QFilter getSaleContentFilter(long branchId, long currencyId, String selectField) {
        long start = TimeServiceHelper.getTimeStamp();
        String sql = String.format("select %s from t_ocdbd_itemcontent where fchannelid = ? and fenable = '1' AND fcurrencyid = ? group by %s", selectField, selectField);
        Object[] params = new Object[]{branchId, currencyId};
        Set goodsIds = (Set)DB.query((DBRoute)DbUtil.OCC_DB, (String)sql, (Object[])params, rs -> {
            HashSet<Long> data = new HashSet<Long>(20);
            while (rs.next()) {
                data.add(rs.getLong(selectField));
            }
            return data;
        });
        long end = TimeServiceHelper.getTimeStamp();
        LOG.info("\u5f00\u5355\u5546\u54c1\u67e5\u7ecf\u8425\u76ee\u5f55\u8017\u65f6\uff1a" + (end - start) + "ms");
        if (CollectionUtils.isEmpty((Collection)goodsIds)) {
            return F7Utils.getEveFalseFilter();
        }
        return new QFilter("id", "in", (Object)goodsIds);
    }

    public static Set<Long> getRangeGoods(long branchId, long saleManId, long saleDeptId) {
        List lstRangeGoodsIdByPart;
        HashSet<Long> range = new HashSet<Long>(0);
        List lstRangeGoodsIdByUser = MemberScopeHelper.queryItemByUser((Long)saleManId, (Long)saleDeptId, (Long)branchId);
        if (!CollectionUtils.isEmpty((Collection)lstRangeGoodsIdByUser)) {
            range.addAll(lstRangeGoodsIdByUser);
        }
        if (!CollectionUtils.isEmpty((Collection)(lstRangeGoodsIdByPart = MemberScopeHelper.queryItemByPart((Long)saleDeptId, (Long)branchId)))) {
            range.addAll(lstRangeGoodsIdByPart);
        }
        return range;
    }

    public static List<Long> getBarCodeIdListByGoodsId(long branchId, long currencyId, long goodsId) {
        QFilter filter = PosItemUtil.getSaleContentByGoodsIdFilter((long)branchId, (long)currencyId, (long)goodsId);
        String selectFields = String.join((CharSequence)",", "itemid", "barcodeid");
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (DynamicObject datum : data) {
            long pkId = DynamicObjectUtils.getLong((DynamicObject)datum, (String)"barcodeid");
            if (result.contains(pkId)) continue;
            result.add(pkId);
        }
        return result;
    }

    public static QFilter getF7SaleContentFilter(long branchId, long currencyId, String joinProperty) {
        String exp = "ocdbd_itemsalecontent.channelid = ? and ocdbd_itemsalecontent.currencyid = ? and ocdbd_itemsalecontent.enable = '1' ";
        QFilter filter = QFilter.of((String)exp, (Object[])new Object[]{branchId, currencyId});
        return QFilter.join((String)"id", (String)joinProperty, (QFilter)filter);
    }
}

