/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.JsonUtil;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class OlstoreUtil {
    protected static Log logger = LogFactory.getLog(OlstoreUtil.class);
    public static final String storekey = "storeinfo";
    public static final String addresskey = "addressinfo_cache";

    public static JSONObject getCurrentStore(ClientEvent event) {
        String storecache = event.getLocalStorage().getString(storekey);
        if (StringUtil.isNotNull(storecache)) {
            return JsonUtil.fromJson(storecache, JSONObject.class);
        }
        return null;
    }

    public static JSONObject getCurrentAddress(ClientEvent event) {
        String addresscache = event.getLocalStorage().getString(addresskey);
        if (StringUtil.isNotNull(addresscache)) {
            return JsonUtil.fromJson(addresscache, JSONObject.class);
        }
        return null;
    }

    public static long getStoreId(ClientEvent event) {
        JSONObject storeJson = OlstoreUtil.getCurrentStore(event);
        if (storeJson != null) {
            return storeJson.getLong("id");
        }
        return 0L;
    }

    public static String getStoreName(ClientEvent event) {
        JSONObject storeJson = OlstoreUtil.getCurrentStore(event);
        if (storeJson != null) {
            return storeJson.getString("name");
        }
        return "";
    }

    public static String getTicketApplyTerminal(int type) {
        switch (type) {
            case 0: {
                return "\u7ebf\u4e0a\u7ebf\u4e0b\u901a\u7528";
            }
            case 1: {
                return "\u7ebf\u4e0a\u901a\u7528";
            }
            case 2: {
                return "\u7ebf\u4e0b\u901a\u7528";
            }
        }
        return null;
    }

    public static void setCurrentStore(ExtDynamicView<?> view, String storeJson) {
        view.putLocalStoragePrivate(storekey, (Object)storeJson, true, 99, true);
    }

    public static void setCurrentAddress(ExtDynamicView<?> view, String addressJson) {
        view.putLocalStoragePrivate(addresskey, (Object)addressJson, true, 99, true);
    }

    public static boolean compareMap(Map<String, String> map1, Map<String, String> map2) {
        for (Map.Entry<String, String> entry : map1.entrySet()) {
            String testKey = entry.getKey();
            if (map1.get(testKey).equals(map2.get(testKey))) continue;
            return false;
        }
        return true;
    }

    public static void addToMap(JSONObject specValue, Map<String, String> specMap) {
        specMap.put(specValue.getString("key"), specValue.getString("value"));
    }

    public static void descartes(Map.Entry[] dimvalue, List<Map<String, String>> result, int layer, Map<String, String> curJsonObject) {
        block7: {
            List value;
            block6: {
                value = (List)dimvalue[layer].getValue();
                if (layer >= dimvalue.length - 1) break block6;
                if (value.size() == 0) {
                    OlstoreUtil.descartes(dimvalue, result, layer + 1, curJsonObject);
                } else {
                    for (int i = 0; i < value.size(); ++i) {
                        HashMap<String, String> map = new HashMap<String, String>(curJsonObject);
                        map.put((String)dimvalue[layer].getKey(), (String)value.get(i));
                        OlstoreUtil.descartes(dimvalue, result, layer + 1, map);
                    }
                }
                break block7;
            }
            if (layer != dimvalue.length - 1) break block7;
            if (value.size() == 0) {
                result.add(curJsonObject);
            } else {
                for (int i = 0; i < value.size(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>(curJsonObject);
                    map.put((String)dimvalue[layer].getKey(), (String)value.get(i));
                    result.add(map);
                }
            }
        }
    }

    public static String buildItemParamAppendStr() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("itemid.baseunit", "baseunitid");
        map.put("barcodeid.unit", "unitid");
        map.put("barcodeid.auxpty", "auxptyid");
        map.put("barcodeid.materiel", "materielid");
        map.put("itemid.retailunit", "retailunit");
        map.put("itemid.shorttitle", "shorttitle");
        map.put("itemid.itembrands", "itembrands");
        map.put("itemid.itemclassentity", "itemclass");
        map.put("barcodeid.id", "barcodeid");
        return SerializationUtils.toJsonString(map);
    }

    public static BigDecimal getBigDecimal(BigDecimal value) {
        return value.compareTo(BigDecimal.valueOf(0.0)) == 0 ? BigDecimal.ZERO : value;
    }

    public static OpenParam createOpenParam(String fromViewId, String toViewId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setViewId(toViewId);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("sourceviewid", fromViewId);
        return openParam;
    }

    public static CallBackArgu createBtnCallBackArgu(String actionKey, String btn) {
        CallBackArgu callBackArgu = new CallBackArgu();
        callBackArgu.setActionKey(actionKey);
        callBackArgu.put((Object)"btn", (Object)btn);
        return callBackArgu;
    }

    public static CallBackArgu createCustomMessageCallBackArgu(String actionKey, String customMessage) {
        CallBackArgu callBackArgu = new CallBackArgu();
        callBackArgu.setActionKey(actionKey);
        callBackArgu.put((Object)"customMessage", (Object)customMessage);
        return callBackArgu;
    }

    public static String buildShareUrl(Map<String, Object> paramMap) {
        StringBuilder url = new StringBuilder("?viewId=");
        url.append(paramMap.remove("viewId"));
        Set<Map.Entry<String, Object>> entrySet = paramMap.entrySet();
        for (Map.Entry<String, Object> item : entrySet) {
            String key = item.getKey();
            Object value = item.getValue();
            url.append('&').append(key).append('=').append(value);
        }
        return url.toString();
    }

    public static Map<String, Object> buildFromToViewMap(String sourceViewId, String toViewId) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("sourceviewid", sourceViewId);
        map.put("viewId", toViewId);
        return map;
    }

    public static String getGuideParamInfo(String paramId) {
        QFilter qFilter = new QFilter("paramid", "=", (Object)paramId);
        DynamicObject olatoreParamNote = QueryServiceHelper.queryOne((String)"ocpos_olatoreparamnote", (String)"id,param", (QFilter[])new QFilter[]{qFilter});
        return DynamicObjectUtils.getString((DynamicObject)olatoreParamNote, (String)"param");
    }

    public static JSONObject getGuideParamJSONObject(String paramId) {
        QFilter qFilter = new QFilter("paramid", "=", (Object)paramId);
        DynamicObject olatoreParamNote = QueryServiceHelper.queryOne((String)"ocpos_olatoreparamnote", (String)"id,param", (QFilter[])new QFilter[]{qFilter});
        String guideUrl = DynamicObjectUtils.getString((DynamicObject)olatoreParamNote, (String)"param");
        return OlstoreUtil.transUrltoJSONObject(guideUrl);
    }

    public static JSONObject transUrltoJSONObject(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            JSONObject result = new JSONObject();
            StringTokenizer st = new StringTokenizer(url, "&");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                String[] split = nextToken.split("=");
                if (!StringUtil.isNotNull(split[0]) || !StringUtil.isNotNull(split[1])) continue;
                result.put(split[0], (Object)split[1]);
            }
            return result;
        }
        return null;
    }

    public static void regularMarketClick(String billno, String guideId, String memberid, String storeid, String role, String sourcetype) {
        Calendar instance = Calendar.getInstance();
        Date time = instance.getTime();
        if ("05".equals(sourcetype) || "06".equals(sourcetype) || "07".equals(sourcetype) || "08".equals(sourcetype) || "09".equals(sourcetype) || "100".equals(sourcetype)) {
            OlstoreUtil.generateRecord(billno, guideId, memberid, storeid, role, sourcetype);
        } else if (StringUtils.isNotBlank((CharSequence)billno) && StringUtils.isNotBlank((CharSequence)guideId) && StringUtils.isNotBlank((CharSequence)memberid) && StringUtils.isNotBlank((CharSequence)storeid) && StringUtils.isNotBlank((CharSequence)role) && StringUtils.isNotBlank((CharSequence)sourcetype)) {
            QFilter fBillStatus = new QFilter("billstatus", "=", (Object)"D");
            QFilter fMarketBillno2 = new QFilter("billno", "=", (Object)billno);
            QFilter fStroreId2 = new QFilter("xdd_xdd_entryentity1.xdd_org_billno.id", "=", (Object)storeid);
            QFilter fRole2 = new QFilter("xdd_xdd_entryentity1.xdd_selectlist", "=", (Object)role);
            QFilter fTime = new QFilter("xdd_end_date", ">=", (Object)new Date());
            DynamicObject marketInfo = BusinessDataServiceHelper.loadSingle((String)"xdd_taskconfig", (String)"id,billno,guideid,xdd_start_date,xdd_end_date", (QFilter[])new QFilter[]{fMarketBillno2.and(fStroreId2).and(fRole2).and(fBillStatus).and(fTime)});
            if (Objects.nonNull(marketInfo)) {
                Date dateStart = marketInfo.getDate("xdd_start_date");
                Date dateEnd = marketInfo.getDate("xdd_end_date");
                Date currentDate = new Date();
                if (dateStart.before(currentDate) && dateEnd.after(currentDate)) {
                    OlstoreUtil.generateRecord(billno, guideId, memberid, storeid, role, sourcetype);
                }
            }
        }
    }

    private static void generateRecord(String billno, String guideId, String memberid, String storeid, String role, String sourcetype) {
        block15: {
            try (TXHandle h = TX.required();){
                try {
                    QFilter fMarketBillno = new QFilter("billno", "=", (Object)billno);
                    QFilter fGuideId = new QFilter("guideid", "=", (Object)guideId);
                    QFilter fMemberId = new QFilter("memberid", "=", (Object)memberid);
                    QFilter fStroreId = new QFilter("storeid", "=", (Object)storeid);
                    QFilter fSourceType = new QFilter("sourcetype", "=", (Object)sourcetype);
                    QFilter fRole = new QFilter("role", "=", (Object)role);
                    DynamicObject onlineStore = BusinessDataServiceHelper.loadSingle((String)"ocpos_olstoreshareclick", (String)"id,billno,guideid,memberid,storeid,clicktimes,sourceid,createtime,role,sourcetype", (QFilter[])new QFilter[]{fMarketBillno.and(fGuideId).and(fMemberId).and(fStroreId).and(fRole).and(fSourceType)});
                    if (Objects.nonNull(onlineStore)) {
                        int clicktimes = onlineStore.getInt("clicktimes");
                        onlineStore.set("clicktimes", (Object)(clicktimes + 1));
                        onlineStore.set("id", (Object)onlineStore.getString("id"));
                        onlineStore.set("billno", (Object)onlineStore.getString("billno"));
                        onlineStore.set("memberid", (Object)onlineStore.getString("memberid"));
                        onlineStore.set("sourcetype", (Object)onlineStore.getString("sourcetype"));
                        onlineStore.set("storeid", (Object)onlineStore.getString("storeid"));
                        onlineStore.set("sourceid", (Object)onlineStore.getString("sourceid"));
                        onlineStore.set("role", (Object)onlineStore.getString("role"));
                        onlineStore.set("guideid", (Object)onlineStore.getString("guideId"));
                        onlineStore.set("createtime", (Object)new Date());
                        SaveServiceHelper.saveOperate((String)"ocpos_olstoreshareclick", (DynamicObject[])new DynamicObject[]{onlineStore}, (OperateOption)OperateOption.create());
                        break block15;
                    }
                    onlineStore = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_olstoreshareclick");
                    onlineStore.set("clicktimes", (Object)1);
                    onlineStore.set("createtime", (Object)new Date());
                    onlineStore.set("billno", (Object)billno);
                    onlineStore.set("memberid", (Object)memberid);
                    onlineStore.set("sourcetype", (Object)sourcetype);
                    onlineStore.set("storeid", (Object)storeid);
                    onlineStore.set("role", (Object)role);
                    onlineStore.set("guideid", (Object)guideId);
                    SaveServiceHelper.saveOperate((String)"ocpos_olstoreshareclick", (DynamicObject[])new DynamicObject[]{onlineStore}, (OperateOption)OperateOption.create());
                }
                catch (Throwable ex) {
                    h.markRollback();
                }
            }
        }
    }

    public static void recordTicketNoApi(String ticketno, String billno, String guideId, String storeid, String sourceType, String role) {
        DynamicObject recordClick = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_olstoreshareclick");
        recordClick.set("clicktimes", (Object)1);
        recordClick.set("createtime", (Object)new Date());
        recordClick.set("billno", (Object)billno);
        recordClick.set("memberid", (Object)guideId);
        recordClick.set("guideid", (Object)guideId);
        recordClick.set("storeid", (Object)storeid);
        recordClick.set("role", (Object)role);
        recordClick.set("sourcetype", (Object)sourceType);
        recordClick.set("ticketno", (Object)ticketno);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordClick});
        }
        catch (Throwable e) {
            logger.error("\u7ebf\u4e0a\u95e8\u5e97\u793c\u54c1\u7f16\u7801\u8bb0\u5f55\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public static List<ImgObject> getGoodsImgs(DynamicObjectCollection itemList) {
        ArrayList<ImgObject> goodsImgs = new ArrayList<ImgObject>();
        for (DynamicObject itemInfo : itemList) {
            ImgObject img = new ImgObject();
            img.setSrc(PictureUtil.getFileServerUrl() + itemInfo.getString("goodsid.thumbnail"));
            goodsImgs.add(img);
        }
        return goodsImgs;
    }

    public static long getOperatorSysUserByCustomerId(long orgId, long storeId) {
        long operator = SystemParamUtil.getOnlineStoreDefaultSaler(orgId, storeId);
        if (operator > 0L) {
            QFilter userFilter = new QFilter("id", "=", (Object)operator);
            DynamicObject channelUserInfo = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"sysuser", (QFilter[])new QFilter[]{userFilter});
            long sysUser = DynamicObjectUtil.getLong(channelUserInfo, "sysuser");
            return sysUser;
        }
        return operator;
    }
}

