/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class OwnerUtil {
    public static long getDefaultOwnerId() {
        List<Long> ownerIds = OwnerUtil.getOwnerIds("iscashier");
        if (ownerIds == null || ownerIds.isEmpty()) {
            return 0L;
        }
        return ownerIds.get(0);
    }

    public static long getDefaultOwnerIdToStore() {
        List<Long> isCashierIds = OwnerUtil.getOwnerIds("iscashier");
        List<Long> salerIds = OwnerUtil.getOwnerIds("issaler");
        if (isCashierIds == null || isCashierIds.isEmpty()) {
            if (salerIds == null || salerIds.isEmpty()) {
                return 0L;
            }
            return salerIds.get(0);
        }
        return isCashierIds.get(0);
    }

    public static List<Long> getOwnerIds(String ... args) {
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        for (String arg : args) {
            filter.and(arg, "=", (Object)Boolean.TRUE);
        }
        Map userInfo = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_channeluser", (QFilter[])filter.toArray());
        ArrayList<Long> owners = new ArrayList<Long>(userInfo.size());
        if (userInfo.isEmpty()) {
            return owners;
        }
        long defaultOwnerId = 0L;
        for (DynamicObject userItem : userInfo.values()) {
            DynamicObject owner = userItem.getDynamicObject("owner");
            if (owner == null) continue;
            long ownerId = CommonUtil.formatObejctToLong(owner.getPkValue());
            if (defaultOwnerId == 0L && userItem.getBoolean("isdefault")) {
                defaultOwnerId = ownerId;
            }
            owners.add(ownerId);
        }
        filter = F7Utils.getCommonStatusFilter();
        filter.and("Id", "in", owners);
        filter.and("isstore", "=", (Object)Boolean.TRUE);
        ArrayList<Long> ownerIds = new ArrayList<Long>();
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_channel", (String)"Id", (QFilter[])filter.toArray());
        if (data == null || data.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        for (DynamicObject item : data) {
            long itemId = DynamicObjectUtil.getPkValue(item);
            if (defaultOwnerId == itemId) {
                ownerIds.add(0, itemId);
                continue;
            }
            ownerIds.add(itemId);
        }
        return ownerIds;
    }

    public static List<Long> getBranchId(long userid) {
        List<Long> branchId = new ArrayList<Long>();
        QFilter filter = new QFilter("sysuser", "=", (Object)userid);
        DynamicObject[] channelUser = BusinessDataServiceHelper.load((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filter.toArray());
        if (null != channelUser && channelUser.length > 0) {
            branchId = Arrays.stream(channelUser).map(s -> DynamicObjectUtil.getPkValue(s, "owner")).collect(Collectors.toList());
        }
        return branchId;
    }

    public static List<Long> getChannelType(List<Long> branchid) {
        List<Long> channeltype = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "in", branchid);
        DynamicObject[] channeluser = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"channeltype", (QFilter[])filter.toArray());
        if (null != channeluser && channeluser.length > 0) {
            channeltype = Arrays.stream(channeluser).map(s -> DynamicObjectUtil.getPkValue(s.getDynamicObject("channeltype"))).collect(Collectors.toList());
        }
        return channeltype;
    }

    public static List<Long> getChannelGrade(List<Long> branchid) {
        List<Long> channelGrade = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "in", branchid);
        DynamicObject[] channeluser = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"grade", (QFilter[])filter.toArray());
        if (null != channeluser && channeluser.length > 0) {
            channelGrade = Arrays.stream(channeluser).map(s -> DynamicObjectUtil.getPkValue(s.getDynamicObject("grade"))).collect(Collectors.toList());
        }
        return channelGrade;
    }
}

