/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.saleorder.CommonUtils;

public class PayUtil {
    public static List<DynamicObject> getDisplayPayModeData(long cashierRoleId, String range, String saleOption) {
        DynamicObject cashierRole;
        String payModeSetting;
        List<DynamicObject> payModeLst = CommonUtils.getPaymentModeList(range);
        if (cashierRoleId <= 0L || CollectionUtils.isEmpty(payModeLst)) {
            return payModeLst;
        }
        if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
            List<Long> payOptionNoShowList = Arrays.asList(15L, 34L, 35L, 36L);
            Iterator<DynamicObject> iterator = payModeLst.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = iterator.next();
                long payModeId = DynamicObjectUtils.getPkValue((DynamicObject)row);
                if (!payOptionNoShowList.contains(payModeId)) continue;
                iterator.remove();
            }
        }
        if ("2".equals(payModeSetting = (cashierRole = BusinessDataServiceHelper.loadSingle((Object)cashierRoleId, (String)"ocdbd_cashierrole")).getString("paymodesetting"))) {
            ArrayList<DynamicObject> retainPayModeLst = new ArrayList<DynamicObject>();
            DynamicObjectCollection rolePayModeRange = cashierRole.getDynamicObjectCollection("paymoderange");
            if (!CollectionUtils.isEmpty((Collection)rolePayModeRange)) {
                ArrayList<Long> rolePayModeIds = new ArrayList<Long>();
                for (DynamicObject rolePayMode : rolePayModeRange) {
                    long rolePayModeId = DynamicObjectUtils.getPkValue((DynamicObject)rolePayMode, (String)"paymodeid");
                    rolePayModeIds.add(rolePayModeId);
                }
                for (DynamicObject payMode : payModeLst) {
                    long payModeId = payMode.getLong("id");
                    if (!rolePayModeIds.contains(payModeId)) continue;
                    retainPayModeLst.add(payMode);
                }
            }
            return retainPayModeLst;
        }
        return payModeLst;
    }

    public static List<JSONObject> getDisplayPayModeData(long cashierRoleId, long posId, String range, String saleOption) {
        List<DynamicObject> payModeData = PayUtil.getDisplayPayModeData(cashierRoleId, range, saleOption);
        if (CollectionUtils.isEmpty(payModeData)) {
            return new ArrayList<JSONObject>(0);
        }
        Map<Long, Boolean> posPayModes = PayUtil.getPosPayModes(posId);
        ArrayList<JSONObject> displayPayModeData = new ArrayList<JSONObject>(0);
        JSONObject defaultPayMode = null;
        for (DynamicObject payModeDatum : payModeData) {
            boolean isDefault;
            long payModeId = DynamicObjectUtils.getPkValue((DynamicObject)payModeDatum);
            if (posPayModes.containsKey(payModeId) && (isDefault = posPayModes.get(payModeId).booleanValue())) {
                defaultPayMode = new JSONObject();
                defaultPayMode.put("id", (Object)payModeId);
                defaultPayMode.put("isdefault", (Object)Boolean.TRUE);
                String payModeName = DynamicObjectUtils.getString((DynamicObject)payModeDatum, (String)"name");
                defaultPayMode.put("name", (Object)payModeName);
                boolean isAllowFinalPay = DynamicObjectUtils.getBoolean((DynamicObject)payModeDatum, (String)"isallowfinalpay");
                defaultPayMode.put("isallowfinalpay", (Object)isAllowFinalPay);
                continue;
            }
            JSONObject displayPayMode = new JSONObject();
            displayPayMode.put("id", (Object)payModeId);
            displayPayMode.put("isdefault", (Object)Boolean.FALSE);
            String payModeName = DynamicObjectUtils.getString((DynamicObject)payModeDatum, (String)"name");
            displayPayMode.put("name", (Object)payModeName);
            boolean isAllowFinalPay = DynamicObjectUtils.getBoolean((DynamicObject)payModeDatum, (String)"isallowfinalpay");
            displayPayMode.put("isallowfinalpay", (Object)isAllowFinalPay);
            displayPayModeData.add(displayPayMode);
        }
        if (defaultPayMode != null) {
            displayPayModeData.add(0, defaultPayMode);
        }
        return displayPayModeData;
    }

    public static DynamicObjectCollection getAuthItemData(long cashierRoleId) {
        if (cashierRoleId == 0L) {
            return null;
        }
        DynamicObject cashierRole = BusinessDataServiceHelper.loadSingle((Object)cashierRoleId, (String)"ocdbd_cashierrole");
        return DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)cashierRole, (String)"entryentity");
    }

    public static DynamicObject[] getCashierRoleList(Object[] cashierRoleId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"ocdbd_cashierrole");
        return BusinessDataServiceHelper.load((Object[])cashierRoleId, (DynamicObjectType)dataEntityType);
    }

    public static Map<Long, Boolean> getPosPayModes(long posId) {
        String selectFields = "paymodeentity.paymode.id as paymode, paymodeentity.isdefault as isdefault";
        QFilter filter = new QFilter("id", "=", (Object)posId);
        filter.and("paymodeentity.isenable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_pos", (String)selectFields, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new HashMap<Long, Boolean>(0);
        }
        HashMap<Long, Boolean> posPayModes = new HashMap<Long, Boolean>(data.size());
        for (DynamicObject datum : data) {
            long payModeId = DynamicObjectUtils.getLong((DynamicObject)datum, (String)"paymode");
            if (payModeId <= 0L || posPayModes.containsKey(payModeId)) continue;
            boolean isDefault = DynamicObjectUtils.getBoolean((DynamicObject)datum, (String)"isdefault");
            posPayModes.put(payModeId, isDefault);
        }
        return posPayModes;
    }
}

