/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.occ.ocpos.common.util.StringUtil;

public class QRCodeUtil {
    private static Log logger = LogFactory.getLog(QRCodeUtil.class);
    public static final int QRCODE_COLOR = -16777216;
    public static final int QRCODE_BACKGROUND_COLOR = -1;
    public static final int QRCODE_MARGIN = 0;
    private static FileService fileService = FileServiceFactory.getImageFileService();

    public static String generalQRCode(String url) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        String result = "";
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, 400, 400, hints);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedImage image = QRCodeUtil.toBufferedImage(bitMatrix);
            ImageIO.write((RenderedImage)image, "png", out);
            long timeStamp = TimeServiceHelper.getTimeStamp();
            String fullName = String.format("tmpqrcode_%s%s", timeStamp, ".png");
            String imgUrl = QRCodeUtil.getQrCodeUrl(timeStamp, fullName);
            ByteArrayInputStream swapStream = new ByteArrayInputStream(out.toByteArray());
            FileItem fileItem = new FileItem(fullName, imgUrl, (InputStream)swapStream);
            fileItem.setCreateNewFileWhenExists(true);
            result = fileService.upload(fileItem);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }

    public static String generalMiniProgramQRCode(byte[] imgByte) {
        String result = "";
        try {
            long timeStamp = TimeServiceHelper.getTimeStamp();
            String fullName = String.format("miniprogramqrcode_%s%s", timeStamp, ".png");
            String imgUrl = QRCodeUtil.getQrCodeUrl(timeStamp, fullName);
            ByteArrayInputStream swapStream = new ByteArrayInputStream(imgByte);
            FileItem fileItem = new FileItem(fullName, imgUrl, (InputStream)swapStream);
            fileItem.setCreateNewFileWhenExists(true);
            result = fileService.upload(fileItem);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }

    private static String getQrCodeUrl(long timeStamp, String fullName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String pkId = String.valueOf(timeStamp);
        return FileNameUtils.getImageFileName((String)tenantId, (String)accountId, (String)"ocepfp", (String)"MiniProgramVersionPlugin", (Object)pkId, (String)fullName);
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static BufferedImage writeLogoToQrcode(BitMatrix matrix, String logoUrl) throws IOException {
        BufferedImage image = QRCodeUtil.toBufferedImage(matrix);
        if (StringUtil.isNotNull(logoUrl)) {
            URL url = new URL(logoUrl);
            Graphics2D gs = image.createGraphics();
            int ratioWidth = image.getWidth() * 2 / 10;
            int ratioHeight = image.getHeight() * 2 / 10;
            BufferedImage img = ImageIO.read(url);
            int logoWidth = ((Image)img).getWidth(null) > ratioWidth ? ratioWidth : ((Image)img).getWidth(null);
            int logoHeight = ((Image)img).getHeight(null) > ratioHeight ? ratioHeight : ((Image)img).getHeight(null);
            int x = (image.getWidth() - logoWidth) / 2;
            int y = (image.getHeight() - logoHeight) / 2;
            gs.drawImage(img, x, y, logoWidth, logoHeight, null);
            gs.dispose();
            img.flush();
        }
        return image;
    }
}

