/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SystemParamUtil {
    private static final Log LOG = LogFactory.getLog(SystemParamUtil.class);

    public static boolean getIsCustomerMustInput(long orgId, long branchId) {
        boolean isMustInput;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "salecustinput");
            isMustInput = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isMustInput = false;
        }
        return isMustInput;
    }

    public static boolean getIsAllowZeroSaleNotGift(long orgId, long branchId) {
        boolean isAllow;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isallowzerosalenogift");
            isAllow = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
        return isAllow;
    }

    public static boolean getIsAllowZeroSettleOrder(long orgId, long branchId) {
        boolean isAllow;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isallowzerosettleorder");
            isAllow = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception e) {
            isAllow = false;
        }
        return isAllow;
    }

    public static boolean getIsCtrlWithReturnRule(long orgId, long branchId) {
        boolean isCtrlWithReturnRule;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isctrlwithreturnrule");
            isCtrlWithReturnRule = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isCtrlWithReturnRule = false;
        }
        return isCtrlWithReturnRule;
    }

    public static boolean getIsReturnReasonMustInput(long orgId, long branchId) {
        boolean isMustInput;
        try {
            Object objValue = SystemParamUtil.getSystemParamValue(orgId, branchId, "returnreasonmustinput");
            isMustInput = CommonUtil.formatObjectToBoolean(objValue);
        }
        catch (Exception ex) {
            isMustInput = false;
        }
        return isMustInput;
    }

    public static boolean getIsEnableUserScopes(long orgId, long branchId) {
        boolean isEnableUserScopes;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isenableuserscopes");
            isEnableUserScopes = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isEnableUserScopes = false;
        }
        return isEnableUserScopes;
    }

    public static boolean isControlCashReturn(long orgId, long branchId) {
        boolean isControlCashReturn;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "iscontrolreturnamount");
            isControlCashReturn = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isControlCashReturn = false;
        }
        return isControlCashReturn;
    }

    public static boolean isAllowGiftExcess(long orgId, long branchId) {
        boolean result;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isallowgiftexcess");
            result = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static boolean getisEnablePricePolicy(long orgId, long branchId) {
        boolean isEnablePricePolicy;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isenblepricepolicy");
            isEnablePricePolicy = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isEnablePricePolicy = false;
        }
        return isEnablePricePolicy;
    }

    public static boolean getEnableCounselor(long orgId, long branchId) {
        boolean enableCounselor;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "enablecounselor");
            enableCounselor = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            enableCounselor = false;
        }
        return enableCounselor;
    }

    public static boolean getIsMustInputMember(long orgId, long branchId) {
        boolean isMustInput;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "ismustinputmember");
            isMustInput = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isMustInput = false;
        }
        return isMustInput;
    }

    public static boolean getIsSaleMustInput(long orgId, long branchId) {
        boolean isSaleMustInput;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "issalermustinput");
            isSaleMustInput = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isSaleMustInput = false;
        }
        return isSaleMustInput;
    }

    public static boolean getIsReserved(long orgId, long branchId) {
        boolean isReserved;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isreserved");
            isReserved = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isReserved = false;
        }
        return isReserved;
    }

    public static boolean getIsAutoPrint(long orgId, long branchId) {
        boolean isAutoPrint;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "isautoprint");
            isAutoPrint = CommonUtil.formatObjectToBoolean(value);
        }
        catch (Exception ex) {
            isAutoPrint = false;
        }
        return isAutoPrint;
    }

    public static int getOpenQueryInputNumDigit(long orgId, long branchId) {
        int openQueryInputNumDigit;
        try {
            Object value = SystemParamUtil.getSystemParamValue(orgId, branchId, "openqueryinputnumdigit");
            openQueryInputNumDigit = CommonUtil.formatObjectToInt(value);
        }
        catch (Exception ex) {
            openQueryInputNumDigit = 0;
        }
        return openQueryInputNumDigit;
    }

    public static long getOnlineStoreDefaultSaler(long orgId, long branchId) {
        try {
            Object defSaler = SystemParamUtil.getSystemParamValue(orgId, branchId, "olstoredefaultsaler");
            return DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)defSaler));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getInvStatus(long orgId, long branchId) {
        try {
            Object invStatus = SystemParamUtil.getSystemParamValue(orgId, branchId, "invstatus");
            long invStatusId = 691930349319792640L;
            if (invStatus != null) {
                invStatusId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)invStatus));
            }
            return invStatusId;
        }
        catch (Exception e) {
            return 691930349319792640L;
        }
    }

    public static long getItemCurrency(long orgId, long branchId) {
        long currencyId = 1L;
        try {
            Object currency = SystemParamUtil.getSystemParamValue(orgId, branchId, "defcurrency");
            if (currency != null) {
                currencyId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)currency));
            }
            return currencyId;
        }
        catch (Exception e) {
            return 1L;
        }
    }

    public static long getLocCodeRuleId(long orgId, long branchId) {
        try {
            Object defaultCustomer = SystemParamUtil.getSystemParamValue(orgId, branchId, "lotcoderule");
            return DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)defaultCustomer));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getSaleOrderDefInvTypeId(long orgId, long branchId) {
        long saleOrderDefInvTypeId = 688884005529250816L;
        try {
            Object saleOrderDefInvType = SystemParamUtil.getSystemParamValue(orgId, branchId, "saleorderdefinvtype");
            if (saleOrderDefInvType != null) {
                saleOrderDefInvTypeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)saleOrderDefInvType));
            }
            return saleOrderDefInvTypeId;
        }
        catch (Exception e) {
            return 688884005529250816L;
        }
    }

    public static String getWipeZeroMode(long orgId, long branchId) {
        Object mode = SystemParamUtil.getSystemParamValue(orgId, branchId, "wipezeromode");
        if (!ObjectUtils.isEmpty((Object)mode) && mode instanceof String) {
            return String.valueOf(mode);
        }
        return "A";
    }

    public static String getSaleOrderPrintConfig(long orgId, long branchId) {
        Object config = SystemParamUtil.getSystemParamValue(orgId, branchId, "footer");
        if (!ObjectUtils.isEmpty((Object)config) && config instanceof String) {
            return String.valueOf(config);
        }
        return "";
    }

    public static String getReturnMode(long orgId, long branchId, String key) {
        Object returnMode = SystemParamUtil.getSystemParamValue(orgId, branchId, key);
        if (!ObjectUtils.isEmpty((Object)returnMode) && returnMode instanceof String) {
            return String.valueOf(returnMode);
        }
        return "4";
    }

    public static String getRetFinalAmtHandleMode(long orgId, long branchId) {
        Object handleMode = SystemParamUtil.getSystemParamValue(orgId, branchId, "retfinalamthandlemode");
        if (!ObjectUtils.isEmpty((Object)handleMode) && handleMode instanceof String) {
            return String.valueOf(handleMode);
        }
        return "1";
    }

    public static String getBookExeDiscTiming(long orgId, long branchId) {
        Object bookExeDiscTiming = SystemParamUtil.getSystemParamValue(orgId, branchId, "bookexedisctiming");
        if (!ObjectUtils.isEmpty((Object)bookExeDiscTiming) && bookExeDiscTiming instanceof String) {
            return String.valueOf(bookExeDiscTiming);
        }
        return "1";
    }

    public static String getInvQueryRange(long orgId, long branchId) {
        Object returnMode = SystemParamUtil.getSystemParamValue(orgId, branchId, "invqueryrange");
        if (!ObjectUtils.isEmpty((Object)returnMode) && returnMode instanceof String) {
            return String.valueOf(returnMode);
        }
        return "0";
    }

    public static String getOnlineTakePriceWay(long orgId, long branchId) {
        Object takePriceWay = SystemParamUtil.getSystemParamValue(orgId, branchId, "onlinetakepriceway");
        if (!ObjectUtils.isEmpty((Object)takePriceWay) && takePriceWay instanceof String) {
            return String.valueOf(takePriceWay);
        }
        return "1";
    }

    public static String getGiftPriceSourceMode(long orgId, long branchId) {
        Object returnMode = SystemParamUtil.getSystemParamValue(orgId, branchId, "giftpricesourcemode");
        if (!ObjectUtils.isEmpty((Object)returnMode) && returnMode instanceof String) {
            return String.valueOf(returnMode);
        }
        return "0";
    }

    public static String getNoGiftValueControl(long orgId, long branchId) {
        Object noGiftValueControl = SystemParamUtil.getSystemParamValue(orgId, branchId, "nogiftvaluecontrol");
        if (!ObjectUtils.isEmpty((Object)noGiftValueControl) && noGiftValueControl instanceof String) {
            return String.valueOf(noGiftValueControl);
        }
        return "1";
    }

    public static Object getChangeDefectDefInvType(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "changedefectdefinvtype");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getSaleOrderDefInvType(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "saleorderdefinvtype");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getMaxCashReturn(long orgId, long branchId) {
        BigDecimal bValue;
        try {
            Object objValue = SystemParamUtil.getSystemParamValue(orgId, branchId, "maxruturnamount");
            bValue = CommonUtil.formatObjectToDecimal(objValue);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
        return bValue;
    }

    public static Object getDefaultCustomer(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "saleorderdefcustomer");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getRetDiscountHandleWay(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "retdiscounthandleway");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getNoSrcReturnCheckLot(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "nosrcreturnchecklot");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getNoSrcReturnCheckSerial(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "nosrcreturncheckserial");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getQueryVipConsumeScope(long orgId, long branchId) {
        try {
            return SystemParamUtil.getSystemParamValue(orgId, branchId, "queryvipconsumescope");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPromDiscMLWay(long orgId, long branchId) {
        try {
            Object promDiscMLWay = SystemParamUtil.getSystemParamValue(orgId, branchId, "promdiscmlway");
            if (!ObjectUtils.isEmpty((Object)promDiscMLWay) && promDiscMLWay instanceof String) {
                return String.valueOf(promDiscMLWay);
            }
            return "0";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getSystemParamValue(long orgId, long branchId, String key) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("branch", "in", (Object)new Long[]{0L, branchId});
        String selectFields = StringUtils.join((CharSequence)",", (Object[])new Object[]{"branch", key});
        DynamicObject[] sysParams = BusinessDataServiceHelper.load((String)"ocpos_store_sysparam", (String)selectFields, (QFilter[])filter.toArray(), (String)"branch", (int)2);
        if (sysParams != null && sysParams.length > 0) {
            int len = sysParams.length;
            if (len == 1) {
                return DynamicObjectUtils.get((DynamicObject)sysParams[0], (String)key);
            }
            return DynamicObjectUtils.get((DynamicObject)sysParams[1], (String)key);
        }
        return null;
    }

    public static DynamicObject createDefSysParam(long orgId, long branchId) {
        DynamicObject sysParam = SystemParamUtil.buildDefSysParam(orgId, branchId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sysParam});
        return sysParam;
    }

    public static DynamicObject buildDefSysParam(Object orgId, Object branchId) {
        DynamicObject sysParam = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_store_sysparam");
        sysParam.set("id", (Object)DB.genLongId((String)"t_ocpos_sysparam"));
        sysParam.set("defcurrency", (Object)1L);
        sysParam.set("wipezeromode", (Object)"A");
        sysParam.set("ismustinputmember", (Object)Boolean.TRUE);
        sysParam.set("isenblepricepolicy", (Object)Boolean.TRUE);
        sysParam.set("cashcouponreturnmode", (Object)"4");
        sysParam.set("pointreturnmode", (Object)"4");
        sysParam.set("isctrlwithreturnrule", (Object)Boolean.TRUE);
        sysParam.set("bookexedisctiming", (Object)"1");
        sysParam.set("iscontrolreturnamount", (Object)Boolean.TRUE);
        sysParam.set("retfinalamthandlemode", (Object)"1");
        sysParam.set("isautopublish", (Object)Boolean.TRUE);
        sysParam.set("giftpricesourcemode", (Object)"0");
        sysParam.set("onlinetakepriceway", (Object)"1");
        sysParam.set("vipdiscountway", (Object)"1");
        sysParam.set("invqueryrange", (Object)"0");
        sysParam.set("org", orgId);
        if (CommonUtil.formatObejctToLong(branchId) > 0L) {
            sysParam.set("branch", branchId);
        }
        return sysParam;
    }
}

