/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util.promotion;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import kd.occ.ocpos.common.entity.MaterialInfoEntity;
import kd.occ.ocpos.common.entity.SchemeEntity;
import kd.occ.ocpos.common.entity.SchemeMaterialEntity;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.promotion.JoinTypeEnum;
import kd.occ.ocpos.common.enums.promotion.MaterialTypeEnum;
import kd.occ.ocpos.common.enums.promotion.SchemeTypeEnum;
import kd.occ.ocpos.common.util.promotion.StringJoin;

public class CommonUtils {
    public static boolean isContain(List<String> keyList, String key) {
        if (keyList == null || keyList.size() == 0 || key == null) {
            return false;
        }
        for (String addKey : keyList) {
            if (!addKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        if (delimiter != null && elements != null) {
            StringJoin joiner = new StringJoin(delimiter);
            for (CharSequence charSequence : elements) {
                joiner.add(charSequence);
            }
            return joiner.toString();
        }
        return "";
    }

    public static boolean isContainArray(List<String> parentList, List<String> childList) {
        if (parentList == null || childList == null) {
            return false;
        }
        if (parentList.size() < childList.size()) {
            return false;
        }
        for (String child : childList) {
            boolean isExit = false;
            for (String parent : parentList) {
                if (!child.equals(parent)) continue;
                isExit = true;
                break;
            }
            if (isExit) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainKey(List<Integer> data, int key) {
        if (data == null) {
            return false;
        }
        for (Integer v : data) {
            if (key != v) continue;
            return true;
        }
        return false;
    }

    public static <T> void sortList(Comparator<T> c, List<T> list) {
        Object[] a = list.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = list.listIterator();
        for (Object e : a) {
            i.next();
            i.set(e);
        }
    }

    public static MaterialInfoEntity getMaterialInfo(CxRequestEntity req, SchemeMaterialEntity material, SchemeEntity scheme) {
        List<MaterialEntryEntity> materialEntryEntities = req.getMaterialEntries();
        for (MaterialEntryEntity materialEntry : materialEntryEntities) {
            switch (material.getType()) {
                case Material: {
                    if (!CommonUtils.materialEqual(materialEntry, material, true)) break;
                    return new MaterialInfoEntity(materialEntry, materialEntry.getQty(), CommonUtils.getAmount(materialEntry, scheme, req.getAmtPrecision(), req.getMemberId()));
                }
                case MaterialBrand: {
                    if (!materialEntry.getBrandId().equals(material.getObjectId())) break;
                    return new MaterialInfoEntity(materialEntry, materialEntry.getQty(), CommonUtils.getAmount(materialEntry, scheme, req.getAmtPrecision(), req.getMemberId()));
                }
                case MaterialCategory: {
                    if (!CommonUtils.isContain(materialEntry.getCategories(), material.getObjectId())) break;
                    return new MaterialInfoEntity(materialEntry, materialEntry.getQty(), CommonUtils.getAmount(materialEntry, scheme, req.getAmtPrecision(), req.getMemberId()));
                }
                case MaterialLabel: {
                    if (!CommonUtils.isContain(materialEntry.getLabelId(), material.getObjectId())) break;
                    return new MaterialInfoEntity(materialEntry, materialEntry.getQty(), CommonUtils.getAmount(materialEntry, scheme, req.getAmtPrecision(), req.getMemberId()));
                }
            }
        }
        return new MaterialInfoEntity(null, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public static BigDecimal getAmount(MaterialEntryEntity material, SchemeEntity scheme, int amtPrecision, String memberId) {
        BigDecimal retailPrice = material.getAfterDisPrice();
        if (scheme.getType() != SchemeTypeEnum.SchemeWhole) {
            if (scheme.getMemberDoubleDiscount() == JoinTypeEnum.Join && material.isMemberPrice() && material.getMemberPrice().compareTo(BigDecimal.ZERO) > 0) {
                retailPrice = material.getMemberPrice();
            }
        } else {
            retailPrice = scheme.getMemberDoubleDiscount() == JoinTypeEnum.NonJoin ? (scheme.getMemberDoubleDiscount() == JoinTypeEnum.NonJoin ? material.getRetailPrice() : (material.isChangePrice() ? material.getManualPrice() : material.getRetailPrice())) : (scheme.getManualDoubleDiscount() == JoinTypeEnum.NonJoin ? (CommonUtils.isMember(memberId) ? material.getMemberPrice() : material.getRetailPrice()) : (material.isChangePrice() ? material.getManualPrice() : (CommonUtils.isMember(memberId) ? material.getMemberPrice() : material.getRetailPrice())));
        }
        return material.getQty().multiply(retailPrice).setScale(2, 4);
    }

    public static boolean materialEqual(MaterialEntryEntity reqMaterial, SchemeMaterialEntity schemeMaterial, boolean isMatchUnit) {
        if (schemeMaterial.getType() != MaterialTypeEnum.Material) {
            return false;
        }
        if (!schemeMaterial.getObjectId().equals(reqMaterial.getMaterialId())) {
            return false;
        }
        boolean isUnitId = CommonUtils.isEqualObjId(reqMaterial.getUnitId(), schemeMaterial.getUnitId());
        if (!isMatchUnit && (CommonUtils.isEmpty(reqMaterial.getUnitId()) || "0".equals(reqMaterial.getUnitId()))) {
            isUnitId = true;
        }
        boolean isAuxId = CommonUtils.isEqualObjId(reqMaterial.getAuxId(), schemeMaterial.getAuxId());
        return isUnitId && isAuxId;
    }

    public static boolean isEqualObjId(String reqObjId, String schemeObjId) {
        if ("0".equals(reqObjId)) {
            reqObjId = "";
        }
        if ("0".equals(schemeObjId)) {
            schemeObjId = "";
        }
        return reqObjId.equals(schemeObjId);
    }

    public static boolean isMember(String memberId) {
        return !CommonUtils.isEmpty(memberId) && !"0".equals(memberId);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static void addNoHitLog(String name, String planNo, String info) {
        System.out.println(String.format("%s:%s\u4fc3\u9500\u672a\u547d\u4e2d, %s\u4e0d\u6ee1\u8db3", name, planNo, info));
    }
}

