/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.common.util.promotion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateFormatUtils {
    private static Log log = LogFactory.getLog(DateFormatUtils.class);
    protected static final String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String MM_DD = "MM-dd";
    public static final String DD = "dd";
    public static final String HH_MM_12 = "KK:mm";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String HH_MM_24 = "HH:mm";
    public static final String MM_SS = "mm:ss";

    private DateFormatUtils() {
    }

    public static String formatDate(long milliseconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(milliseconds));
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static long getCurrentTimeInMillis(long timeInMillis) {
        return DateFormatUtils.getCurrentTimeInMillis(timeInMillis, TimeZone.getTimeZone("GMT+8"));
    }

    public static long getCurrentTimeInMillis(long timeInMillis, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTimeInMillis(timeInMillis);
        return c.getTimeInMillis();
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date formatStringToDate(String format, String date) {
        Date tempDate = null;
        try {
            SimpleDateFormat asf = new SimpleDateFormat(format);
            tempDate = asf.parse(date);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        return tempDate;
    }

    public static long formatDateToLong(String patten, String dateStr) {
        try {
            Date date = new SimpleDateFormat(patten).parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            return 0L;
        }
    }

    public static boolean isSameDay(long time1, long time2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(time1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(time2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static long StringDateToLong(String dateStr) {
        try {
            Date date = new SimpleDateFormat(YYYY_MM_DD).parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            return 0L;
        }
    }

    public static String getGapTime(long time) {
        long hours = time / 3600L;
        long minutes = (time - hours * 3600L) / 60L;
        long second = time - hours * 3600L - minutes * 60L;
        String diffTime = "";
        diffTime = minutes < 10L ? hours + ":0" + minutes : hours + ":" + minutes;
        diffTime = second < 10L ? diffTime + ":0" + second : diffTime + ":" + second;
        return diffTime;
    }

    public static int weekByDate(long currentTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTimeInMillis(currentTime);
        return calendar.get(3);
    }

    public static Date getFirstDateOfWeek() {
        Calendar monday = Calendar.getInstance();
        monday.setFirstDayOfWeek(2);
        monday.set(7, 2);
        return monday.getTime();
    }

    public static Date getFirstDateOfMonth() {
        Calendar monthFirstDay = Calendar.getInstance();
        monthFirstDay.add(2, 0);
        monthFirstDay.set(5, 1);
        return monthFirstDay.getTime();
    }

    public static Date getLastDateOfMonth() {
        Calendar monthLastDay = Calendar.getInstance();
        monthLastDay.set(5, monthLastDay.getActualMaximum(5));
        return monthLastDay.getTime();
    }

    public static String getWeekOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }
}

