/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class InitImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billData, ImportLogger logger) {
        super.beforeSave(billData, logger);
        for (ImportBillData billDatum : billData) {
            JSONObject data = billDatum.getData();
            int index = billDatum.getDataIndex();
            Map branch = (Map)data.get((Object)"salebranchid");
            if (CollectionUtils.isEmpty((Map)branch)) {
                return;
            }
            this.initHeadData(data, index, branch, logger);
            this.initEntryData(data, index, branch, logger);
        }
    }

    protected ApiResult save(List<ImportBillData> billData, ImportLogger logger) {
        ApiResult result = super.save(billData, logger);
        if (result != null && result.getSuccess()) {
            IAppCache cache = AppCache.get((String)"ocpos");
            cache.remove("type");
            cache.remove("billtype");
            cache.remove("saler");
        }
        return result;
    }

    private void initHeadData(JSONObject data, int index, Map<String, Object> branch, ImportLogger logger) {
        try {
            String entityId;
            this.initCommonData(data, branch);
            IAppCache cache = AppCache.get((String)"ocpos");
            switch (entityId = (String)cache.get("type", String.class)) {
                case "ocpos_saleorder_init": {
                    long billTypeId = CommonUtil.formatObejctToLong((Object)cache.get("billtype", Object.class));
                    if (billTypeId == 0L) break;
                    this.initSaleData(data, billTypeId);
                    break;
                }
                case "ocpos_saleorder_re_init": {
                    this.initReturnData(data);
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Integer.valueOf(index), ex.getMessage());
        }
    }

    private void initEntryData(JSONObject data, int index, Map<String, Object> branch, ImportLogger logger) {
        try {
            List listData = (List)data.get((Object)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)listData)) {
                return;
            }
            IAppCache cache = AppCache.get((String)"ocpos");
            long billTypeId = CommonUtil.formatObejctToLong((Object)cache.get("billtype", Object.class));
            for (Map listDatum : listData) {
                if (billTypeId == BillTypeEnum.RESERVE.getId()) {
                    listDatum.put("isbook", Boolean.TRUE);
                }
                Map<String, Object> saler = this.getSaler(data, "goodssaler", branch);
                listDatum.put("goodssaler", saler);
            }
        }
        catch (Exception ex) {
            logger.log(Integer.valueOf(index), ex.getMessage());
        }
    }

    private void initCommonData(JSONObject data, Map<String, Object> branch) {
        data.put("isinitbill", (Object)Boolean.TRUE);
        data.put("financeexchangerate", (Object)1);
        Map<String, Object> currency = this.getCurrency();
        data.put("locurrencyid", currency);
        data.put("currencyid", currency);
        data.put("saler", this.getSaler(data, "saler", branch));
        data.put("salestatus", (Object)SaleStatusEnum.STATUS_S.getValue());
        data.put("cashier", this.getCashier(data, branch));
    }

    private void initSaleData(JSONObject data, long billTypeId) {
        data.put("basebilltype", this.getBillType(billTypeId));
        data.put("biztype", (Object)BizTypeEnum.SALEORDER.getValue());
        data.put("receivingtype", this.getReceivingType(ReceiveTypeEnum.GENERALCOLLECTION.getValue()));
    }

    private void initReturnData(JSONObject data) {
        data.put("basebilltype", this.getBillType(BillTypeEnum.RETURN.getId()));
        data.put("biztype", (Object)BizTypeEnum.SALERETURN.getValue());
        data.put("receivingtype", this.getReceivingType(ReceiveTypeEnum.SALECOLLECTION.getValue()));
    }

    private Map<String, Object> getSaler(JSONObject data, String key, Map<String, Object> branch) {
        HashMap<String, Object> saler = (HashMap<String, Object>)data.get((Object)key);
        if (CollectionUtils.isEmpty((Map)saler)) {
            saler = new HashMap<String, Object>(1);
            saler.put("id", this.getSalerId(branch));
        } else {
            saler = new HashMap(1);
            saler.put("id", this.getSalerId(branch, saler));
        }
        return saler;
    }

    private Map<String, Object> getCashier(JSONObject data, Map<String, Object> branch) {
        HashMap<String, Object> cashier = (HashMap<String, Object>)data.get((Object)"cashier");
        if (CollectionUtils.isEmpty((Map)cashier)) {
            cashier = new HashMap<String, Object>(1);
            cashier.put("id", this.getCashierId(branch));
        } else {
            cashier = new HashMap(1);
            cashier.put("id", this.getCashierId(branch, cashier));
        }
        return cashier;
    }

    private Map<String, Object> getBillType(long billTypeId) {
        HashMap<String, Object> billType = new HashMap<String, Object>(1);
        billType.put("id", billTypeId);
        return billType;
    }

    private Map<String, Object> getReceivingType(long receivingTypeId) {
        HashMap<String, Object> receivingType = new HashMap<String, Object>(1);
        receivingType.put("id", receivingTypeId);
        return receivingType;
    }

    private Map<String, Object> getCurrency() {
        HashMap<String, Object> currency = new HashMap<String, Object>(1);
        currency.put("id", 1L);
        return currency;
    }

    private long getCashierId(Map<String, Object> branch) {
        IAppCache cache = AppCache.get((String)"ocpos");
        long cashierId = CommonUtil.formatObejctToLong((Object)cache.get("cashier", Object.class));
        if (cashierId == 0L) {
            QFilter filter = this.getCashierFilter(branch);
            DynamicObject cashier = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])filter.toArray());
            cashierId = DynamicObjectUtils.getPkValue((DynamicObject)cashier);
        }
        return cashierId;
    }

    private long getCashierId(Map<String, Object> branch, Map<String, Object> cashier) {
        QFilter filter = this.getCashierFilter(branch);
        filter.and("usernumber", "=", cashier.get("number"));
        DynamicObject data = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])filter.toArray());
        long cashierId = data != null ? DynamicObjectUtils.getPkValue((DynamicObject)data) : this.getCashierId(branch);
        return cashierId;
    }

    private long getSalerId(Map<String, Object> branch) {
        IAppCache cache = AppCache.get((String)"ocpos");
        long salerId = CommonUtil.formatObejctToLong((Object)cache.get("saler", Object.class));
        if (salerId == 0L) {
            QFilter filter = this.getSalerFilter(branch);
            DynamicObject saler = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])filter.toArray());
            salerId = DynamicObjectUtils.getPkValue((DynamicObject)saler);
        }
        return salerId;
    }

    private long getSalerId(Map<String, Object> branch, Map<String, Object> saler) {
        QFilter filter = this.getSalerFilter(branch);
        filter.and("usernumber", "=", saler.get("number"));
        DynamicObject data = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])filter.toArray());
        long salerId = data != null ? DynamicObjectUtils.getPkValue((DynamicObject)data) : this.getSalerId(branch);
        return salerId;
    }

    private QFilter getChannelUserFilter(Map<String, Object> branch) {
        QFilter filter = F7Utils.getEnableFilter();
        filter.and("owner.number", "=", branch.get("number"));
        filter.and("owner.enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("owner.status", "=", (Object)StatusEnum.AUDIT.getValue());
        return filter;
    }

    private QFilter getSalerFilter(Map<String, Object> branch) {
        QFilter filter = this.getChannelUserFilter(branch);
        filter.and("issaler", "=", (Object)Boolean.TRUE);
        return filter;
    }

    private QFilter getCashierFilter(Map<String, Object> branch) {
        QFilter filter = this.getChannelUserFilter(branch);
        filter.and("iscashier", "=", (Object)Boolean.TRUE);
        return filter;
    }
}

