/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.ElectWarrantyHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.CloseStatusEnum;

public class SaleAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("basebilltype");
        e.getFieldKeys().add("srcbiztype");
        e.getFieldKeys().add("srcbillbiztype");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("ordersource");
        e.getFieldKeys().add("orderstatus");
        e.getFieldKeys().add("ismergebill");
        e.getFieldKeys().add("notconfirm");
        e.getFieldKeys().add("bizorgid");
        e.getFieldKeys().add("salebranchid");
        e.getFieldKeys().add("goodsentryentity.goodsid");
        e.getFieldKeys().add("goodsentryentity.brand");
        e.getFieldKeys().add("goodsentryentity.goodsclass");
        e.getFieldKeys().add("goodsentryentity.isbook");
        e.getFieldKeys().add("goodsentryentity.lastbillid");
        e.getFieldKeys().add("goodsentryentity.norecefinalamount");
        e.getFieldKeys().add("goodsentryentity.noreceexpectfinalamount");
        e.getFieldKeys().add("goodsentryentity.linereceivableamount");
        e.getFieldKeys().add("goodsentryentity.supplier");
        e.getFieldKeys().add("goodsentryentity.finalpayment");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("goodsentryentity.salesorderdelivery");
        e.getFieldKeys().add("salesorderdelivery.signstatus");
        e.getFieldKeys().add("salesorderdelivery.receivedate");
        e.getFieldKeys().add("salesorderdelivery.snmainfile");
        e.getFieldKeys().add("salesorderdelivery.isselfpickup");
        e.getFieldKeys().add("salesorderdelivery.deliverymode");
        e.getFieldKeys().add("salesorderdelivery.deliverystatus");
        e.getFieldKeys().add("salesorderdelivery.deliversaleqty");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus((DynamicObject)dataEntity);
            long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            if (baseBillTypeId != BillTypeEnum.CVTSALE.getId()) continue;
            long sourceBillId = dataEntity.getLong("sourcebillid");
            boolean bNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
            if (!bNotConfirm || sourceBillId <= 0L) continue;
            this.updateSourceBillCloseStatus(dataEntity, sourceBillId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            boolean isBookAndNotConfirm;
            SaleOrderWriteBackHelper.updateSnMainFile((DynamicObject)dataEntity, (String)"C");
            DynamicObject billType = dataEntity.getDynamicObject("basebilltype");
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
            boolean notConfirm = dataEntity.getBoolean("notconfirm");
            boolean bl = isBookAndNotConfirm = !notConfirm && billTypeId == BillTypeEnum.RESERVE.getId();
            if (isBookAndNotConfirm || BillTypeEnum.STORE.getId() == billTypeId) {
                return;
            }
            ElectWarrantyHelper.addNewElectWarranty((DynamicObject)dataEntity);
        }
    }

    private void updateSourceBillCloseStatus(DynamicObject dataEntity, long sourceBillId) {
        BigDecimal payamount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"depositpayamount");
        String selectFields = "depositpayamount,saleamount,depositamount,closestatus";
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder", (String)selectFields);
        BigDecimal depositpayamount = DynamicObjectUtils.getBigDecimal((DynamicObject)sourceBill, (String)"depositpayamount");
        BigDecimal saleamount = DynamicObjectUtils.getBigDecimal((DynamicObject)sourceBill, (String)"saleamount");
        BigDecimal depositamount = DynamicObjectUtils.getBigDecimal((DynamicObject)sourceBill, (String)"depositamount");
        BigDecimal sumpayamount = payamount.add(depositpayamount);
        if (sumpayamount.add(saleamount.abs()).compareTo(depositamount) >= 0) {
            sourceBill.set("closestatus", (Object)CloseStatusEnum.CLOSE.getValue());
        }
        sourceBill.set("depositpayamount", (Object)sumpayamount);
        SaveServiceHelper.update((DynamicObject)sourceBill);
    }
}

