/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.ElectWarrantyHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;

public class SaleChangeAudit
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog((String)"ocpos");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("srcbiztype");
        e.getFieldKeys().add("srcbillbiztype");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("ordersource");
        e.getFieldKeys().add("orderstatus");
        e.getFieldKeys().add("ismergebill");
        e.getFieldKeys().add("notconfirm");
        e.getFieldKeys().add("bizorgid");
        e.getFieldKeys().add("salebranchid");
        e.getFieldKeys().add("exchangepayamount");
        e.getFieldKeys().add("initialbillid");
        e.getFieldKeys().add("changeitemtype");
        e.getFieldKeys().add("goodsentryentity.goodsid");
        e.getFieldKeys().add("goodsentryentity.brand");
        e.getFieldKeys().add("goodsentryentity.goodsclass");
        e.getFieldKeys().add("goodsentryentity.isbook");
        e.getFieldKeys().add("goodsentryentity.lastbillid");
        e.getFieldKeys().add("goodsentryentity.norecefinalamount");
        e.getFieldKeys().add("goodsentryentity.noreceexpectfinalamount");
        e.getFieldKeys().add("goodsentryentity.linereceivableamount");
        e.getFieldKeys().add("goodsentryentity.supplier");
        e.getFieldKeys().add("goodsentryentity.finalpayment");
        e.getFieldKeys().add("goodsentryentity.salesorderdelivery");
        e.getFieldKeys().add("goodsentryentity.saleoption");
        e.getFieldKeys().add("goodsentryentity.inisrcseq");
        e.getFieldKeys().add("goodsentryentity.srcseq");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("salesorderdelivery.signstatus");
        e.getFieldKeys().add("salesorderdelivery.snmainfile");
        e.getFieldKeys().add("salesorderdelivery.isselfpickup");
        e.getFieldKeys().add("salesorderdelivery.deliverymode");
        e.getFieldKeys().add("salesorderdelivery.deliverystatus");
        e.getFieldKeys().add("salesorderdelivery.deliversaleqty");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
        e.getFieldKeys().add("salesorderdelivery.srcdeliverystatus");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus((DynamicObject)dataEntity);
            long sourceBillId = dataEntity.getLong("sourcebillid");
            if (sourceBillId == 0L) {
                return;
            }
            DynamicObject initSaleOrder = null;
            long initialBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"initialbillid");
            if (initialBillId > 0L) {
                initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
            }
            String changeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            boolean isExistNoPresent = false;
            boolean isExistPresent = false;
            HashMap<Integer, DynamicObject> iniSrcSeqRetGoodsEntity = new HashMap<Integer, DynamicObject>(0);
            HashMap sourceBillIdDeliveryIdWbStatusMap = new HashMap(0);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliverySubEntity;
                String saleOption = entryEntity.getString("saleoption");
                if (StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"1")) continue;
                int inisrcseq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"inisrcseq");
                if (inisrcseq == 0) {
                    inisrcseq = entryEntity.getInt("srcseq");
                }
                iniSrcSeqRetGoodsEntity.put(inisrcseq, entryEntity);
                boolean ispresent = entryEntity.getBoolean("ispresent");
                if (!ispresent) {
                    isExistNoPresent = true;
                } else {
                    isExistPresent = true;
                }
                if (CollectionUtils.isEmpty((Collection)(deliverySubEntity = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
                long entrysrcbillid = entryEntity.getLong("entrysrcbillid");
                HashMap<Long, DynamicObject> deliveryIdWbStatusMap = (HashMap<Long, DynamicObject>)sourceBillIdDeliveryIdWbStatusMap.get(entrysrcbillid);
                if (deliveryIdWbStatusMap == null || deliveryIdWbStatusMap.size() == 0) {
                    deliveryIdWbStatusMap = new HashMap<Long, DynamicObject>(0);
                }
                for (DynamicObject deliveryObject : deliverySubEntity) {
                    long srcdeliveryentryid = deliveryObject.getLong("srcdeliveryentryid");
                    DynamicObject wbDeliveryStatus = deliveryObject.getDynamicObject("wbsrcdeliverstatus");
                    if (wbDeliveryStatus == null) continue;
                    deliveryIdWbStatusMap.put(srcdeliveryentryid, wbDeliveryStatus);
                }
                sourceBillIdDeliveryIdWbStatusMap.put(entrysrcbillid, deliveryIdWbStatusMap);
                if (initSaleOrder == null || StringUtils.equals((CharSequence)changeItemType, (CharSequence)"1")) continue;
                Map seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"goodsendentity", (String)"sendgoodsseq", (String)"3", (String)"giftrettype", (boolean)false, (String)"0");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqSyncRetTypeValue, (String)"goodsendentity", (String)"giftrettype", (boolean)true, (DynamicObject)entryEntity, (boolean)false);
                Map seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"salesorderpromote", (String)"sendgoodsseq", (String)"3", (String)"promoterettype", (boolean)true, (String)"0");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqPromoteSyncRetTypeValue, (String)"salesorderpromote", (String)"promoterettype", (boolean)true, (DynamicObject)entryEntity, (boolean)true);
                seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"ticketsendentity", (String)"goodsseq", (String)"3", (String)"ticketrettype", (boolean)false, (String)"1");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqSyncRetTypeValue, (String)"ticketsendentity", (String)"ticketrettype", (boolean)true, (DynamicObject)entryEntity, (boolean)false);
                seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"salesorderpromote", (String)"goodsseq", (String)"3", (String)"promoterettype", (boolean)true, (String)"1");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqPromoteSyncRetTypeValue, (String)"salesorderpromote", (String)"promoterettype", (boolean)true, (DynamicObject)entryEntity, (boolean)true);
                seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"sendintegralentity", (String)"insgoodsseq", (String)"3", (String)"pointrettype", (boolean)false, (String)"2");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqSyncRetTypeValue, (String)"sendintegralentity", (String)"pointrettype", (boolean)true, (DynamicObject)entryEntity, (boolean)false);
                seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"salesorderpromote", (String)"insgoodsseq", (String)"3", (String)"promoterettype", (boolean)true, (String)"2");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqPromoteSyncRetTypeValue, (String)"salesorderpromote", (String)"promoterettype", (boolean)true, (DynamicObject)entryEntity, (boolean)true);
            }
            if (initSaleOrder != null) {
                SaveServiceHelper.update((DynamicObject)initSaleOrder);
            }
            if (sourceBillIdDeliveryIdWbStatusMap.size() > 0) {
                for (Map.Entry entry : sourceBillIdDeliveryIdWbStatusMap.entrySet()) {
                    long entrysrcbillid = (Long)entry.getKey();
                    Map deliveryIdWbStatusMap = (Map)entry.getValue();
                    if (deliveryIdWbStatusMap == null || deliveryIdWbStatusMap.size() <= 0) continue;
                    DynamicObject entrysrcbill = BusinessDataServiceHelper.loadSingle((Object)entrysrcbillid, (String)"ocpos_saleorder");
                    SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus((DynamicObject)entrysrcbill, (Map)deliveryIdWbStatusMap, null);
                }
            }
            if (!StringUtils.equals((CharSequence)changeItemType, (CharSequence)"1") && isExistPresent && iniSrcSeqRetGoodsEntity.size() > 0) {
                SaleOrderWriteBackHelper.updateSaleOrderRetSendEntry((DynamicObject)dataEntity, iniSrcSeqRetGoodsEntity, (BigDecimal)BigDecimal.ONE, (String)"adretgiftdiscamount");
            }
            this.updateSaleChangeElectWarranty(dataEntity);
        }
    }

    private void updateSaleChangeElectWarranty(DynamicObject dataEntity) {
        ArrayList<Long> deliveryIds = new ArrayList<Long>();
        DynamicObjectCollection goodsEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject goodsObject : goodsEntity) {
            String saleOption;
            DynamicObjectCollection deliverySubEntity = goodsObject.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliverySubEntity) || !StringUtils.equals((CharSequence)(saleOption = goodsObject.getString("saleoption")), (CharSequence)"0")) continue;
            for (DynamicObject deliveryObject : deliverySubEntity) {
                long srcDeliveryEntryId = deliveryObject.getLong("srcdeliveryentryid");
                deliveryIds.add(srcDeliveryEntryId);
            }
        }
        if (!CollectionUtils.isEmpty(deliveryIds)) {
            ElectWarrantyHelper.updateElectWarranty(deliveryIds);
        }
    }
}

