/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleFinalAudit
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(SaleFinalAudit.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("srcbiztype");
        e.getFieldKeys().add("srcbillbiztype");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("ordersource");
        e.getFieldKeys().add("orderstatus");
        e.getFieldKeys().add("ismergebill");
        e.getFieldKeys().add("notconfirm");
        e.getFieldKeys().add("bizorgid");
        e.getFieldKeys().add("salebranchid");
        e.getFieldKeys().add("goodsentryentity.goodsid");
        e.getFieldKeys().add("goodsentryentity.brand");
        e.getFieldKeys().add("goodsentryentity.goodsclass");
        e.getFieldKeys().add("goodsentryentity.isbook");
        e.getFieldKeys().add("goodsentryentity.lastbillid");
        e.getFieldKeys().add("goodsentryentity.norecefinalamount");
        e.getFieldKeys().add("goodsentryentity.noreceexpectfinalamount");
        e.getFieldKeys().add("goodsentryentity.linereceivableamount");
        e.getFieldKeys().add("goodsentryentity.supplier");
        e.getFieldKeys().add("goodsentryentity.finalpayment");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("goodsentryentity.srcbillentryid");
        e.getFieldKeys().add("goodsentryentity.salesorderdelivery");
        e.getFieldKeys().add("salesorderdelivery.signstatus");
        e.getFieldKeys().add("salesorderdelivery.snmainfile");
        e.getFieldKeys().add("salesorderdelivery.isselfpickup");
        e.getFieldKeys().add("salesorderdelivery.deliverymode");
        e.getFieldKeys().add("salesorderdelivery.deliverystatus");
        e.getFieldKeys().add("salesorderdelivery.deliversaleqty");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntitys = e.getDataEntities();
        if (dataEntitys == null || dataEntitys.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntitys) {
            this.endUpdateSaleFinalDeliveryStatus(dataEntity);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntitys = e.getDataEntities();
        if (dataEntitys == null || dataEntitys.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntitys) {
            this.afterDelivaryBillAutoPushSaloutbill(dataEntity);
        }
    }

    private void endUpdateSaleFinalDeliveryStatus(DynamicObject dataEntity) {
        DynamicObject baseBillType = dataEntity.getDynamicObject("basebilltype");
        if (baseBillType == null) {
            return;
        }
        long baseBillTypeId = CommonUtil.formatObejctToLong((Object)baseBillType.getPkValue());
        if (baseBillTypeId != BillTypeEnum.FINAL.getId()) {
            return;
        }
        long sourceBillid = dataEntity.getLong("sourcebillid");
        if (sourceBillid <= 0L) {
            return;
        }
        ArrayList<Long> sourceBillIds = new ArrayList<Long>();
        ArrayList<Long> srcbillentryids = new ArrayList<Long>();
        DynamicObjectCollection goodsEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject goodsObject : goodsEntity) {
            long srcbillentryid;
            BigDecimal linereceivableamount = goodsObject.getBigDecimal("linereceivableamount");
            BigDecimal finalpayment = goodsObject.getBigDecimal("finalpayment");
            if (finalpayment.compareTo(linereceivableamount) < 0) continue;
            long entrySrcBillid = goodsObject.getLong("entrysrcbillid");
            if (!sourceBillIds.contains(entrySrcBillid)) {
                sourceBillIds.add(entrySrcBillid);
            }
            if ((srcbillentryid = goodsObject.getLong("srcbillentryid")) <= 0L) continue;
            srcbillentryids.add(srcbillentryid);
        }
        if (!CollectionUtils.isEmpty(sourceBillIds)) {
            DynamicObject[] sourceBills;
            for (DynamicObject sourceBill : sourceBills = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_saleorder"))) {
                HashMap<Long, Object> deliveryIdWbStatusMap = new HashMap<Long, Object>(0);
                DynamicObjectCollection srcEntryEntities = sourceBill.getDynamicObjectCollection("goodsentryentity");
                if (CollectionUtils.isEmpty((Collection)srcEntryEntities)) {
                    return;
                }
                for (DynamicObject srcEntry : srcEntryEntities) {
                    DynamicObjectCollection srcDeliveryEntity;
                    long srcentryid = DynamicObjectUtils.getPkValue((DynamicObject)srcEntry);
                    if (!srcbillentryids.contains(srcentryid) || CollectionUtils.isEmpty((Collection)(srcDeliveryEntity = srcEntry.getDynamicObjectCollection("salesorderdelivery")))) continue;
                    for (DynamicObject srcDeliveryEntry : srcDeliveryEntity) {
                        long srcDeliveryPkId = DynamicObjectUtils.getPkValue((DynamicObject)srcDeliveryEntry);
                        deliveryIdWbStatusMap.put(srcDeliveryPkId, null);
                    }
                }
                SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus((DynamicObject)sourceBill, deliveryIdWbStatusMap, null);
            }
        }
    }

    public void afterDelivaryBillAutoPushSaloutbill(DynamicObject dataEntity) {
        DynamicObject baseBillType = dataEntity.getDynamicObject("basebilltype");
        if (baseBillType == null) {
            return;
        }
        long baseBillTypeId = CommonUtil.formatObejctToLong((Object)baseBillType.getPkValue());
        if (baseBillTypeId != BillTypeEnum.FINAL.getId()) {
            return;
        }
        long sourceBillid = dataEntity.getLong("sourcebillid");
        if (sourceBillid <= 0L) {
            return;
        }
        ArrayList<Long> sourceBillIds = new ArrayList<Long>();
        DynamicObjectCollection goodsEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject goodsObject : goodsEntity) {
            BigDecimal linereceivableamount = goodsObject.getBigDecimal("linereceivableamount");
            BigDecimal finalpayment = goodsObject.getBigDecimal("finalpayment");
            if (finalpayment.compareTo(linereceivableamount) < 0) {
                return;
            }
            long entrySrcBillid = goodsObject.getLong("entrysrcbillid");
            if (sourceBillIds.contains(entrySrcBillid)) continue;
            sourceBillIds.add(entrySrcBillid);
        }
        if (!CollectionUtils.isEmpty(sourceBillIds)) {
            DynamicObject[] sourceBills;
            for (DynamicObject sourceBill : sourceBills = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_saleorder"))) {
                this.delivaryBillAutoPushSaloutbill(sourceBill);
            }
        }
    }

    public void delivaryBillAutoPushSaloutbill(DynamicObject saleOrder) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        long retailBillId = 0L;
        for (DynamicObject entryEntity : entryEntities) {
            boolean isBook = entryEntity.getBoolean("isbook");
            if (!isBook) {
                retailBillId = entryEntity.getLong("lastbillid");
            }
            if (retailBillId <= 0L) continue;
            break;
        }
        if (retailBillId < 0L) {
            return;
        }
        ArrayList<Long> deliveryBillIds = new ArrayList<Long>();
        DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((Object)retailBillId, (String)"ocococ_retailbill");
        DynamicObjectCollection rtItemEntrys = retailBill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)rtItemEntrys)) {
            for (DynamicObject rtItemEntry : rtItemEntrys) {
                DynamicObjectCollection rtDeliveryEntrys = rtItemEntry.getDynamicObjectCollection("ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)rtDeliveryEntrys)) continue;
                for (DynamicObject deliveryEntry : rtDeliveryEntrys) {
                    long deliveryBillId = deliveryEntry.getLong("lastbillid");
                    if (deliveryBillId <= 0L || deliveryBillIds.contains(deliveryBillId)) continue;
                    deliveryBillIds.add(deliveryBillId);
                }
            }
        }
        if (!CollectionUtils.isEmpty(deliveryBillIds)) {
            Iterator iterator = deliveryBillIds.iterator();
            while (iterator.hasNext()) {
                long deliveryBillId = (Long)iterator.next();
                OperationResult opResult = AutoPushHelper.autoPushBill((Object)deliveryBillId, (String)"ocococ_deliveryorder", (String)"im_saloutbill", (String)"audit");
                if (opResult == null || opResult.isSuccess()) continue;
                StringBuilder pushMsgBuilder = new StringBuilder();
                if (opResult.getAllErrorOrValidateInfo().size() <= 0) continue;
                opResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getMessage()).append(','));
                LOG.info(pushMsgBuilder.toString());
            }
        }
    }
}

