/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.ElectWarrantyHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.opplugin.saleorder.SaleReturnAuditValidator;

public class SaleReturnAudit
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("ordersource");
        e.getFieldKeys().add("orderstatus");
        e.getFieldKeys().add("salestatus");
        e.getFieldKeys().add("isselfpickup");
        e.getFieldKeys().add("ismergebill");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("receivableamount");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("salebranchid");
        e.getFieldKeys().add("setllementid");
        e.getFieldKeys().add("paywaytypeid");
        e.getFieldKeys().add("settlecurrid");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("settleamount");
        e.getFieldKeys().add("paytime");
        e.getFieldKeys().add("integralconsum");
        e.getFieldKeys().add("cardno");
        e.getFieldKeys().add("cardtypeid");
        e.getFieldKeys().add("tradereference");
        e.getFieldKeys().add("bankaccountid");
        e.getFieldKeys().add("orderno");
        e.getFieldKeys().add("stmamount");
        e.getFieldKeys().add("settlementrate");
        e.getFieldKeys().add("totalrealamount");
        e.getFieldKeys().add("stillneedtopay");
        e.getFieldKeys().add("receivableamount");
        e.getFieldKeys().add("srcbillbiztype");
        e.getFieldKeys().add("initialbillid");
        e.getFieldKeys().add("goodsentryentity.ispresent");
        e.getFieldKeys().add("goodsentryentity.srcbillentryid");
        e.getFieldKeys().add("goodsentryentity.saleqty");
        e.getFieldKeys().add("goodsentryentity.retailprice");
        e.getFieldKeys().add("goodsentryentity.salesorderdelivery");
        e.getFieldKeys().add("goodsentryentity.gifttype");
        e.getFieldKeys().add("goodsentryentity.inisrcseq");
        e.getFieldKeys().add("goodsentryentity.srcseq");
        e.getFieldKeys().add("goodsentryentity.adretgiftdiscamount");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("goodsentryentity.isbook");
        e.getFieldKeys().add("salesorderdelivery.snmainfile");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
        e.getFieldKeys().add("salesorderdelivery.deliverystatus");
        e.getFieldKeys().add("salesorderdelivery.wbsrcdeliverstatus");
        e.getFieldKeys().add("salesorderdelivery.srcdeliverystatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SaleReturnAuditValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntitys = e.getDataEntities();
        if (dataEntitys == null || dataEntitys.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntitys) {
            String srcbiztype;
            long sourceBillId = dataEntity.getLong("sourcebillid");
            if (sourceBillId <= 0L || StringUtils.equalsIgnoreCase((CharSequence)(srcbiztype = dataEntity.getString("srcbillbiztype")), (CharSequence)"H")) continue;
            String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus((DynamicObject)dataEntity);
            dataEntity.set("orderstatus", (Object)orderStatus);
            this.updateSourceBillData(dataEntity);
        }
    }

    public void updateSourceBillData(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObject initSaleOrder = null;
        long initialBillId = dataEntity.getLong("initialbillid");
        if (initialBillId > 0L) {
            initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
        }
        boolean isExistPresent = false;
        boolean isExistNoPresent = false;
        int entitySize = entryEntities.size();
        ArrayList<Integer> goodsEntrySrcSeqs = new ArrayList<Integer>();
        HashMap sourceBillIdDeliveryIdWbStatusMap = new HashMap(0);
        HashMap<Integer, DynamicObject> iniSrcSeqRetGoodsEntity = new HashMap<Integer, DynamicObject>(entitySize);
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliverySubEntity;
            boolean ispresent;
            boolean isBook;
            int inisrcseq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"inisrcseq");
            if (inisrcseq == 0) {
                inisrcseq = entryEntity.getInt("srcseq");
            }
            if (!(isBook = entryEntity.getBoolean("isbook"))) {
                iniSrcSeqRetGoodsEntity.put(inisrcseq, entryEntity);
                int srcSeq = entryEntity.getInt("srcseq");
                if (srcSeq != 0) {
                    goodsEntrySrcSeqs.add(srcSeq);
                }
            }
            if (!(ispresent = entryEntity.getBoolean("ispresent"))) {
                isExistNoPresent = true;
            } else {
                isExistPresent = true;
            }
            if (CollectionUtils.isEmpty((Collection)(deliverySubEntity = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            long entrysrcbillid = entryEntity.getLong("entrysrcbillid");
            HashMap<Long, DynamicObject> deliveryIdWbStatusMap = (HashMap<Long, DynamicObject>)sourceBillIdDeliveryIdWbStatusMap.get(entrysrcbillid);
            if (deliveryIdWbStatusMap == null || deliveryIdWbStatusMap.size() == 0) {
                deliveryIdWbStatusMap = new HashMap<Long, DynamicObject>(0);
            }
            for (DynamicObject deliveryObject : deliverySubEntity) {
                long srcdeliveryentryid = deliveryObject.getLong("srcdeliveryentryid");
                DynamicObject wbDeliveryStatus = deliveryObject.getDynamicObject("wbsrcdeliverstatus");
                if (wbDeliveryStatus == null) continue;
                deliveryIdWbStatusMap.put(srcdeliveryentryid, wbDeliveryStatus);
            }
            sourceBillIdDeliveryIdWbStatusMap.put(entrysrcbillid, deliveryIdWbStatusMap);
            if (initSaleOrder == null) continue;
            Map seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"ticketsendentity", (String)"goodsseq", (String)"3", (String)"ticketrettype", (boolean)false, (String)"1");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqSyncRetTypeValue, (String)"ticketsendentity", (String)"ticketrettype", (boolean)true, (DynamicObject)entryEntity, (boolean)false);
            Map seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"salesorderpromote", (String)"goodsseq", (String)"3", (String)"promoterettype", (boolean)true, (String)"1");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqPromoteSyncRetTypeValue, (String)"salesorderpromote", (String)"promoterettype", (boolean)true, (DynamicObject)entryEntity, (boolean)true);
            seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"sendintegralentity", (String)"insgoodsseq", (String)"3", (String)"pointrettype", (boolean)false, (String)"2");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqSyncRetTypeValue, (String)"sendintegralentity", (String)"pointrettype", (boolean)true, (DynamicObject)entryEntity, (boolean)false);
            seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap((DynamicObject)dataEntity, (DynamicObject)initSaleOrder, (DynamicObject)entryEntity, (String)"salesorderpromote", (String)"insgoodsseq", (String)"3", (String)"promoterettype", (boolean)true, (String)"2");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue((DynamicObject)initSaleOrder, (Map)seqPromoteSyncRetTypeValue, (String)"salesorderpromote", (String)"promoterettype", (boolean)true, (DynamicObject)entryEntity, (boolean)true);
        }
        if (initSaleOrder != null) {
            SaveServiceHelper.update((DynamicObject)initSaleOrder);
        }
        if (sourceBillIdDeliveryIdWbStatusMap.size() > 0) {
            for (Map.Entry entry : sourceBillIdDeliveryIdWbStatusMap.entrySet()) {
                long entrysrcbillid = (Long)entry.getKey();
                Map deliveryIdWbStatusMap = (Map)entry.getValue();
                DynamicObject entrysrcbill = BusinessDataServiceHelper.loadSingle((Object)entrysrcbillid, (String)"ocpos_saleorder");
                if (deliveryIdWbStatusMap != null && deliveryIdWbStatusMap.size() > 0) {
                    SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus((DynamicObject)entrysrcbill, (Map)deliveryIdWbStatusMap, null);
                }
                if (!isExistNoPresent || goodsEntrySrcSeqs.size() <= 0) continue;
                SaleOrderWriteBackHelper.updateSourceBillGiftCloseStatus((DynamicObject)entrysrcbill, goodsEntrySrcSeqs, (String)"B");
            }
        }
        if (isExistPresent && iniSrcSeqRetGoodsEntity.size() > 0) {
            SaleOrderWriteBackHelper.updateSaleOrderRetSendEntry((DynamicObject)dataEntity, iniSrcSeqRetGoodsEntity, (BigDecimal)BigDecimal.ONE, (String)"adretgiftdiscamount");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        ArrayList<Long> srcEntryIds = new ArrayList<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) continue;
            for (DynamicObject entryEntity : entryEntities) {
                long srcEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"srcbillentryid");
                if (srcEntryId <= 0L) continue;
                srcEntryIds.add(srcEntryId);
            }
        }
        if (!CollectionUtils.isEmpty(srcEntryIds)) {
            ElectWarrantyHelper.updateElectWarranty(srcEntryIds);
        }
    }
}

