/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.enums.BizTypeEnum;

public class SaleReturnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (dataEntity == null) continue;
            this.checkSourceBillDeliveryStatus(extendedDataEntity, dataEntity);
        }
    }

    private void checkSourceBillDeliveryStatus(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        String srcBizType = dataEntity.getString("srcbillbiztype");
        if (sourceBillId == 0L || StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)BizTypeEnum.CHANGE.getValue())) {
            return;
        }
        DynamicObjectCollection docGoodsEntry = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            QFilter qFilter;
            String selectFields;
            DynamicObjectCollection queryResult;
            HashSet<Long> sourceBillIds = new HashSet<Long>(0);
            HashMap<Long, Long> detailIdStatusIdMap = new HashMap<Long, Long>(0);
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid");
                if (entrySrcBillId == 0L) continue;
                sourceBillIds.add(entrySrcBillId);
                DynamicObjectCollection salesOrderDelivery = doGoodsEntry.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)salesOrderDelivery)) continue;
                for (DynamicObject delivery : salesOrderDelivery) {
                    long srcDeliveryEntryId = DynamicObjectUtils.getLong((DynamicObject)delivery, (String)"srcdeliveryentryid");
                    long srcDeliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)delivery, (String)"srcdeliverystatus");
                    if (srcDeliveryEntryId <= 0L || srcDeliveryStatusId <= 0L) continue;
                    detailIdStatusIdMap.put(srcDeliveryEntryId, srcDeliveryStatusId);
                }
            }
            if (detailIdStatusIdMap.size() > 0 && (queryResult = QueryServiceHelper.query((String)"ocpos_saleorder", (String)(selectFields = "goodsentryentity.salesorderdelivery,goodsentryentity.salesorderdelivery.deliverystatus"), (QFilter[])(qFilter = new QFilter("id", "in", sourceBillIds)).toArray())) != null && queryResult.size() > 0) {
                for (DynamicObject result : queryResult) {
                    long detailId = DynamicObjectUtils.getLong((DynamicObject)result, (String)"goodsentryentity.salesorderdelivery");
                    long deliveryStatusId = DynamicObjectUtils.getLong((DynamicObject)result, (String)"goodsentryentity.salesorderdelivery.deliverystatus");
                    Long statusId = (Long)detailIdStatusIdMap.get(detailId);
                    if (statusId == null || statusId == deliveryStatusId) continue;
                    this.addErrorMessage(extendedDataEntity, "\u6e90\u5355\u53d1\u8d27\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u5355\u3002");
                    break;
                }
            }
        }
    }
}

