/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;

public class SaleReturnUnSubmit
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("srcbillbiztype");
        e.getFieldKeys().add("goodsentryentity.srcbillentryid");
        e.getFieldKeys().add("goodsentryentity.ispresent");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
        e.getFieldKeys().add("salesorderdelivery.deliversaleqty");
        e.getFieldKeys().add("salesorderdelivery.deliverystatus");
        e.getFieldKeys().add("salesorderdelivery.wbsrcdeliverstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
            if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue()) || StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.REDRUSH.getValue())) continue;
            SaleOrderWriteBackHelper.updateSrcGiftQty((DynamicObject)dataEntity, (long)BillTypeEnum.RETURN.getId(), (Boolean)Boolean.FALSE);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            String srcBizType;
            long sourceBillId = dataEntity.getLong("sourcebillid");
            if (sourceBillId <= 0L || StringUtils.equalsIgnoreCase((CharSequence)(srcBizType = dataEntity.getString("srcbillbiztype")), (CharSequence)BizTypeEnum.CHANGE.getValue())) continue;
            HashMap sourceBillIdDeliveryIdQtyMap = new HashMap(0);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                long entrysrcbillid = entryEntity.getLong("entrysrcbillid");
                HashMap<Long, BigDecimal> deliveryQtyMap = (HashMap<Long, BigDecimal>)sourceBillIdDeliveryIdQtyMap.get(entrysrcbillid);
                if (deliveryQtyMap == null) {
                    deliveryQtyMap = new HashMap<Long, BigDecimal>(0);
                }
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    long srcDeliveryEntryId = deliveryEntity.getLong("srcdeliveryentryid");
                    BigDecimal deliverSaleQty = deliveryEntity.getBigDecimal("deliversaleqty");
                    deliveryQtyMap.put(srcDeliveryEntryId, deliverSaleQty.negate());
                }
                sourceBillIdDeliveryIdQtyMap.put(entrysrcbillid, deliveryQtyMap);
            }
            if (sourceBillIdDeliveryIdQtyMap.size() <= 0) continue;
            for (Map.Entry entry : sourceBillIdDeliveryIdQtyMap.entrySet()) {
                long entrysrcbillid = (Long)entry.getKey();
                Map deliveryQtyMap = (Map)entry.getValue();
                DynamicObject entrysrcbill = BusinessDataServiceHelper.loadSingle((Object)entrysrcbillid, (String)"ocpos_saleorder");
                SaleOrderWriteBackHelper.updateSaleOrderReturnQty((DynamicObject)entrysrcbill, (Map)deliveryQtyMap);
            }
        }
    }
}

