/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderCheckHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String entityId = dataEntity.getDataEntityType().getName();
            String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
            long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
            long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
            String srcBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbiztype");
            String srcBillBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbillbiztype");
            if (!StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)"H") && !StringUtils.equalsIgnoreCase((CharSequence)srcBillBizType, (CharSequence)"H")) {
                this.checkExistRelatedBillUnAudit(extendedDataEntity, dataEntity);
            }
            switch (entityId) {
                case "ocpos_saleorder": {
                    this.checkBill(extendedDataEntity, dataEntity);
                    this.checkSerialMustInput(extendedDataEntity, dataEntity);
                    this.checkSourceBillCloseStatus(extendedDataEntity, dataEntity);
                    this.checkItemInventory(extendedDataEntity, dataEntity);
                    break;
                }
                case "ocpos_saleorder_final": {
                    this.checkFinal(extendedDataEntity, dataEntity);
                    break;
                }
                case "ocpos_salechange": {
                    this.checkChange(extendedDataEntity, dataEntity);
                    this.checkItemInventory(extendedDataEntity, dataEntity);
                    break;
                }
                case "ocpos_saleorder_return": {
                    this.checkReturn(extendedDataEntity, dataEntity);
                    if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) break;
                    boolean bNoSrcReturnCheckLot = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getNoSrcReturnCheckLot((long)bizOrgId, (long)branchId));
                    boolean bNoSrcReturnCheckSerial = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getNoSrcReturnCheckSerial((long)bizOrgId, (long)branchId));
                    if (bNoSrcReturnCheckLot) {
                        this.checkLotMustInput(extendedDataEntity, dataEntity, false);
                    }
                    if (!bNoSrcReturnCheckSerial) break;
                    this.checkSerialMustInput(extendedDataEntity, dataEntity);
                    break;
                }
            }
            if (BillTypeEnum.CVTSALE.getId() != baseBillType && BillTypeEnum.GUIDE.getId() != baseBillType && BillTypeEnum.GROUP.getId() != baseBillType) continue;
            this.checkLotMustInput(extendedDataEntity, dataEntity, true);
        }
    }

    private void checkExistRelatedBillUnAudit(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long billId;
        JSONObject relatedJson;
        long sourceBillId = dataEntity.getLong("sourcebillid");
        if (sourceBillId > 0L && !(relatedJson = SaleOrderCheckHelper.checkRelatedBillUnAudit((long)sourceBillId, (long)(billId = dataEntity.getLong("Id")))).getBoolean("success").booleanValue()) {
            this.addErrorMessage(extendedDataEntity, relatedJson.getString("message"));
        }
    }

    private void checkSerialMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.CVTSALE.getId() || StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                return;
            }
            for (DynamicObject entryEntity : entryEntities) {
                boolean isBook;
                DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
                DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
                boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
                if (!isEnableSerial || (isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook"))) continue;
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    String serialNo;
                    boolean isVenderSell;
                    long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
                    boolean bl = isVenderSell = deliveryModeId == 1098521642067513344L;
                    boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)deliveryEntity, (String)"deliverisdelivery");
                    if (isDelivery || 1188335265681326080L == deliveryModeId || isVenderSell || !StringUtils.isEmpty((CharSequence)(serialNo = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliveryserialnumber")))) continue;
                    this.addErrorMessage(extendedDataEntity, "\u5546\u54c1\u660e\u7ec6\u7b2c" + seq + "\u884c\uff0c\u5e8f\u5217\u53f7\u5546\u54c1\u672a\u5f55\u5165\u5e8f\u5217\u53f7\u3002");
                }
            }
        }
    }

    private void checkLotMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, boolean isCvt) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isEnableLot = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enablelot");
            if (!isEnableLot) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                String lotNo = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliverylotnum");
                long deliverModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
                if (!StringUtils.isEmpty((CharSequence)lotNo)) continue;
                if (isCvt) {
                    boolean isBook;
                    long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                    if ((BillTypeEnum.GUIDE.getId() == baseBillType || BillTypeEnum.GROUP.getId() == baseBillType) && (isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook")) || 1098521642067513344L != deliverModeId) continue;
                    this.addErrorMessage(extendedDataEntity, "\u5546\u54c1\u660e\u7ec6\u7b2c" + seq + "\u884c\uff0c\u6279\u53f7\u5546\u54c1\u6ca1\u6709\u5f55\u5165\u6279\u53f7\uff0c\u8bf7\u4fee\u6539\u5546\u54c1\u751f\u6210\u6279\u53f7\u3002");
                    continue;
                }
                this.addErrorMessage(extendedDataEntity, "\u5546\u54c1\u660e\u7ec6\u7b2c" + seq + "\u884c\uff0c\u6279\u53f7\u5546\u54c1\u6ca1\u6709\u5f55\u5165\u6279\u53f7\uff0c\u8bf7\u4fee\u6539\u5546\u54c1\u751f\u6210\u6279\u53f7\u3002");
            }
        }
    }

    private void checkItemInventory(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        if (isInitBill) {
            return;
        }
        String srcBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbiztype");
        if (StringUtils.equals((CharSequence)srcBizType, (CharSequence)BizTypeEnum.CHANGE.getValue())) {
            return;
        }
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.STORE.getId() || billTypeId == BillTypeEnum.CHANGE.getId()) {
            ArrayList<DynamicObject> lstInvWithDelivery = new ArrayList<DynamicObject>(0);
            ArrayList<DynamicObject> lstInvWithoutDelivery = new ArrayList<DynamicObject>(0);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            boolean isRight = true;
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities;
                if (billTypeId == BillTypeEnum.CHANGE.getId()) {
                    boolean isChangeNewGift;
                    String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
                    if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3") || StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || (isChangeNewGift = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ischangenewgift"))) continue;
                }
                if (CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery")))) continue;
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
                String operationMode = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"operationmodel");
                boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
                long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"itemtypeid");
                boolean isService = itemsTypeId == 870946434386494464L;
                boolean isAmt = itemsTypeId == 870946349007286272L;
                boolean isVenderSell = deliveryEntities.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"deliverymode") == 1098521642067513344L);
                if (isBook || isJoint || isService || isAmt || isVenderSell) continue;
                boolean isDelivery = deliveryEntities.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"deliverisdelivery"));
                if (isDelivery) {
                    boolean exitsTimeNull = deliveryEntities.stream().anyMatch(x -> DynamicObjectUtils.getDate((DynamicObject)x, (String)"deliverdeliverytime") == null);
                    if (exitsTimeNull) {
                        this.addErrorMessage(extendedDataEntity, String.format("\u7b2c%d\u884c\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u586b\u5199\u201c\u914d\u9001\u65f6\u95f4\u201d\u3002", DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq")));
                        isRight = false;
                        continue;
                    }
                    lstInvWithDelivery.add(entryEntity);
                    continue;
                }
                lstInvWithoutDelivery.add(entryEntity);
            }
            String billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
            if (!StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"C")) {
                if (isRight && lstInvWithDelivery.size() > 0) {
                    this.checkInventoryInfoWithDelivery(extendedDataEntity, lstInvWithDelivery);
                }
                if (lstInvWithoutDelivery.size() > 0) {
                    this.checkInventoryInfoWithoutDelivery(extendedDataEntity, lstInvWithoutDelivery);
                }
            }
        }
    }

    private void checkSourceBillCloseStatus(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObject doBillType = dataEntity.getDynamicObject("basebilltype");
        if (ObjectUtils.isEmpty((Object)doBillType)) {
            return;
        }
        if (DynamicObjectUtils.getPkValue((DynamicObject)doBillType) != BillTypeEnum.CVTSALE.getId()) {
            return;
        }
        boolean bNotConfirm = dataEntity.getBoolean("notconfirm");
        if (bNotConfirm) {
            DynamicObject sourceBill;
            String closeStatus;
            String billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
            long sourceBillId = dataEntity.getLong("sourcebillid");
            if (!StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"C") && sourceBillId > 0L && StringUtils.equals((CharSequence)(closeStatus = DynamicObjectUtils.getString((DynamicObject)(sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder")), (String)"closestatus")), (CharSequence)CloseStatusEnum.CLOSE.getValue())) {
                this.addErrorMessage(extendedDataEntity, String.format("\u9884\u8ba2\u9884\u5b58\u5355\u636e\uff1a%s\uff0c\u5173\u95ed\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\u3002", DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"billno")));
            }
        }
    }

    private void checkBill(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        if (!isNotConfirm) {
            String billStatus;
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                this.addErrorMessage(extendedDataEntity, "\u8bf7\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002");
                return;
            }
            boolean isRight = true;
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(5);
            ArrayList<Long> snMainFileIds = new ArrayList<Long>();
            ArrayList<Long> deliveryIds = new ArrayList<Long>(0);
            boolean isSalerMustInput = this.getIsSalerMustInput(dataEntity);
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities;
                int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
                long salerId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodssaler");
                if (isSalerMustInput && salerId <= 0L) {
                    this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u9500\u552e\u5458\u3002", seq));
                }
                if (CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery")))) {
                    this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u7ef4\u62a4\u7b2c%d\u884c\u5546\u54c1\u914d\u9001\u660e\u7ec6\u3002", seq));
                    isRight = false;
                    continue;
                }
                boolean isInvOrgAndStockNotNull = this.checkInvOrgAndStockInfo(extendedDataEntity, dataEntity, entryEntity, deliveryEntities);
                if (!isInvOrgAndStockNotNull) {
                    isRight = false;
                    continue;
                }
                BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
                BigDecimal subQty = BigDecimal.ZERO;
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    long deliveryId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"srcdeliveryentryid");
                    long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
                    if (snMainFileId > 0L) {
                        snMainFileIds.add(snMainFileId);
                        map.put(snMainFileId, seq);
                        if (deliveryId > 0L) {
                            deliveryIds.add(deliveryId);
                        }
                    }
                    subQty = subQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty"));
                }
                if (qty.compareTo(subQty) == 0) continue;
                this.addErrorMessage(extendedDataEntity, String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0e\u5176\u914d\u9001\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", seq));
                isRight = false;
            }
            if (!CollectionUtils.isEmpty(snMainFileIds) && isRight && !StringUtils.equalsIgnoreCase((CharSequence)(billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus")), (CharSequence)"C")) {
                this.checkSnStatus(extendedDataEntity, snMainFileIds, map, deliveryIds);
            }
            this.checkGiftValue(extendedDataEntity, dataEntity, entryEntities);
        }
    }

    private void checkFinal(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection entryEntities;
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId != BillTypeEnum.CREDIT.getId() && CollectionUtils.isEmpty((Collection)(entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity")))) {
            this.addErrorMessage(extendedDataEntity, "\u8bf7\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002");
        }
    }

    private void checkChange(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String billStatus;
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(5);
        ArrayList<Long> snMainFileIds = new ArrayList<Long>();
        ArrayList<Long> deliveryIds = new ArrayList<Long>(0);
        boolean isSalerMustInput = this.getIsSalerMustInput(dataEntity);
        boolean isRight = true;
        boolean isExistSale = false;
        boolean isExistReturn = false;
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
                long salerId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodssaler");
                if (isSalerMustInput && salerId <= 0L) {
                    this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u9500\u552e\u5458\u3002", seq));
                }
                isExistSale = true;
            } else {
                isExistReturn = true;
            }
            if (CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery")))) continue;
            boolean isInvOrgAndStockNotNull = this.checkInvOrgAndStockInfo(extendedDataEntity, dataEntity, entryEntity, deliveryEntities);
            if (!isInvOrgAndStockNotNull) {
                isRight = false;
                continue;
            }
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            BigDecimal subQty = BigDecimal.ZERO;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
                    long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
                    long deliveryId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"srcdeliveryentryid");
                    if (snMainFileId > 0L) {
                        snMainFileIds.add(snMainFileId);
                        map.put(snMainFileId, seq);
                        if (deliveryId > 0L) {
                            deliveryIds.add(deliveryId);
                        }
                    }
                }
                subQty = subQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty"));
            }
            if (qty.compareTo(subQty) == 0) continue;
            this.addErrorMessage(extendedDataEntity, String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0e\u5176\u914d\u9001\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", seq));
            isRight = false;
        }
        String orderSource = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"ordersource");
        if (!(StringUtils.equals((CharSequence)orderSource, (CharSequence)"D") || StringUtils.equals((CharSequence)orderSource, (CharSequence)"E") || isExistSale && isExistReturn)) {
            this.addErrorMessage(extendedDataEntity, "\u5355\u636e\u65e0\u6cd5\u4fdd\u5b58\uff0c\u5546\u54c1\u660e\u7ec6\u5fc5\u987b\u6709\u9000\u8d27\u884c\u548c\u9500\u552e\u884c\u3002");
        }
        if (!CollectionUtils.isEmpty(snMainFileIds) && isRight && !StringUtils.equalsIgnoreCase((CharSequence)(billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus")), (CharSequence)"C")) {
            this.checkSnStatus(extendedDataEntity, snMainFileIds, map, deliveryIds);
        }
    }

    private void checkReturn(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        if (isNotConfirm) {
            return;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            this.addErrorMessage(extendedDataEntity, "\u8bf7\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002");
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isReturnReasonMustInput = SystemParamUtil.getIsReturnReasonMustInput((long)orgId, (long)branchId);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        boolean isCancelOrder = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue());
        boolean isSalerMustInput = this.getIsSalerMustInput(dataEntity);
        for (DynamicObject entryEntity : entryEntities) {
            boolean isInvOrgAndStockNotNull;
            DynamicObjectCollection deliveryEntities;
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
            long salerId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodssaler");
            if (isSalerMustInput && salerId <= 0L) {
                this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u9500\u552e\u5458\u3002", seq));
            }
            if (CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery"))) || !(isInvOrgAndStockNotNull = this.checkInvOrgAndStockInfo(extendedDataEntity, dataEntity, entryEntity, deliveryEntities))) continue;
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            BigDecimal subQty = BigDecimal.ZERO;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                int subSeq = DynamicObjectUtils.getInt((DynamicObject)deliveryEntity, (String)"seq");
                long reasonId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"returnreason");
                String orderSource = DynamicObjectUtils.getString((DynamicObject)extendedDataEntity.getDataEntity(), (String)"ordersource");
                if (isReturnReasonMustInput && reasonId <= 0L && !StringUtils.equals((CharSequence)orderSource, (CharSequence)"D") && !StringUtils.equals((CharSequence)orderSource, (CharSequence)"E")) {
                    this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u7b2c%d\u884c\u5546\u54c1\u7b2c%d\u884c\u914d\u9001\u4fe1\u606f\u7684\u9000\u8d27\u539f\u56e0\u3002", seq, subSeq));
                }
                if (!isCancelOrder) {
                    long unitId;
                    BigDecimal deliveryQty;
                    long barCodeId;
                    long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"delivergoodsid");
                    if (goodsId <= 0L) {
                        this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u7b2c%d\u884c\u5546\u54c1\u7b2c%d\u884c\u914d\u9001\u4fe1\u606f\u7684\u5546\u54c1\u7f16\u7801\u3002", seq, subSeq));
                    }
                    if ((barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverbarcodeid")) <= 0L) {
                        this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u7b2c%d\u884c\u5546\u54c1\u7b2c%d\u884c\u914d\u9001\u4fe1\u606f\u7684\u6761\u5f62\u7801\u3002", seq, subSeq));
                    }
                    if ((deliveryQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty")) == null || deliveryQty.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u7b2c%d\u884c\u5546\u54c1\u7b2c%d\u884c\u914d\u9001\u4fe1\u606f\u7684\u9000\u8d27\u6570\u91cf\u3002", seq, subSeq));
                    }
                    if ((unitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverunitid")) <= 0L) {
                        this.addErrorMessage(extendedDataEntity, String.format("\u8bf7\u586b\u5199\u7b2c%d\u884c\u5546\u54c1\u7b2c%d\u884c\u914d\u9001\u4fe1\u606f\u7684\u8ba1\u91cf\u5355\u4f4d\u3002", seq, subSeq));
                    }
                }
                subQty = subQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty"));
            }
            if (saleQty.compareTo(subQty) == 0) continue;
            this.addErrorMessage(extendedDataEntity, String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0e\u5176\u914d\u9001\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", seq));
        }
    }

    private boolean checkInvOrgAndStockInfo(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, DynamicObject entryEntity, DynamicObjectCollection deliveryEntities) {
        boolean isInvInfoIsNull = deliveryEntities.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"inventoryorgid") <= 0L || DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"erpstockid") <= 0L);
        if (isInvInfoIsNull) {
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
            boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)entryEntity);
            String type = "\u9500\u552e";
            if (isChangeReturnOrReturn) {
                type = "\u9000\u8d27";
            }
            this.addErrorMessage(extendedDataEntity, String.format("\u7b2c%d\u884c%s\u884c\u5546\u54c1\u5e93\u5b58\u7ec4\u7ec7\u6216\u4ed3\u5e93\u4e3a\u7a7a\uff0c \u8bf7\u4fee\u6539\u3002", seq, type));
            return false;
        }
        return true;
    }

    private void checkSnStatus(ExtendedDataEntity extendedDataEntity, List<Long> snMainFileIds, Map<Long, Integer> map, List<Long> deliveryIds) {
        QFilter filter = new QFilter("id", "in", snMainFileIds);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bd_snmainfile", (String)"id, number, snstatus", (QFilter[])filter.toArray());
        DynamicObjectCollection deliveryData = null;
        if (deliveryIds.size() > 0) {
            filter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", (Object)deliveryIds.toArray());
            deliveryData = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"goodsentryentity.salesorderdelivery.snmainfile as serialid", (QFilter[])filter.toArray());
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            for (DynamicObject item : data) {
                String snStatus = DynamicObjectUtils.getString((DynamicObject)item, (String)"snstatus");
                if (StringUtils.equals((CharSequence)snStatus, (CharSequence)"B")) continue;
                String sn = DynamicObjectUtils.getString((DynamicObject)item, (String)"number");
                long snMainFileId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"id");
                if (deliveryData != null && deliveryData.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"serialid") == snMainFileId)) continue;
                String tip = String.format("\u7b2c%d\u884c\u5546\u54c1\u5e8f\u5217\u53f7\u201c%s\u201d\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", map.get(snMainFileId), sn);
                this.addErrorMessage(extendedDataEntity, tip);
            }
        }
    }

    private void checkGiftValue(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, DynamicObjectCollection entryEntities) {
        long branchId;
        boolean isReserve = entryEntities.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isbook") && !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent"));
        if (!isReserve) {
            return;
        }
        boolean isExitGift = entryEntities.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent"));
        if (!isExitGift) {
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        boolean isAllowGiftExcess = SystemParamUtil.isAllowGiftExcess((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")));
        if (isAllowGiftExcess) {
            return;
        }
        BigDecimal totalValue = BigDecimal.ZERO;
        for (DynamicObject entryEntity : entryEntities) {
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            if (isPresent) continue;
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
            if (isBook) {
                BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
                totalValue = totalValue.add(deposit);
                continue;
            }
            BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"balamount");
            totalValue = totalValue.add(balAmount);
        }
        BigDecimal totalGiftValue = BigDecimal.ZERO;
        DynamicObjectCollection giftEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        if (!CollectionUtils.isEmpty((Collection)giftEntities)) {
            for (DynamicObject giftEntity : giftEntities) {
                BigDecimal giftPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)giftEntity, (String)"giftprice");
                BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)giftEntity, (String)"sendqty");
                totalGiftValue = totalGiftValue.add(giftPrice.multiply(qty));
            }
        }
        if (totalGiftValue.compareTo(totalValue) > 0) {
            this.addErrorMessage(extendedDataEntity, "\u8d60\u54c1\u91d1\u989d\u8d85\u8fc7\u8ba2\u91d1\uff0c\u4e0d\u5141\u8bb8\u8d60\u9001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u91cd\u65b0\u7ef4\u62a4\u8ba2\u91d1\u3002");
        }
    }

    private void checkInventoryInfoWithDelivery(ExtendedDataEntity dataEntity, List<DynamicObject> lstInvWithDelivery) {
        DynamicObject billData = dataEntity.getDataEntity();
        List<Map<String, Object>> params = this.getDeliveryParams(billData, lstInvWithDelivery);
        List result = SaleOrderDeliveryInfoHelper.exactMatchingDeliveryInfo(params);
        for (Map map : result) {
            boolean success = CommonUtil.formatObjectToBoolean(map.get("success"));
            if (success) continue;
            String seq = String.valueOf(map.get("seq"));
            String message = String.valueOf(map.get("message"));
            this.addErrorMessage(dataEntity, "\u5546\u54c1\u660e\u7ec6\u7b2c" + seq + "\u884c\uff0c" + message);
        }
    }

    private void checkInventoryInfoWithoutDelivery(ExtendedDataEntity dataEntity, List<DynamicObject> lstInvWithoutDelivery) {
        DynamicObject billData = dataEntity.getDataEntity();
        List<JSONObject> params = this.getInventoryParams(billData, lstInvWithoutDelivery);
        List inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(params);
        if (CollectionUtils.isEmpty((Collection)inventoryInfo)) {
            this.addErrorMessage(dataEntity, "\u5546\u54c1\u660e\u7ec6\u6240\u6709\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6267\u884c\u9884\u8ba2\u3002");
        } else {
            for (JSONObject inventoryItem : inventoryInfo) {
                String invStatus = inventoryItem.getString("invstatus");
                if (StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) continue;
                String seq = inventoryItem.getString("customerKey");
                this.addErrorMessage(dataEntity, "\u5546\u54c1\u660e\u7ec6\u7b2c" + seq + "\u884c\uff0c\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6267\u884c\u9884\u8ba2\u3002");
            }
        }
    }

    private List<JSONObject> getInventoryParams(DynamicObject billData, List<DynamicObject> lstInvWithoutDelivery) {
        ArrayList<JSONObject> lstInventoryParam = new ArrayList<JSONObject>(0);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)billData, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)billData, (String)"salebranchid");
        for (DynamicObject entryData : lstInvWithoutDelivery) {
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryData, (String)"seq");
            String operationMode = DynamicObjectUtils.getString((DynamicObject)entryData, (String)"operationmodel");
            DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryData, (String)"salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                JSONObject inventoryParam = new JSONObject();
                inventoryParam.put("saleOrgId", (Object)bizOrgId);
                inventoryParam.put("saleChannelID", (Object)branchId);
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"delivergoodsid");
                inventoryParam.put("itemId", (Object)goodsId);
                long materialId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial");
                inventoryParam.put("materialId", (Object)materialId);
                DynamicObject barcode = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverbarcodeid");
                if (barcode != null) {
                    long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)barcode, (String)"auxpty");
                    inventoryParam.put("auxPtyID", (Object)auxAttrId);
                }
                long unitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverunitid");
                inventoryParam.put("unitId", (Object)unitId);
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty");
                inventoryParam.put("unitQty", (Object)saleQty);
                long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverybaseunit");
                inventoryParam.put("baseUnitID", (Object)baseUnitId);
                BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliverybaseunitqty");
                inventoryParam.put("baseUnitQty", (Object)baseUnitQty);
                long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverystocktype");
                inventoryParam.put("invtypeid", (Object)invTypeId);
                long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid");
                inventoryParam.put("stockOrgId", (Object)invOrgId);
                long erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid");
                inventoryParam.put("warehouseId", (Object)erpStockId);
                long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
                inventoryParam.put("distributionModeId", (Object)distributionModeId);
                String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"districtid");
                inventoryParam.put("adminDivisionId", (Object)adminDivisionId);
                inventoryParam.put("customerKey", (Object)seq);
                lstInventoryParam.add(inventoryParam);
            }
        }
        return lstInventoryParam;
    }

    private List<Map<String, Object>> getDeliveryParams(DynamicObject billData, List<DynamicObject> lstDeliveryData) {
        ArrayList<Map<String, Object>> lstDeliveryParam = new ArrayList<Map<String, Object>>(0);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)billData, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)billData, (String)"salebranchid");
        for (DynamicObject entryData : lstDeliveryData) {
            DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryData, (String)"salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryData, (String)"seq");
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryData, (String)"ispresent");
            boolean isNegativeSell = DynamicObjectUtils.getBoolean((DynamicObject)entryData, (String)"isnegativesell");
            long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)entryData, (String)"oversalepolicyid");
            long overSalePolicyEntryId = DynamicObjectUtils.getLong((DynamicObject)entryData, (String)"oversalepolicyentryid");
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryData, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            for (DynamicObject deliveryEntity : deliveryEntities) {
                HashMap<String, Object> params = new HashMap<String, Object>(0);
                params.put("index", seq - 1);
                params.put("seq", seq);
                params.put("saleOrgId", bizOrgId);
                params.put("saleChannelID", branchId);
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"delivergoodsid");
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
                params.put("itemId", goodsId);
                String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"districtid");
                params.put("adminDivisionId", adminDivisionId);
                long materialId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial");
                params.put("materialId", materialId);
                long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverybaseunit");
                params.put("baseUnitID", baseUnitId);
                BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliverybaseunitqty");
                params.put("baseUnitQty", baseUnitQty);
                long unitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverunitid");
                params.put("unitId", unitId);
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty");
                params.put("unitQty", saleQty);
                Date deliveryDate = DynamicObjectUtils.getDate((DynamicObject)deliveryEntity, (String)"deliverdeliverytime");
                params.put("deliveryDate", deliveryDate);
                DynamicObject barcode = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverbarcodeid");
                if (barcode != null) {
                    long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)barcode, (String)"auxpty");
                    params.put("auxPtyID", auxAttrId);
                }
                Date bizDate = DynamicObjectUtils.getDate((DynamicObject)billData, (String)"bizdate");
                params.put("bizdate", bizDate);
                long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverystocktype");
                params.put("invtypeid", invTypeId);
                long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid");
                params.put("stockOrgId", invOrgId);
                long erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid");
                params.put("warehouseId", erpStockId);
                long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
                params.put("distributionModeId", deliveryModeId);
                long deliveryBranchId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverdeliverybranchid");
                params.put("deliveryChannelId", deliveryBranchId);
                long deliverStockId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverstockid");
                params.put("channelwarehouseid", deliverStockId);
                params.put("ispresent", isPresent);
                params.put("enableserial", isEnableSerial);
                params.put("isnegativesell", isNegativeSell);
                params.put("oversalepolicyid", overSalePolicyId);
                params.put("oversalepolicyentryid", overSalePolicyEntryId);
                lstDeliveryParam.add(params);
            }
        }
        return lstDeliveryParam;
    }

    private boolean getIsSalerMustInput(DynamicObject dataEntity) {
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        return SystemParamUtil.getIsSaleMustInput((long)orgId, (long)branchId);
    }
}

