/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.business.helper.CreditMangageHelper;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleSettleValidator
extends AbstractValidator {
    public void validate() {
        block12: for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            String entityId;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (dataEntity == null) continue;
            switch (entityId = dataEntity.getDataEntityType().getName()) {
                case "ocpos_saleorder": {
                    this.checkRetailSystemParam(extendedDataEntity, dataEntity);
                    this.checkCreditAmount(dataEntity, extendedDataEntity);
                    continue block12;
                }
                case "ocpos_saleorder_final": {
                    continue block12;
                }
                case "ocpos_salechange": {
                    this.checkChangeIsAllowSelttle(extendedDataEntity, dataEntity);
                    continue block12;
                }
                case "ocpos_saleorder_return": {
                    continue block12;
                }
            }
        }
    }

    private void checkRetailSystemParam(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        BigDecimal receivableAmount;
        DynamicObjectCollection docGoodsEntry;
        long branchId;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        boolean isAllowZeroSaleNoGift = SystemParamUtil.getIsAllowZeroSaleNotGift((long)bizOrgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")));
        if (!isAllowZeroSaleNoGift && !CollectionUtils.isEmpty((Collection)(docGoodsEntry = dataEntity.getDynamicObjectCollection("goodsentryentity")))) {
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent");
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                if (isPresent || balAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                this.addErrorMessage(extendedDataEntity, "\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u975e\u8d60\u54c1\u5141\u8bb8\u96f6\u5355\u4ef7\u9500\u552e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002");
            }
        }
        String bizType = dataEntity.getString("biztype");
        boolean isAllowZeroSettleOrder = SystemParamUtil.getIsAllowZeroSettleOrder((long)bizOrgId, (long)branchId);
        if (!isAllowZeroSettleOrder && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"C") && (receivableAmount = dataEntity.getBigDecimal("receivableamount")).compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(extendedDataEntity, "\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u5141\u8bb8\u6574\u5355\u96f6\u91d1\u989d\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002");
        }
    }

    private void checkChangeIsAllowSelttle(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection docGoodsEntry = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            HashSet returnBillIdSet;
            long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_salechange", (Long[])new Long[]{billId});
            HashSet saleBillIdSet = (HashSet)targetBills.get("ocpos_saleorder");
            if (saleBillIdSet == null || saleBillIdSet.size() == 0) {
                this.addErrorMessage(extendedDataEntity, "\u672a\u751f\u6210\u96f6\u552e\u5f00\u5355\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002");
            }
            if ((returnBillIdSet = (HashSet)targetBills.get("ocpos_saleorder_return")) == null || returnBillIdSet.size() == 0) {
                this.addErrorMessage(extendedDataEntity, "\u672a\u751f\u6210\u96f6\u552e\u9000\u8d27\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002");
            }
        }
    }

    private void checkCreditAmount(DynamicObject dataEntity, ExtendedDataEntity extendedDataEntity) {
        BigDecimal creditAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"creditamount");
        if (creditAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        DynamicObject creditAccount = CreditMangageHelper.getCreditAccountInfo((long)branchId);
        this.checkCreditAmount(creditAccount, creditAmount, extendedDataEntity);
    }

    private void checkCreditAmount(DynamicObject creditAccount, BigDecimal creditAmount, ExtendedDataEntity extendedDataEntity) {
        DynamicObject creditRule = DynamicObjectUtils.getDynamicObject((DynamicObject)creditAccount, (String)"creditruleid");
        String accountName = DynamicObjectUtils.getString((DynamicObject)creditAccount, (String)"name");
        DynamicObjectCollection ruleEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)creditRule, (String)"entity");
        if (CollectionUtils.isEmpty((Collection)ruleEntity)) {
            this.addErrorMessage(extendedDataEntity, String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u660e\u7ec6\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName));
            return;
        }
        DynamicObject ruleEntityRow = ruleEntity.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getStrPkValue((DynamicObject)x, (String)"billid"), (CharSequence)"ocpos_saleorder")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)ruleEntityRow)) {
            this.addErrorMessage(extendedDataEntity, String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName));
            return;
        }
        BigDecimal overDueDays = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overduedays");
        BigDecimal overDueAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overdueamount");
        BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
        boolean isCheckOverDays = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverdays");
        boolean isCheckOverLimit = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverlimit");
        boolean daysIsOverDue = isCheckOverDays && overDueDays.compareTo(BigDecimal.ZERO) > 0;
        boolean limitIsOver = isCheckOverLimit && overDueAmount.compareTo(BigDecimal.ZERO) > 0;
        boolean balanceIsNull = limitBalance.compareTo(BigDecimal.ZERO) <= 0;
        boolean isOverDue = daysIsOverDue || limitIsOver || balanceIsNull;
        boolean isAllOverDue = daysIsOverDue && limitIsOver && balanceIsNull;
        String overProOfGist = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"overproofgist");
        boolean overDue = isOverDue && StringUtils.equals((CharSequence)"A", (CharSequence)overProOfGist);
        boolean allOverDue = isAllOverDue && StringUtils.equals((CharSequence)"B", (CharSequence)overProOfGist);
        String ctrlGrade = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"controlgrade");
        if ((overDue || allOverDue) && StringUtils.equals((CharSequence)ctrlGrade, (CharSequence)"B")) {
            this.addErrorMessage(extendedDataEntity, "\u8d4a\u9500\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8d4a\u9500\u6536\u6b3e");
            return;
        }
        if (limitBalance.compareTo(creditAmount) < 0) {
            this.addErrorMessage(extendedDataEntity, String.format("\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u76ee\u524d\u4fe1\u7528\u4f59\u989d%.2f\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d%.2f", limitBalance, creditAmount));
        }
    }
}

