/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;

public class SaleSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("basebilltype");
        e.getFieldKeys().add("notconfirm");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("goodsentryentity.srcbillentryid");
        e.getFieldKeys().add("goodsentryentity.ispresent");
        e.getFieldKeys().add("goodsentryentity.notbookpresent");
        e.getFieldKeys().add("goodsentryentity.gifttype");
        e.getFieldKeys().add("goodsentryentity.saleqty");
        e.getFieldKeys().add("goodsentryentity.inisrcseq");
        e.getFieldKeys().add("goodsentryentity.srcseq");
        e.getFieldKeys().add("goodsentryentity.entrysrcbillid");
        e.getFieldKeys().add("salesorderdelivery.srcdeliveryentryid");
        e.getFieldKeys().add("salesorderdelivery.deliversaleqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
                SaleOrderWriteBackHelper.updateSrcGiftQty((DynamicObject)dataEntity, (long)billTypeId, (Boolean)Boolean.TRUE);
                continue;
            }
            if (billTypeId != BillTypeEnum.GUIDE.getId() && billTypeId != BillTypeEnum.GROUP.getId()) continue;
            SaleOrderWriteBackHelper.updateGuideSrcGiftQty((DynamicObject)dataEntity, (Boolean)Boolean.TRUE);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            if (baseBillTypeId != BillTypeEnum.CVTSALE.getId()) continue;
            long sourceBillId = dataEntity.getLong("sourcebillid");
            if (sourceBillId <= 0L) {
                return;
            }
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder");
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                return;
            }
            boolean bNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
            if (bNotConfirm) continue;
            this.updateSourceBillQty(entryEntities, sourceBill);
            this.updateSourceBillCvtSendEntry(dataEntity, entryEntities);
        }
    }

    private void updateSourceBillQty(DynamicObjectCollection entryEntities, DynamicObject sourceBill) {
        HashMap sourceBillIdDeliveryIdQtyMap = new HashMap(0);
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            long entrySrcBillId = entryEntity.getLong("entrysrcbillid");
            HashMap<Long, BigDecimal> deliveryQtyMap = (HashMap<Long, BigDecimal>)sourceBillIdDeliveryIdQtyMap.get(entrySrcBillId);
            if (deliveryQtyMap == null) {
                deliveryQtyMap = new HashMap<Long, BigDecimal>(0);
            }
            for (DynamicObject deliveryEntity : deliveryEntities) {
                long srcDeliveryEntryId = deliveryEntity.getLong("srcdeliveryentryid");
                BigDecimal deliverSaleQty = deliveryEntity.getBigDecimal("deliversaleqty");
                deliveryQtyMap.put(srcDeliveryEntryId, deliverSaleQty);
            }
            sourceBillIdDeliveryIdQtyMap.put(entrySrcBillId, deliveryQtyMap);
        }
        if (sourceBillIdDeliveryIdQtyMap.size() > 0) {
            for (Map.Entry entry : sourceBillIdDeliveryIdQtyMap.entrySet()) {
                long entrySrcBillId = (Long)entry.getKey();
                Map deliveryQtyMap = (Map)entry.getValue();
                DynamicObject entrySrcBill = entrySrcBillId == DynamicObjectUtils.getPkValue((DynamicObject)sourceBill) ? sourceBill : BusinessDataServiceHelper.loadSingle((Object)entrySrcBillId, (String)"ocpos_saleorder");
                SaleOrderWriteBackHelper.updateSaleOrderToSaleQty((DynamicObject)entrySrcBill, (Map)deliveryQtyMap);
            }
        }
    }

    private void updateSourceBillCvtSendEntry(DynamicObject dataEntity, DynamicObjectCollection entryEntities) {
        boolean isExistPresent = false;
        HashMap<Integer, DynamicObject> iniSrcSeqRetGoodsEntity = new HashMap<Integer, DynamicObject>(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            int iniSrcSeq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"inisrcseq");
            if (iniSrcSeq == 0) {
                iniSrcSeq = entryEntity.getInt("srcseq");
            }
            iniSrcSeqRetGoodsEntity.put(iniSrcSeq, entryEntity);
            boolean isPresent = entryEntity.getBoolean("ispresent");
            boolean notBookPresent = entryEntity.getBoolean("notbookpresent");
            if (!isPresent || notBookPresent) continue;
            isExistPresent = true;
        }
        if (isExistPresent && iniSrcSeqRetGoodsEntity.size() > 0) {
            SaleOrderWriteBackHelper.updateSaleOrderRetSendEntry((DynamicObject)dataEntity, iniSrcSeqRetGoodsEntity, (BigDecimal)BigDecimal.ONE, (String)"giftdiscountamount");
        }
    }
}

