/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.creditadjust;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class Audit
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(Audit.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("adjustbranch");
        e.getFieldKeys().add("receivabledate");
        e.getFieldKeys().add("newreceivabledate");
        e.getFieldKeys().add("finentryid");
        e.getFieldKeys().add("creditamount");
        e.getFieldKeys().add("creditaccountid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) {
                return;
            }
            List<Object> lstEntryId = docEntry.stream().map(x -> DynamicObjectUtils.get((DynamicObject)x, (String)"finentryid")).collect(Collectors.toList());
            Object[] entryData = this.queryFinEntry(lstEntryId);
            if (ObjectUtils.isEmpty((Object[])entryData)) {
                return;
            }
            if (entryData.length <= 0) {
                return;
            }
            this.updateCreditAccount(lstEntryId);
            this.saveFinEntry(docEntry, (DynamicObject[])entryData);
        }
    }

    private void updateCreditAccount(List<Object> lstEntryId) {
        QFilter filter = new QFilter("finentity.id", "in", (Object)lstEntryId.toArray());
        filter.and("finentity.receivabledate", "<", (Object)TimeServiceHelper.today());
        filter.and("finentity.iscreditcheck", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection overEntity = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"finentity.id as id,finentity.creditaccountid as creditaccountid,finentity.receivabledate as receivabledate,finentity.notsettleamount as notsettleamount", (QFilter[])filter.toArray());
        for (DynamicObject entry : overEntity) {
            long accountId = entry.getLong("creditaccountid");
            long id = entry.getLong("id");
            BigDecimal amount = entry.getBigDecimal("notsettleamount");
            Date receivableDate = entry.getDate("receivabledate");
            DynamicObject accountInfo = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"ocdbd_credit_accountinfo", (String)"overdueamount,overduetimes,overduedays");
            accountInfo.set("overdueamount", (Object)accountInfo.getBigDecimal("overdueamount").subtract(amount));
            accountInfo.set("overduetimes", (Object)(accountInfo.getInt("overduetimes") - 1));
            this.updateDueDays(receivableDate, accountId, id, accountInfo);
            SaveServiceHelper.update((DynamicObject)accountInfo);
        }
    }

    private DynamicObject[] queryFinEntry(List<Object> lstEntryId) {
        QFilter filter = new QFilter("finentity.id", "in", (Object)lstEntryId.toArray());
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder.finentity");
        List lstFields = type.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        StringBuilder selectFields = new StringBuilder();
        for (String fieldName : lstFields) {
            if (fieldName.contains("_id")) continue;
            selectFields.append(',').append("finentity").append('.').append(fieldName);
        }
        return BusinessDataServiceHelper.load((String)"ocpos_saleorder", (String)selectFields.toString(), (QFilter[])filter.toArray());
    }

    private void saveFinEntry(DynamicObjectCollection docEntry, DynamicObject[] entryData) {
        ArrayList<DynamicObject> lstFinEntry = new ArrayList<DynamicObject>(0);
        for (DynamicObject data : entryData) {
            DynamicObjectCollection docFinEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)data, (String)"finentity");
            for (DynamicObject doFinEntry : docFinEntry) {
                long entryId = DynamicObjectUtils.getPkValue((DynamicObject)doFinEntry);
                DynamicObject dataItem = docEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"finentryid") == entryId).findFirst().orElse(null);
                if (ObjectUtils.isEmpty((Object)dataItem)) continue;
                Date newReceivableDate = DynamicObjectUtils.getDate((DynamicObject)dataItem, (String)"newreceivabledate");
                doFinEntry.set("receivabledate", (Object)newReceivableDate);
                doFinEntry.set("iscreditcheck", (Object)Boolean.FALSE);
                lstFinEntry.add(doFinEntry);
            }
        }
        if (!CollectionUtils.isEmpty(lstFinEntry)) {
            SaveServiceHelper.update((DynamicObject[])lstFinEntry.toArray(new DynamicObject[0]));
        }
    }

    private void updateDueDays(Date receivableDate, long creditAccountId, long finEntryId, DynamicObject accountInfo) {
        String selectFields = "finentity.creditaccountid,finentity.receivabledate";
        QFilter filter = new QFilter("finentity.creditaccountid", "=", (Object)creditAccountId);
        filter.and("finentity.id", "<>", (Object)finEntryId);
        filter.and("finentity.notsettleamount", ">", (Object)BigDecimal.ZERO);
        filter.and("finentity.receivabledate", "<", (Object)TimeServiceHelper.today());
        filter.and("finentity.iscreditcheck", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            accountInfo.set("overduedays", (Object)0);
            return;
        }
        ArrayList<DynamicObject> lstFinEntry = new ArrayList<DynamicObject>((Collection<DynamicObject>)data);
        lstFinEntry.sort(Comparator.comparing(finEntry -> finEntry.getDate("finentity.receivabledate")));
        DynamicObject doFinEntry = (DynamicObject)lstFinEntry.get(0);
        Date dtNow = TimeServiceHelper.now();
        Date minReceivableDate = DynamicObjectUtils.getDate((DynamicObject)doFinEntry, (String)"finentity.receivabledate");
        int dueDays = this.getDayDiffer(minReceivableDate, dtNow);
        accountInfo.set("overduedays", (Object)dueDays);
    }

    private DynamicObject queryCreditAccountInfo(long creditAccountId) {
        return BusinessDataServiceHelper.loadSingle((Object)creditAccountId, (String)"ocdbd_credit_accountinfo");
    }

    public int getDayDiffer(Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long startDateTime = 0L;
        long endDateTime = 0L;
        try {
            startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        if (startDateTime == 0L || endDateTime == 0L) {
            return 0;
        }
        return (int)((endDateTime - startDateTime) / 86400000L);
    }
}

