/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.inventory;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocpos.opplugin.saleorder.inventory.StoreCheckValidator;

public class StoreCheckOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("gainqty");
        e.getFieldKeys().add("lossqty");
        e.getFieldKeys().add("pushtype");
        e.getFieldKeys().add("lot");
        e.getFieldKeys().add("serialnumber");
        e.getFieldKeys().add("material");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StoreCheckValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
            List gain = billEntry.stream().filter(a -> a.getBigDecimal("gainqty").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            List loose = billEntry.stream().filter(a -> a.getBigDecimal("lossqty").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            boolean isloose = CollectionUtils.isEmpty(loose);
            boolean isgain = CollectionUtils.isEmpty(gain);
            if (isloose && isgain) {
                dataEntity.set("pushtype", (Object)"D");
                continue;
            }
            if (isloose) {
                dataEntity.set("pushtype", (Object)"A");
                continue;
            }
            if (isgain) {
                dataEntity.set("pushtype", (Object)"B");
                continue;
            }
            dataEntity.set("pushtype", (Object)"C");
        }
    }
}

