/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.inventory;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.push.AutoPushHelper;

public class StorePurRefundApplyAudit
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("billentry");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            Object pkId = dataEntity.getPkValue();
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
            if (billTypeId != 1169520497860536320L) continue;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperationResult opResult = AutoPushHelper.autoPushBill((Object)pkId, (String)"ocpos_store_purrefapply", (String)"im_purinbill", (String)"audit");
                    if (opResult == null) {
                        tx.markRollback();
                        throw new KDBizException("\u5ba1\u6838\u5931\u8d25\uff0c\u91c7\u8d2d\u5165\u5355\u4e0b\u63a8\u5931\u8d25");
                    }
                    StringBuilder pushMsgBuilder = new StringBuilder();
                    if (opResult == null || opResult.isSuccess() || opResult.getAllErrorOrValidateInfo().size() <= 0) continue;
                    opResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getMessage()).append(','));
                    tx.markRollback();
                    throw new KDBizException(pushMsgBuilder.toString());
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
    }
}

