/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.inventory.storedelivery;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.push.AutoPushHelper;

public class StoreDeliveryAudit
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("entryentity");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            Object pkId = dataEntity.getPkValue();
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
            String targetEntityId = this.getTargetEntityId(billTypeId);
            String targetEntityName = this.getTargetEntityName(billTypeId);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    List allErrorOrValidateInfo;
                    OperationResult result = AutoPushHelper.autoPushBill((Object)pkId, (String)"ocpos_store_delivery", (String)targetEntityId, (String)"audit");
                    if (result == null) {
                        tx.markRollback();
                        throw new KDBizException(String.format("\u5ba1\u6838\u5931\u8d25\uff0c%s\u4e0b\u63a8\u5931\u8d25", targetEntityName));
                    }
                    StringBuilder pushMsgBuilder = new StringBuilder();
                    if (result.isSuccess() || CollectionUtils.isEmpty((Collection)(allErrorOrValidateInfo = result.getAllErrorOrValidateInfo()))) continue;
                    allErrorOrValidateInfo.forEach(info -> pushMsgBuilder.append(info.getMessage()).append(','));
                    tx.markRollback();
                    throw new KDBizException(pushMsgBuilder.toString());
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
    }

    private String getTargetEntityId(long billTypeId) {
        String targetEntityId = "";
        if (billTypeId == 1173164380335041536L) {
            targetEntityId = "im_otheroutbill";
        } else if (billTypeId == 1173164848679414784L) {
            targetEntityId = "im_transoutbill";
        }
        return targetEntityId;
    }

    private String getTargetEntityName(long billTypeId) {
        String targetEntityName = "";
        if (billTypeId == 1173164380335041536L) {
            targetEntityName = "\u5176\u4ed6\u51fa\u5e93\u5355";
        } else if (billTypeId == 1173164848679414784L) {
            targetEntityName = "\u5206\u6b65\u8c03\u51fa\u5355";
        }
        return targetEntityName;
    }
}

