/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.inventory.storedelivery;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class StoreDeliverySaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) continue;
            for (DynamicObject entryEntity : entryEntities) {
                int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
                DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"material");
                this.checkLotCtrl(extendedDataEntity, entryEntity, material, seq);
                this.checkShelfCtrl(extendedDataEntity, entryEntity, material, seq);
            }
        }
    }

    private void checkLotCtrl(ExtendedDataEntity extendedDataEntity, DynamicObject entryEntity, DynamicObject material, int seq) {
        String lotNumber;
        boolean enableLot = DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"enablelot");
        if (enableLot && StringUtils.isBlank((CharSequence)(lotNumber = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"lotnumber")))) {
            String content = String.format("\u7b2c%d\u884c\u5546\u54c1\u5bf9\u5e94\u7269\u6599\u542f\u7528\u4e86\u6279\u53f7\u63a7\u5236\uff0c\u8bf7\u586b\u5199\u6279\u53f7\u3002", seq);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private void checkShelfCtrl(ExtendedDataEntity extendedDataEntity, DynamicObject entryEntity, DynamicObject material, int seq) {
        boolean enableShelfLifeMgr = DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"enableshelflifemgr");
        if (enableShelfLifeMgr) {
            Date expiryDate;
            String content;
            Date produceDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"producedate");
            if (produceDate == null) {
                content = String.format("\u7b2c%d\u884c\u5546\u54c1\u5bf9\u5e94\u7269\u6599\u542f\u7528\u4e86\u4fdd\u8d28\u671f\u63a7\u5236\uff0c\u8bf7\u586b\u5199\u751f\u4ea7\u65e5\u671f\u3002", seq);
                this.addErrorMessage(extendedDataEntity, content);
            }
            if ((expiryDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"expirydate")) == null) {
                content = String.format("\u7b2c%d\u884c\u5546\u54c1\u5bf9\u5e94\u7269\u6599\u542f\u7528\u4e86\u4fdd\u8d28\u671f\u63a7\u5236\uff0c\u8bf7\u586b\u5199\u5230\u671f\u65e5\u671f\u3002", seq);
                this.addErrorMessage(extendedDataEntity, content);
            }
        }
    }
}

