/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.itemsedit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaveDataValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            this.checkDeliveryMustInput(extendedDataEntity, dataEntity);
            this.checkInstallMustInput(extendedDataEntity, dataEntity);
            this.checkSelfPickupMustInput(extendedDataEntity, dataEntity);
            this.checkBookMustInput(extendedDataEntity, dataEntity);
            this.checkInventoryMustInput(extendedDataEntity, dataEntity);
            this.checkSerialNumberMustInput(extendedDataEntity, dataEntity);
            this.checkDate(extendedDataEntity, dataEntity);
            this.checkGiftValue(extendedDataEntity, dataEntity);
        }
    }

    private void checkDeliveryMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isDelivery;
        ArrayList<String> tips = new ArrayList<String>();
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        if (distributionModeId <= 0L) {
            tips.add(this.getTip("\u914d\u9001\u6a21\u5f0f"));
        }
        if (isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery")) {
            String address;
            String adminDivisionId;
            String customerPhone;
            String customerName;
            Date deliveryDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"deliverytime");
            if (deliveryDate == null) {
                tips.add(this.getTip("\u914d\u9001\u65e5\u671f"));
            }
            if (StringUtils.isBlank((CharSequence)(customerName = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customername")))) {
                tips.add(this.getTip("\u6536\u8d27\u4eba"));
            }
            if (StringUtils.isBlank((CharSequence)(customerPhone = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customerphone")))) {
                tips.add(this.getTip("\u624b\u673a\u53f7"));
            }
            if (StringUtils.isBlank((CharSequence)(adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid"))) || Long.parseLong(adminDivisionId) == 0L) {
                tips.add(this.getTip("\u884c\u653f\u533a\u5212"));
            }
            if (StringUtils.isBlank((CharSequence)(address = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customeraddress")))) {
                tips.add(this.getTip("\u8be6\u7ec6\u6536\u8d27\u5730\u5740"));
            }
            if (!CollectionUtils.isEmpty(tips)) {
                for (String tip : tips) {
                    this.addErrorMessage(extendedDataEntity, tip);
                }
            }
        }
    }

    private void checkInstallMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        Date installDate;
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinstall");
        if (isInstall && (installDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"installtime")) == null) {
            String tip = this.getTip("\u5b89\u88c5\u65e5\u671f");
            this.addErrorMessage(extendedDataEntity, tip);
        }
    }

    private void checkSelfPickupMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isSelfPickUp = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
        if (isSelfPickUp) {
            DynamicObject inventoryOrg;
            ArrayList<String> tips = new ArrayList<String>();
            Date selfPickupTime = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"selfpickuptime");
            if (selfPickupTime == null) {
                tips.add(this.getTip("\u81ea\u63d0\u65f6\u95f4"));
            }
            if ((inventoryOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid")) == null) {
                tips.add(this.getTip("\u5e93\u5b58\u7ec4\u7ec7"));
            }
            if (!CollectionUtils.isEmpty(tips)) {
                for (String tip : tips) {
                    this.addErrorMessage(extendedDataEntity, tip);
                }
            }
        }
    }

    private void checkBookMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
        if (isBook) {
            String bookType;
            Date expectTakeOrderDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"expecttakeorderdate");
            if (expectTakeOrderDate == null) {
                String tip = this.getTip("\u9884\u8ba2\u53d6\u8ba2\u65e5\u671f");
                this.addErrorMessage(extendedDataEntity, tip);
            }
            if (StringUtils.isBlank((CharSequence)(bookType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"booktype")))) {
                String tip = this.getTip("\u9884\u8ba2\u7c7b\u578b");
                this.addErrorMessage(extendedDataEntity, tip);
            }
        }
    }

    private void checkInventoryMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObject stock;
        DynamicObject inventoryOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
        if (inventoryOrg != null && (stock = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"erpstockid")) == null) {
            String tip = this.getTip("\u4ed3\u5e93");
            this.addErrorMessage(extendedDataEntity, tip);
        }
    }

    private void checkSerialNumberMustInput(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"materialinv");
        boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
        if (isEnableSerial) {
            boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
            boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
            DynamicObject snMainFile = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"snmainfile");
            String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                return;
            }
            if (!(isDelivery || isSelfPickup || isBook || snMainFile != null)) {
                String tip = this.getTip("\u5e8f\u5217\u53f7");
                this.addErrorMessage(extendedDataEntity, tip);
            }
        }
    }

    private void checkDate(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinstall");
        if (isDelivery && isInstall) {
            Date deliveryDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"deliverytime");
            Date installDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"installtime");
            if (installDate != null && deliveryDate != null) {
                boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
                if (!isChangeReturnOrReturn && installDate.compareTo(deliveryDate) < 0) {
                    this.addErrorMessage(extendedDataEntity, "\u5b89\u88c5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u914d\u9001\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002");
                }
                if (isChangeReturnOrReturn && installDate.compareTo(deliveryDate) > 0) {
                    this.addErrorMessage(extendedDataEntity, "\u5b89\u88c5\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u914d\u9001\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002");
                }
            }
        }
    }

    private void checkGiftValue(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long branchId;
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
        if (!isPresent) {
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        boolean isAllowGiftExcess = SystemParamUtil.isAllowGiftExcess((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")));
        if (isAllowGiftExcess) {
            return;
        }
        boolean isCheckPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ischeckpresent");
        if (!isCheckPresent) {
            return;
        }
        BigDecimal sumAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"sumamount");
        BigDecimal giftValue = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"giftvalue");
        if (giftValue.compareTo(sumAmount) > 0) {
            this.addErrorMessage(extendedDataEntity, "\u8d60\u54c1\u91d1\u989d\u8d85\u8fc7\u8ba2\u91d1\uff0c\u4e0d\u5141\u8bb8\u8d60\u9001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u91cd\u65b0\u7ef4\u62a4\u8ba2\u91d1\u3002");
        }
    }

    private String getTip(String suffix) {
        return String.format("\u8bf7\u586b\u5199\u201c%s\u201d\u3002", suffix);
    }
}

