/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.opplugin.saleorder.olspersonalized;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class SaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String tip;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            boolean isdefault = dataEntity.getBoolean("isdefault");
            QFilter qFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            qFilter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ocpos_olspersonalized", (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObjectCollection.isEmpty() && !isdefault) {
                tip = "\u6682\u65e0\u9ed8\u8ba4\u914d\u7f6e\u5355\u636e\uff0c\u9700\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u5355\u5c40\u3002";
                this.addErrorMessage(extendedDataEntity, tip);
            } else if (!dynamicObjectCollection.isEmpty() && isdefault) {
                tip = String.format("\u5355\u636e%s:\u5df2\u5b58\u5728\u9ed8\u8ba4\u914d\u7f6e\u5355\u636e\uff0c\u53ea\u5141\u8bb8\u914d\u7f6e\u4e00\u5f20\u3002", dataEntity.getString("billno"));
                this.addErrorMessage(extendedDataEntity, tip);
            }
            this.checkFirstEntryEntity(extendedDataEntity, dataEntity);
            this.checkSecondEntryEntity(extendedDataEntity, dataEntity);
            this.checkRepeat(extendedDataEntity, dataEntity);
        }
    }

    private void checkRepeat(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection branchId = dataEntity.getDynamicObjectCollection("branchid");
        Object[] branchIdPkValue = branchId.stream().map(s -> s.getDynamicObject("fbasedataid").getPkValue()).toArray();
        DynamicObject classStanderEdId = dataEntity.getDynamicObject("classstanderedid");
        if (classStanderEdId == null) {
            return;
        }
        String billNo = dataEntity.getString("billno");
        QFilter qFilter = new QFilter("billno", "!=", (Object)billNo);
        qFilter.and("branchid.fbasedataid", "in", (Object)branchIdPkValue);
        qFilter.and("classstanderedid", "=", classStanderEdId.getPkValue());
        DynamicObjectCollection olsPersonalized = QueryServiceHelper.query((String)"ocpos_olspersonalized", (String)"billno", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)olsPersonalized)) {
            String existBillNo = ((DynamicObject)olsPersonalized.get(0)).getString("billno");
            String tip = String.format("\u6240\u9009\u9002\u7528\u95e8\u5e97+\u5546\u54c1\u5206\u7c7b\u6807\u51c6\u4e0e\u5355\u636e%s\u5b58\u5728\u91cd\u590d\u914d\u7f6e\u3002", existBillNo);
            this.addErrorMessage(extendedDataEntity, tip);
        }
    }

    private void checkSecondEntryEntity(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection secondEntryEntity = dataEntity.getDynamicObjectCollection("secondentryentity");
        for (DynamicObject secondEntryEntityRow : secondEntryEntity) {
            String uid = secondEntryEntityRow.getString("parententryuid");
            DynamicObjectCollection firstEntryEntity = dataEntity.getDynamicObjectCollection("firstentryentity");
            String firstItemClassName = "";
            for (DynamicObject firstEntryEntityRow : firstEntryEntity) {
                if (!StringUtils.equals((CharSequence)firstEntryEntityRow.getString("uid"), (CharSequence)uid)) continue;
                DynamicObject firstItemClass = firstEntryEntityRow.getDynamicObject("firstitemclassid");
                if (firstItemClass == null) break;
                firstItemClassName = firstItemClass.getString("name");
                break;
            }
            boolean isSecondItemClass = secondEntryEntityRow.get("seconditemclassid") != null;
            boolean isItemLabel = secondEntryEntityRow.getBoolean("isitemlable");
            boolean isItemBrand = secondEntryEntityRow.getBoolean("isitembrand");
            int seq = secondEntryEntityRow.getInt("seq");
            if (!(isSecondItemClass || isItemLabel || isItemBrand)) {
                String tip = String.format("\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b'%s'\u4e0b:\u53f3\u4fa7\u6807\u9898\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5206\u7c7b\u3001\u54c1\u724c\u3001\u6807\u7b7e\u4e0d\u80fd\u5747\u4e3a\u7a7a\u3002", firstItemClassName, seq);
                this.addErrorMessage(extendedDataEntity, tip);
            }
            this.checkThirdEntryEntity(extendedDataEntity, secondEntryEntityRow, firstItemClassName, isItemLabel, isItemBrand, uid);
        }
    }

    private void checkThirdEntryEntity(ExtendedDataEntity extendedDataEntity, DynamicObject secondEntryEntityRow, String firstItemClassName, boolean isItemLabel, boolean isItemBrand, String uid) {
        boolean notCanEmpty;
        int secondSeq = 0;
        DynamicObjectCollection secondEntryEntity = extendedDataEntity.getDataEntity().getDynamicObjectCollection("secondentryentity");
        for (DynamicObject dyo : secondEntryEntity) {
            if (StringUtils.equals((CharSequence)uid, (CharSequence)secondEntryEntityRow.getString("parententryuid"))) {
                ++secondSeq;
            }
            if (dyo.getInt("seq") != secondEntryEntityRow.getInt("seq")) continue;
            break;
        }
        DynamicObjectCollection thirdEntryEntity = secondEntryEntityRow.getDynamicObjectCollection("thirdentryentity");
        boolean bl = notCanEmpty = (isItemLabel || isItemBrand) && CollectionUtils.isEmpty((Collection)thirdEntryEntity);
        if (notCanEmpty) {
            String tip = String.format("\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b'%s'\u4e0b:\u53f3\u4fa7\u6807\u9898\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5bf9\u5e94\u53f3\u4fa7\u56fe\u7247\u914d\u7f6e\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", firstItemClassName, secondSeq);
            this.addErrorMessage(extendedDataEntity, tip);
        }
        int seq = 1;
        for (DynamicObject thirdEntryEntityRow : thirdEntryEntity) {
            String tip;
            if (isItemLabel && thirdEntryEntityRow.get("itemlableid") == null) {
                tip = String.format("\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b'%s'\u4e0b:\u53f3\u4fa7\u6807\u9898\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5bf9\u5e94\u53f3\u4fa7\u56fe\u7247\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5546\u54c1\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\u3002", firstItemClassName, secondSeq, seq);
                this.addErrorMessage(extendedDataEntity, tip);
            }
            if (isItemBrand && thirdEntryEntityRow.get("itembrandid") == null) {
                tip = String.format("\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b'%s'\u4e0b:\u53f3\u4fa7\u6807\u9898\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5bf9\u5e94\u53f3\u4fa7\u56fe\u7247\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5546\u54c1\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\u3002", firstItemClassName, secondSeq, seq);
                this.addErrorMessage(extendedDataEntity, tip);
            }
            if (ObjectUtils.isEmpty((Object)thirdEntryEntityRow.get("picture"))) {
                tip = String.format("\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b'%s'\u4e0b:\u53f3\u4fa7\u6807\u9898\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u5bf9\u5e94\u53f3\u4fa7\u56fe\u7247\u914d\u7f6e\u5355\u636e\u4f53\u7b2c%s\u884c:\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\u3002", firstItemClassName, secondSeq, seq);
                this.addErrorMessage(extendedDataEntity, tip);
            }
            ++seq;
        }
    }

    private void checkFirstEntryEntity(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection firstEntryEntity = dataEntity.getDynamicObjectCollection("firstentryentity");
        for (DynamicObject firstEntryEntityRow : firstEntryEntity) {
            int seq = firstEntryEntityRow.getInt("seq");
            if (firstEntryEntityRow.get("firstitemclassid") != null) continue;
            String tip = String.format("\u5546\u57ce\u5de6\u4fa7\u4e00\u7ea7\u5206\u7c7b\u5355\u636e\u4f53\u7b2c%s\u884c:\u4e00\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq);
            this.addErrorMessage(extendedDataEntity, tip);
        }
    }
}

