/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.cleanservehelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;

public class CleanServerHelper {
    private static final Log LOGGER = LogFactory.getLog(CleanServerHelper.class);

    public static List<Long> queryCleanServeList(Map<String, Object> dataMap) {
        Object pageIndexObj = dataMap.get("pageIndex");
        Object pageSizeObj = dataMap.get("pageSize");
        if (pageIndexObj == null || pageSizeObj == null) {
            throw new KDBizException("\u5206\u9875\u53c2\u6570\u9519\u8bef\uff01");
        }
        int pageIndex = Integer.parseInt(String.valueOf(pageIndexObj));
        int pageSize = Integer.parseInt(String.valueOf(pageSizeObj));
        QFilter qFilter = CleanServerHelper.buildCleanServeListQfilter(dataMap);
        DynamicObject[] cleanServices = pageSize > 0 ? BusinessDataServiceHelper.load((String)"ocpos_cleaning", (String)"id", (QFilter[])qFilter.toArray(), (String)"id desc", (int)pageIndex, (int)pageSize) : BusinessDataServiceHelper.load((String)"ocpos_cleaning", (String)"id", (QFilter[])qFilter.toArray(), (String)"id desc");
        ArrayList<Long> result = new ArrayList<Long>(cleanServices.length);
        for (DynamicObject cleanService : cleanServices) {
            result.add(cleanService.getLong("id"));
        }
        return result;
    }

    public static long queryServeEvaluateStatus(long cleanServeId) {
        DynamicObject cleanServe = BusinessDataServiceHelper.loadSingle((Object)cleanServeId, (String)"ocpos_cleaning");
        String servicetype = cleanServe.getString("servicetype");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("servicetype", "=", (Object)servicetype);
        if (QueryServiceHelper.exists((String)"ocpos_evaluate", (QFilter[])qFilter.toArray())) {
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"ocpos_evaluate", (String)"id", (QFilter[])qFilter.toArray());
            return dyo.getLong("id");
        }
        return 0L;
    }

    public static Boolean addServeEvaluate(long cleanServeId, List<Integer> averageScores) {
        DynamicObject cleanServe = BusinessDataServiceHelper.loadSingle((Object)cleanServeId, (String)"ocpos_cleaning");
        if ("E".equals(cleanServe.get("billstatus"))) {
            LOGGER.info("\u8be5\u5355\u636e\u5df2\u88ab\u8bc4\u4ef7\uff0c\u53cd\u5199\u5931\u8d25\u3002");
            return Boolean.FALSE;
        }
        long evaluateId = CleanServerHelper.queryServeEvaluateStatus(cleanServeId);
        if (evaluateId != 0L) {
            DynamicObject serveEvaluate = BusinessDataServiceHelper.loadSingle((Object)evaluateId, (String)"ocpos_evaluate");
            DynamicObjectCollection entryentity = serveEvaluate.getDynamicObjectCollection("entryentity");
            BigDecimal sumAverageScore = BigDecimal.ZERO;
            if (averageScores.size() != entryentity.size()) {
                LOGGER.info("\u53c2\u6570\u4e2a\u6570\u5f02\u5e38\uff0c\u53cd\u5199\u5931\u8d25\u3002");
                return Boolean.FALSE;
            }
            int index = 0;
            for (DynamicObject dyo : entryentity) {
                BigDecimal averageScore = ((DynamicObject)dyo.getDynamicObjectCollection("subentryentity").get(averageScores.get(index) - 1)).getBigDecimal("customscore");
                sumAverageScore = sumAverageScore.add(averageScore);
                ++index;
            }
            cleanServe.set("averagescore", (Object)sumAverageScore.divide(new BigDecimal(entryentity.size()), 2, 4));
            cleanServe.set("billstatus", (Object)"E");
            cleanServe.set("evaluatedate", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)cleanServe);
            return Boolean.TRUE;
        }
        LOGGER.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u8bc4\u4ef7\u8bbe\u7f6e\u5355\uff0c\u53cd\u5199\u5931\u8d25\u3002");
        return Boolean.FALSE;
    }

    private static QFilter buildCleanServeListQfilter(Map<String, Object> dataMap) {
        Object user = dataMap.get("user");
        Object servicetype = dataMap.get("servicetype");
        String billstatus = dataMap.get("billstatus").toString();
        QFilter qFilter = new QFilter("user", "=", user);
        qFilter.and("servicetype", "=", servicetype);
        switch (billstatus) {
            case "A": {
                break;
            }
            case "B": {
                QFilter filter = new QFilter("billstatus", "=", (Object)"A");
                filter.or("billstatus", "=", (Object)"B");
                qFilter.and(filter);
                break;
            }
            case "C": {
                QFilter filter = new QFilter("billstatus", "=", (Object)"D");
                qFilter.and(filter);
                break;
            }
            default: {
                return F7Utils.getEveFalseFilter();
            }
        }
        return qFilter;
    }
}

