/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocbase.common.enums.DiscountTypeEnum;
import kd.occ.ocpos.common.util.SystemParamUtil;
import kd.occ.ocpos.common.vo.AmountInfo;

public class AmountHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal HUNDRED = new BigDecimal(100);

    public static BigDecimal getAmountAfterWipeZeroMode(long orgId, long branchId, BigDecimal amount) {
        String wipeZeroMode = SystemParamUtil.getWipeZeroMode((long)orgId, (long)branchId);
        BigDecimal ten = new BigDecimal("10");
        BigDecimal hundred = new BigDecimal("100");
        switch (wipeZeroMode) {
            case "A": {
                break;
            }
            case "B": {
                amount = amount.setScale(1, 1);
                break;
            }
            case "C": {
                amount = amount.setScale(0, 1);
                break;
            }
            case "D": {
                amount = amount.divide(ten, 0, 1).multiply(ten);
                break;
            }
            case "E": {
                amount = amount.divide(hundred, 0, 1).multiply(hundred);
                break;
            }
            case "F": {
                amount = amount.setScale(1, 4);
                break;
            }
            case "G": {
                amount = amount.setScale(0, 4);
                break;
            }
            case "H": {
                amount = amount.divide(ten, 0, 4).multiply(ten);
                break;
            }
            case "I": {
                amount = amount.divide(hundred, 0, 4).multiply(hundred);
                break;
            }
        }
        return amount;
    }

    public static BigDecimal getNeedPayAmount(DynamicObject saleOrder, long payWayId) {
        BigDecimal wipeAmount = BigDecimal.ZERO;
        BigDecimal hasPayAmount = BigDecimal.ZERO;
        BigDecimal needPayAmount = saleOrder.getBigDecimal("receivableamount").subtract(saleOrder.getBigDecimal("totalrealamount"));
        String bizType = saleOrder.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            needPayAmount = needPayAmount.subtract(wipeAmount);
        }
        return needPayAmount.subtract(hasPayAmount);
    }

    public static AmountInfo getAmount(AmountInfo amountInfo) {
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = amountInfo.getTaxRate().divide(HUNDRED);
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = amountInfo.getSettlePricePrecision();
        int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
                if (discountRate != null && !StringUtils.isBlank((CharSequence)discountType) && !discountType.equals(DiscountTypeEnum.NULL.getValue()) && discountRate.compareTo(ZERO) != 0) {
                    if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                        discountRate = discountRate.divide(HUNDRED);
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, 4);
                        amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, 4);
                    } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, 4);
                        amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, 4);
                    }
                } else {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
                if (discountRate != null && !StringUtils.isBlank((CharSequence)discountType) && !discountType.equals(DiscountTypeEnum.NULL.getValue()) && discountRate.compareTo(ZERO) != 0) {
                    if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                        discountRate = discountRate.divide(HUNDRED);
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, 4);
                        amount = qty.multiply(price).multiply(ONE.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                    } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settleAmtPrecision, 4);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                    }
                } else {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, 4);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, 4);
            } else {
                priceAndTax = ZERO;
                price = ZERO;
            }
            if (exChangeRate.compareTo(ZERO) != 0) {
                BigDecimal curAmount = ZERO;
                BigDecimal curTaxAmount = ZERO;
                BigDecimal curAmountAndTax = ZERO;
                if (isTax) {
                    curTaxAmount = taxAmount.multiply(exChangeRate).setScale(currencyAmtPrecision, 4);
                    curAmountAndTax = amountAndTax.multiply(exChangeRate).setScale(currencyAmtPrecision, 4);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = amount.multiply(exChangeRate).setScale(currencyAmtPrecision, 4);
                    curTaxAmount = taxAmount.multiply(exChangeRate).setScale(currencyAmtPrecision, 4);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
                amountInfo.setCurAmount(curAmount);
                amountInfo.setCurTaxAmount(curTaxAmount);
                amountInfo.setCurAmountAndTax(curAmountAndTax);
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            priceAndTax = priceAndTax.setScale(settlePricePrecision, 4);
            price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
        } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
            price = price.setScale(settlePricePrecision, 4);
            priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
        } else {
            priceAndTax = ZERO;
            price = ZERO;
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        return amountInfo;
    }
}

