/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class CurrencyHelper {
    private static String CURRENCY_DT = "bd_currency";
    private static String EXRATETABLE_DT = "bd_exratetable";
    private static String BASECURRRENCY = "baseCurrencyID";
    private static String EXRATETABLE = "exchangeRateTableID";
    private static String KEY_PKID = "id";
    private static final Log LOGGER = LogFactory.getLog(CurrencyHelper.class);

    @Deprecated
    public static DynamicObject getCurrency() {
        return BusinessDataServiceHelper.loadSingle((Object)1, (String)CURRENCY_DT);
    }

    public static DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map;
        if (orgId != 0L && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(BASECURRRENCY), (String)CURRENCY_DT);
        }
        return null;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        if (orgId > 0L) {
            Map<String, Object> mapOrg = CurrencyHelper.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE);
            if (mapOrg != null && mapOrg.get(KEY_PKID) != null) {
                LOGGER.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
                Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get(KEY_PKID)));
                if (map != null && map.size() != 0) {
                    LOGGER.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                    return map;
                }
                LOGGER.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\u4e3anull");
            } else {
                LOGGER.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\u4e3anull");
            }
        } else {
            LOGGER.info("\u83b7\u53d6\u672c\u4f4d\u5e01\u4ee5\u53ca\u6c47\u7387\u4f20\u5165\u7684\u7ec4\u7ec7\u503c\u6709\u8bef:" + orgId);
        }
        return null;
    }

    public static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpWard) {
        HashMap<String, Object> mpCompany = new HashMap<String, Object>(3);
        if (orgId != null && orgId != 0L) {
            String selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,isbizunit";
            QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
            QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            QFilter isBizUnitFilter = null;
            if (isBizUnit.booleanValue()) {
                isBizUnitFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter[] filters = null;
            filters = isBizUnit != false ? new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter, isBizUnitFilter} : new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter};
            DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
            if (orgInfo != null) {
                mpCompany.put("id", orgInfo.get("org"));
                mpCompany.put("number", orgInfo.get("org.number"));
                mpCompany.put("name", orgInfo.get("org.name"));
                return mpCompany;
            }
            if (!isSerrchUpWard.booleanValue()) {
                return mpCompany;
            }
            selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,parent";
            treeTypeFilter = new QFilter("view.treetype", "=", (Object)"15");
            isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            orgFilter = new QFilter("org", "=", (Object)orgId);
            filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter};
            orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
            if (orgInfo != null) {
                Long parentOrgId = null;
                Object parentOrg = orgInfo.get("parent");
                if (parentOrg != null && !parentOrg.equals(0L)) {
                    if (parentOrg instanceof Long) {
                        parentOrgId = (Long)parentOrg;
                    } else if (parentOrg instanceof DynamicObject) {
                        parentOrgId = (Long)((DynamicObject)parentOrg).getPkValue();
                    }
                    return CurrencyHelper.getCompanyByOrg(parentOrgId, isBizUnit, isSerrchUpWard);
                }
                return mpCompany;
            }
            return mpCompany;
        }
        return mpCompany;
    }

    @Deprecated
    public static BigDecimal getExChangeRate(Long srcCurId, Long targCurId, Long exRateTableId) {
        BigDecimal exChangeRate = srcCurId.equals(targCurId) ? BigDecimal.ONE : CurrencyHelper.getExChangeRate(srcCurId, targCurId, exRateTableId, TimeServiceHelper.now());
        return exChangeRate;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exChangeRate = srcCurId.equals(tarCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date);
        return exChangeRate;
    }

    @Deprecated
    public static BigDecimal getCurrencyRate(Object payCurrencyId, Object targetCurrencyId, Object exRateTableId, Date date) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (CommonUtil.formatObejctToLong((Object)payCurrencyId) == CommonUtil.formatObejctToLong((Object)targetCurrencyId)) {
            return BigDecimal.ONE;
        }
        QFilter exfilter1 = new QFilter("orgcur", "=", payCurrencyId);
        QFilter exfilter2 = new QFilter("cur", "=", targetCurrencyId);
        QFilter exfilter3 = new QFilter("exctable", "=", exRateTableId);
        QFilter exfilter4 = new QFilter("effectdate", "<=", (Object)date);
        QFilter[] exFilters = new QFilter[]{exfilter1, exfilter2, exfilter3, exfilter4};
        DynamicObject exchangeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"excval", (QFilter[])exFilters);
        if (exchangeRate != null) {
            exChangeRate = exchangeRate.getBigDecimal("excval");
        } else {
            QFilter filter1 = new QFilter("orgcur", "=", targetCurrencyId);
            QFilter filter2 = new QFilter("cur", "=", payCurrencyId);
            QFilter filter3 = new QFilter("exctable", "=", exRateTableId);
            QFilter filter4 = new QFilter("effectdate", "<=", (Object)date);
            QFilter[] filters = new QFilter[]{filter1, filter2, filter3, filter4};
            DynamicObject changeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"indirectexrate", (QFilter[])filters);
            if (changeRate != null) {
                exChangeRate = changeRate.getBigDecimal("indirectexrate");
            }
        }
        return exChangeRate;
    }

    public static Map<String, Object> initCurrency(DynamicObject branch, long orgId) {
        HashMap<String, Object> currencyMap = new HashMap<String, Object>(4);
        long itemCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"currency");
        currencyMap.put("currencyid", itemCurrencyId);
        Map<String, Long> currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable(orgId);
        if (currencyAndExRateMap != null) {
            Long baseCurrencyId = currencyAndExRateMap.get("baseCurrencyID");
            Long exchangeRateTableId = currencyAndExRateMap.get("exchangeRateTableID");
            currencyMap.put("locurrencyid", baseCurrencyId);
            currencyMap.put("exratetable", exchangeRateTableId);
            DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)branch, (String)"currency");
            BigDecimal rate = CurrencyHelper.getExChangeRate(Long.parseLong(currency.getPkValue().toString()), baseCurrencyId, exchangeRateTableId, new Date());
            currencyMap.put("financeexchangerate", rate);
        } else {
            currencyMap.put("locurrencyid", 0L);
            currencyMap.put("exratetable", 0L);
            currencyMap.put("financeexchangerate", BigDecimal.ZERO);
        }
        return currencyMap;
    }
}

