/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.TimeServiceHelper;
import org.joda.time.DateTime;

public class DateHelper {
    public static String[] getMonthOfYearText() {
        Date todayTime = TimeServiceHelper.today();
        Instant instant = todayTime.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate today = localDateTime.toLocalDate();
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            DateTime day = new DateTime((Object)new Date());
            SimpleDateFormat sdf = new SimpleDateFormat("MMM yyyy", Locale.ENGLISH);
            String thisYear = sdf.format(day.toDate());
            DateTime time2 = day.minusYears(1);
            String lastYear = sdf.format(time2.toDate());
            String[] years = new String[]{lastYear, thisYear};
            return years;
        }
        String monthOfYearText = today.getYear() + ResManager.loadKDString((String)"\u5e74", (String)"DateHelper_0", (String)"occ-ocpos-business", (Object[])new Object[0]) + today.getMonthValue() + ResManager.loadKDString((String)"\u6708", (String)"DateHelper_1", (String)"occ-ocpos-business", (Object[])new Object[0]);
        String monthOfLastYearText = today.minusYears(1L).getYear() + ResManager.loadKDString((String)"\u5e74", (String)"DateHelper_0", (String)"occ-ocpos-business", (Object[])new Object[0]) + today.getMonthValue() + ResManager.loadKDString((String)"\u6708", (String)"DateHelper_1", (String)"occ-ocpos-business", (Object[])new Object[0]);
        return new String[]{monthOfLastYearText, monthOfYearText};
    }

    public static java.sql.Date[] getCurrentMonthRange() {
        Date todayTime = TimeServiceHelper.today();
        Instant instant = todayTime.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate today = localDateTime.toLocalDate();
        LocalDate firstDayOfThisMonth = today.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfThisMonth = today.with(TemporalAdjusters.lastDayOfMonth());
        java.sql.Date firstDateOfThisMonth = java.sql.Date.valueOf(firstDayOfThisMonth);
        java.sql.Date lastDateOfThisMonth = java.sql.Date.valueOf(lastDayOfThisMonth);
        return new java.sql.Date[]{firstDateOfThisMonth, lastDateOfThisMonth};
    }

    public static java.sql.Date[] getCurrentQuarterRange() {
        LocalDate lastDayOfThisQuarter;
        LocalDate firstDayOfThisQuarter;
        ZoneId zone;
        Date todayTime = TimeServiceHelper.today();
        Instant instant = todayTime.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone = ZoneId.systemDefault());
        LocalDate today = localDateTime.toLocalDate();
        int month = today.getMonth().getValue();
        if (month % 3 == 0) {
            firstDayOfThisQuarter = today.plusMonths(-2L).with(TemporalAdjusters.firstDayOfMonth());
            lastDayOfThisQuarter = today.with(TemporalAdjusters.lastDayOfMonth());
        } else if (month % 3 == 1) {
            firstDayOfThisQuarter = today.with(TemporalAdjusters.firstDayOfMonth());
            lastDayOfThisQuarter = today.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
        } else {
            firstDayOfThisQuarter = today.plusMonths(-1L).with(TemporalAdjusters.firstDayOfMonth());
            lastDayOfThisQuarter = today.plusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        }
        java.sql.Date firstDateOfThisQuarter = java.sql.Date.valueOf(firstDayOfThisQuarter);
        java.sql.Date lastDateOfThisQuarter = java.sql.Date.valueOf(lastDayOfThisQuarter);
        return new java.sql.Date[]{firstDateOfThisQuarter, lastDateOfThisQuarter};
    }

    public static java.sql.Date[] getCurrentYearRange() {
        Date todayTime = TimeServiceHelper.today();
        Instant instant = todayTime.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate today = localDateTime.toLocalDate();
        LocalDate firstDayOfThisYear = today.with(TemporalAdjusters.firstDayOfYear());
        LocalDate lastDayOfThisYear = today.with(TemporalAdjusters.lastDayOfYear());
        java.sql.Date firstDateOfThisYear = java.sql.Date.valueOf(firstDayOfThisYear);
        java.sql.Date lastDateOfThisYear = java.sql.Date.valueOf(lastDayOfThisYear);
        return new java.sql.Date[]{firstDateOfThisYear, lastDateOfThisYear};
    }

    public static java.sql.Date[] getCurrentMonthRangeLastYear() {
        Date todayTime = TimeServiceHelper.today();
        Instant instant = todayTime.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate today = localDateTime.toLocalDate();
        LocalDate firstDayOfThisMonth = today.minusYears(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfThisMonth = today.minusYears(1L).with(TemporalAdjusters.lastDayOfMonth());
        java.sql.Date firstDateOfThisMonth = java.sql.Date.valueOf(firstDayOfThisMonth);
        java.sql.Date lastDateOfThisMonth = java.sql.Date.valueOf(lastDayOfThisMonth);
        return new java.sql.Date[]{firstDateOfThisMonth, lastDateOfThisMonth};
    }
}

