/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;

public class OrgHelper {
    public static final String EntityID_Org_structure = "bos_org_structure";
    private static final String VIRTIUAL_ROOT_ID = "9999999999999";

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List<Map<String, String>> hasPermissionOrgs = OrgHelper.getAllPermissionOrgs(entityName, orgViewType);
        if (CommonUtils.isNull(hasPermissionOrgs)) {
            return null;
        }
        Map tempInvStart = null;
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        if ("05".equals(orgViewType)) {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            tempInvStart = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            if (CommonUtils.isNull((Object)tempInvStart)) {
                return null;
            }
            for (DynamicObject invStart : tempInvStart.values()) {
                DynamicObject org = invStart.getDynamicObject("org");
                if (org == null) continue;
                orgIDs.add((Long)org.getPkValue());
            }
        }
        ArrayList<Long> orgs = new ArrayList<Long>(0);
        for (Map<String, String> tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf(tempOrg.get("id"));
            if (tempInvStart != null && orgIDs.size() != 0 && !orgIDs.contains(tempOrgId)) continue;
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static List<Map<String, String>> getAllPermissionOrgs(String formId, String orgViewType) {
        QFilter filterIsdefault;
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, null, (String)formId, (String)"47150e89000000ac");
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)orgViewType);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            filterIsdefault = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreetype = filterTreetype.and(filterIsdefault);
        }
        filterIsdefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreetype, filterIsdefault, freezeFilter};
        return OrgHelper.rebuildPermissionOrgTree(filterOrgs);
    }

    public static List<Map<String, String>> rebuildPermissionOrgTree(QFilter[] filters) {
        Map<String, String> org;
        if (filters == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)EntityID_Org_structure, (String)"id, org.id org, org.number number,org.name name,longnumber,parent", (QFilter[])filters, (String)"level");
        if (CollectionUtils.isEmpty((Collection)orgCol)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
        HashMap<String, Map<String, String>> orgLongToOrg = new HashMap<String, Map<String, String>>();
        ArrayList<String> rootList = new ArrayList<String>();
        HashSet<String> hasChildList = new HashSet<String>();
        for (DynamicObject orgView : orgCol) {
            String longnumber = orgView.getString("longnumber");
            org = new HashMap<String, String>();
            org.put("id", orgView.getString("org"));
            org.put("number", orgView.getString("number"));
            org.put("name", orgView.getString("name"));
            org.put("longnumber", longnumber);
            org.put("parentId", orgView.getString("parent"));
            org.put("isleaf", "1");
            if (100000L == orgView.getLong("org")) {
                rootList.add(longnumber);
            } else {
                String parentLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)"!");
                Map parent = (Map)orgLongToOrg.get(parentLongnumber);
                if (parent == null) {
                    rootList.add(longnumber);
                } else {
                    parent.put("isleaf", "0");
                    hasChildList.add(parentLongnumber);
                }
            }
            treeList.add(org);
            orgLongToOrg.put(longnumber, org);
        }
        if (rootList.size() > 1) {
            HashMap<String, String> orgRoot = new HashMap<String, String>();
            orgRoot.put("id", VIRTIUAL_ROOT_ID);
            orgRoot.put("number", "0");
            orgRoot.put("name", "\u5168\u90e8");
            orgRoot.put("longnumber", "0");
            orgRoot.put("parentId", "0");
            orgRoot.put("isleaf", "0");
            treeList.add(orgRoot);
            for (String longNumber : rootList) {
                org = (Map)orgLongToOrg.get(longNumber);
                if (org == null) continue;
                org.put("parentId", VIRTIUAL_ROOT_ID);
                if (hasChildList.contains(longNumber)) {
                    org.put("isleaf", "0");
                    continue;
                }
                org.put("isleaf", "1");
            }
        }
        return treeList;
    }

    public static Long getDefaultOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType();
        return OrgHelper.getDefaultOrg(entityName, orgViewType);
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType);
        if (orgs == null) {
            return null;
        }
        if (orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }

    public static String getOrgViewType() {
        return "03";
    }

    public static List<Map<String, String>> getHasPermissionAndStartedInvOrg(String entityName, String orgViewType) {
        List<Map<String, String>> hasPermissionOrgs = OrgHelper.getPermissionOrgs(entityName, orgViewType);
        if (null == hasPermissionOrgs || hasPermissionOrgs.isEmpty()) {
            return null;
        }
        List<DynamicObject> startedInvOrg = OrgHelper.getStartedInvOrgs();
        if (null == startedInvOrg || startedInvOrg.isEmpty()) {
            return null;
        }
        return OrgHelper.getPermissionAndStartedInvOrg(hasPermissionOrgs, startedInvOrg);
    }

    private static List<Map<String, String>> getPermissionAndStartedInvOrg(List<Map<String, String>> hasPermissionOrgs, List<DynamicObject> startedInvOrg) {
        ArrayList<Map<String, String>> hasPermissionAndStartedInvOrg = new ArrayList<Map<String, String>>(16);
        for (Map<String, String> org : hasPermissionOrgs) {
            String orgID = org.get("number");
            boolean isStarted = false;
            for (DynamicObject startedInv : startedInvOrg) {
                DynamicObject startedOrg = startedInv.getDynamicObject("org");
                if (null == orgID || CommonUtils.isNull((Object)startedOrg) || !orgID.equals(startedOrg.getString("number"))) continue;
                isStarted = true;
                break;
            }
            if (!isStarted) continue;
            hasPermissionAndStartedInvOrg.add(org);
        }
        if (hasPermissionAndStartedInvOrg.isEmpty()) {
            return null;
        }
        return hasPermissionAndStartedInvOrg;
    }

    public static List<Map<String, String>> getPermissionOrgs(String entityName, String orgViewType) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        String appId = FormMetadataCache.getFormConfig((String)entityName).getAppId();
        return OrgHelper.getPermissionOrgs(entityTypeId, appId, orgViewType);
    }

    public static List<Map<String, String>> getHasPermissionAndStartedInvOrg(List<Map<String, String>> hasPermissionOrgs) {
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return null;
        }
        List<DynamicObject> startedInvOrg = OrgHelper.getStartedInvOrgs();
        if (startedInvOrg == null || startedInvOrg.isEmpty()) {
            return null;
        }
        return OrgHelper.getPermissionAndStartedInvOrg(hasPermissionOrgs, startedInvOrg);
    }

    public static List<Map<String, String>> getPermissionOrgs(String formId, String appId, String orgViewType) {
        QFilter filterIsDefault;
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)formId, (String)"47150e89000000ac");
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)orgViewType);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            filterIsDefault = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreeType = filterTreeType.and(filterIsDefault);
        }
        filterIsDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreeType, filterIsDefault, freezeFilter};
        return OrgHelper.rebuildPermissionOrgTree(filterOrgs);
    }

    public static List<ComboItem> getHasPermissionAndStartedInvOrgFilterColumns(List<Map<String, String>> hasPermissionOrgs) {
        List<Map<String, String>> orgs = OrgHelper.getHasPermissionAndStartedInvOrg(hasPermissionOrgs);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        return OrgHelper.HandleFilterColumns(orgs);
    }

    private static List<ComboItem> HandleFilterColumns(List<Map<String, String>> orgs) {
        long orgId = RequestContext.get().getOrgId();
        int len = orgs.size();
        ArrayList<ComboItem> orgItem = new ArrayList<ComboItem>(orgs.size());
        int myOrgIndex = 0;
        boolean myOrgindex_flag = true;
        Map<String, String> tempOrg = null;
        for (int i = 0; i < len; ++i) {
            tempOrg = orgs.get(i);
            orgItem.add(new ComboItem(new LocaleString(tempOrg.get("name")), tempOrg.get("id")));
            if (!myOrgindex_flag || !Long.valueOf(tempOrg.get("id")).equals(orgId)) continue;
            myOrgIndex = i;
            myOrgindex_flag = false;
        }
        if (myOrgIndex > 0) {
            ComboItem myOrg = (ComboItem)orgItem.set(myOrgIndex, (ComboItem)orgItem.get(0));
            orgItem.set(0, myOrg);
        }
        return orgItem;
    }

    public static List<ComboItem> getHasPermissionAndStartedInvOrgFilterColumns(String entityName, String orgViewType) {
        List<Map<String, String>> orgs = OrgHelper.getHasPermissionAndStartedInvOrg(entityName, orgViewType);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        return OrgHelper.HandleFilterColumns(orgs);
    }

    public static Object[] getHasPermissionAndStartedInvOrgIds(String entityName, String orgViewType) {
        List<Map<String, String>> orgs = OrgHelper.getHasPermissionAndStartedInvOrg(entityName, orgViewType);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : orgs) {
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }

    public static List<DynamicObject> getStartedInvOrgs() {
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAcc = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
        if (null == tempInvAcc || tempInvAcc.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> orgDOs = new ArrayList<DynamicObject>(tempInvAcc.size());
        for (DynamicObject orgObj : tempInvAcc.values()) {
            orgDOs.add(orgObj);
        }
        return orgDOs;
    }

    public static Long[] getStartedInvOrgsIds() {
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAcc = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
        if (tempInvAcc == null || tempInvAcc.isEmpty()) {
            return null;
        }
        ArrayList<Long> orgIDs = new ArrayList<Long>(16);
        for (DynamicObject invAcc : tempInvAcc.values()) {
            DynamicObject org = invAcc.getDynamicObject("org");
            if (org == null) continue;
            orgIDs.add(Long.valueOf(org.getPkValue().toString()));
        }
        return orgIDs.toArray(new Long[0]);
    }

    public static DynamicObject getDefaultInvOrg(String entityName, String orgViewType) {
        List<Map<String, String>> orgs = OrgHelper.getHasPermissionAndStartedInvOrg(entityName, orgViewType);
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        boolean hasCurrentOrgPerm = false;
        for (Map<String, String> tempOrg : orgs) {
            Long tempOrgId = Long.valueOf(tempOrg.get("id"));
            if (!tempOrgId.equals(org.getPkValue())) continue;
            hasCurrentOrgPerm = true;
            break;
        }
        if (!hasCurrentOrgPerm && orgs.get(0) != null && !orgs.get(0).isEmpty()) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgs.get(0).get("id")))});
        }
        return org;
    }

    public static Object[] getHasPermission(String entityName, String orgViewType) {
        List<Map<String, String>> hasPermissionOrgs = OrgHelper.getPermissionOrgs(entityName, orgViewType);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : hasPermissionOrgs) {
            if (tempOrg.get("id").equals(VIRTIUAL_ROOT_ID)) continue;
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }
}

