/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocpos.common.vo.ShiftQueryVO;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ShiftHelper {
    private static final Log logger = LogFactory.getLog(ShiftHelper.class);

    public static void setShiftInfo(ShiftQueryVO shiftQueryVO) {
        if (shiftQueryVO != null) {
            DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_shift");
            DynamicObjectCollection shiftEntry = newDynObj.getDynamicObjectCollection("shiftentry");
            ArrayList<DynamicObject> tempArrays = new ArrayList<DynamicObject>(1);
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)newDynObj.getDataEntityType().getName(), (DynamicObject)newDynObj, null);
            newDynObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)newDynObj));
            newDynObj.set("billstatus", (Object)shiftQueryVO.getBillstatus());
            newDynObj.set("org", (Object)shiftQueryVO.getOrg());
            newDynObj.set("shiftstore", (Object)shiftQueryVO.getShiftStore());
            newDynObj.set("shiftcashier", (Object)shiftQueryVO.getShiftCashier());
            newDynObj.set("bizdate", (Object)shiftQueryVO.getBizdate());
            newDynObj.set("startdate", (Object)shiftQueryVO.getStartdate());
            newDynObj.set("enddate", (Object)shiftQueryVO.getEnddate());
            newDynObj.set("startbillno", (Object)shiftQueryVO.getStartBillno());
            newDynObj.set("endbillno", (Object)shiftQueryVO.getEndBillno());
            newDynObj.set("tradecount", (Object)shiftQueryVO.getTradeCount());
            newDynObj.set("sumamount", (Object)shiftQueryVO.getSumAmount());
            newDynObj.set("collectamount", (Object)shiftQueryVO.getCollectAmount());
            newDynObj.set("refundamount", (Object)shiftQueryVO.getRefundAmount());
            int tradeCount = shiftQueryVO.getTradeCount();
            List payTypeList = shiftQueryVO.getPaytype();
            List currencyList = shiftQueryVO.getCurrency();
            List exchangeRateList = shiftQueryVO.getExchangerate();
            List payAmountList = shiftQueryVO.getPayamount();
            List payCurAmountList = shiftQueryVO.getPaycuramount();
            for (int i = 0; i < tradeCount; ++i) {
                Long payType = (Long)payTypeList.get(i);
                Long currency = (Long)currencyList.get(i);
                BigDecimal exchangeRate = (BigDecimal)exchangeRateList.get(i);
                BigDecimal payAmount = (BigDecimal)payAmountList.get(i);
                BigDecimal payCurAmount = (BigDecimal)payCurAmountList.get(i);
                boolean isExist = false;
                for (DynamicObject shiftInfo : shiftEntry) {
                    if (payType == 0L || payType.compareTo(shiftInfo.getLong("paytype")) != 0 || currency.compareTo(shiftInfo.getLong("currency")) != 0 || exchangeRate.compareTo(shiftInfo.getBigDecimal("exchangerate")) != 0) continue;
                    shiftInfo.set("payamount", (Object)shiftInfo.getBigDecimal("payamount").add(payAmount));
                    shiftInfo.set("paycuramount", (Object)shiftInfo.getBigDecimal("paycuramount").add(payCurAmount));
                    isExist = true;
                }
                if (isExist || payType == 0L) continue;
                DynamicObject temp = shiftEntry.addNew();
                temp.set("paytype", (Object)payType);
                temp.set("currency", (Object)currency);
                temp.set("exchangerate", (Object)exchangeRate);
                temp.set("payamount", (Object)payAmount);
                temp.set("paycuramount", (Object)payCurAmount);
            }
            tempArrays.add(newDynObj);
            try {
                SaveServiceHelper.save((DynamicObject[])tempArrays.toArray(new DynamicObject[tempArrays.size()]));
            }
            catch (RuntimeException e) {
                logger.error("\u4ea4\u73ed\u5931\u8d25:");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
    }
}

