/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.commonhelper.admindivision;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class AdminDivisionProcessor {
    private static final String T_ADMINDIVISION = "bd_admindivision";

    public List<DynamicObject> getParentDivisionList(Object adminDivisionId) {
        ArrayList<DynamicObject> divisionList = new ArrayList<DynamicObject>(4);
        this.addParentDivision(divisionList, adminDivisionId);
        return divisionList;
    }

    private void addParentDivision(List<DynamicObject> divisionList, Object adminDivisionId) {
        DynamicObject adminDivision = this.getAdminDivision(adminDivisionId);
        if (adminDivision != null) {
            divisionList.add(adminDivision);
            DynamicObject parentAdminDivision = adminDivision.getDynamicObject("parent");
            if (parentAdminDivision != null) {
                this.addParentDivision(divisionList, parentAdminDivision.getPkValue());
            }
        }
    }

    public DynamicObject getAdminDivision(Object adminDivisionId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", adminDivisionId);
        return orm.queryOne(T_ADMINDIVISION, filter.toArray());
    }

    public Object getParentDivisions(Object adminDivisionId) {
        List<DynamicObject> divisionList = this.getParentDivisionList(adminDivisionId);
        if (!CollectionUtils.isEmpty(divisionList)) {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(4);
            for (DynamicObject division : divisionList) {
                JSONObject json = new JSONObject();
                json.put("id", division.getPkValue());
                json.put("name", (Object)division.getString("name"));
                json.put("levelId", (Object)division.getInt("level"));
                jsonList.add(json);
            }
            return JSONObject.toJSON(jsonList);
        }
        return null;
    }
}

