/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.converthelper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.inventory.MatchRuleOutHelper;

public class GiftRecBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final String IGNORE = "ignore";

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity billDataEntity : billDataEntities = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject dataEntity = billDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("billentry");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
            this.giftRecMatchingRuleOut(entryEntity, orgId);
        }
    }

    private void giftRecMatchingRuleOut(DynamicObjectCollection selectEntrys, Long orgId) {
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(selectEntrys.size());
        ArrayList<String> ruleList = new ArrayList<String>(selectEntrys.size());
        for (DynamicObject entry : selectEntrys) {
            int index;
            String confirmMsg = this.matchingRuleOutValidateAlertMsg(entry, index = selectEntrys.indexOf((Object)entry));
            if (!confirmMsg.isEmpty()) {
                if (IGNORE.equals(confirmMsg)) {
                    return;
                }
                throw new KDBizException(confirmMsg);
            }
            DynamicObject material = entry.getDynamicObject("material");
            String rule = material.getString("outboundrules");
            ruleList.add(rule);
            BigDecimal qty = entry.getBigDecimal("qty");
            Map<String, Object> paramsMap = this.buildFilterParams(entry);
            paramsMap.put("org", orgId);
            List<String> orderByRule = MatchRuleOutHelper.getOrderByRule(rule);
            ArrayList<QFilter> lotintrackFilter = new ArrayList<QFilter>(16);
            lotintrackFilter.add(new QFilter("material", "=", material.getPkValue()));
            lotintrackFilter.add(new QFilter("org", "=", (Object)orgId));
            DataSet lotintracksSet = MatchRuleOutHelper.getLotinTracksDataSet(lotintrackFilter);
            Map<String, Object> singleEntryMap = MatchRuleOutHelper.getInsertEntryInfo(lotintracksSet, qty, paramsMap, orderByRule);
            entryInfoList.add(singleEntryMap);
        }
        this.dealWithEntry(entryInfoList, ruleList, selectEntrys);
    }

    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList, DynamicObjectCollection selectEntrys) {
        Boolean isEnough = Boolean.TRUE;
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            BigDecimal qty = (BigDecimal)insertEntry.get("qty");
            BigDecimal invAccCounts = (BigDecimal)insertEntry.get("count");
            String materialName = (String)insertEntry.get("materialName");
            Integer precision = (Integer)insertEntry.get("precision");
            if (BigDecimal.ZERO.compareTo(invAccCounts) == 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599,\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5206\u5f55\u6570\u636e\u548c\u5373\u65f6\u5e93\u5b58", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]), i + 1);
                throw new KDBizException(errorMsg);
            }
            if (qty.compareTo(invAccCounts) <= 0) continue;
            isEnough = Boolean.FALSE;
            BigDecimal remainQty = qty.subtract(invAccCounts);
            if (precision != null) {
                remainQty = remainQty.setScale((int)precision, 4);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("index", i);
            paramMap.put("remainQty", remainQty);
            paramMap.put("materialName", materialName);
            paramList.add(paramMap);
        }
        if (!isEnough.booleanValue()) {
            this.showConfirm(insertEntryInfo, paramList, ruleList);
        } else {
            this.insertEntry(insertEntryInfo, selectEntrys);
        }
    }

    public void insertEntry(List<Map<String, Object>> insertEntryInfo, DynamicObjectCollection selectEntrys) {
        ArrayList<Map<Object, Object>> confirmList = new ArrayList<Map<Object, Object>>(16);
        Map<String, Object> insertEntry = insertEntryInfo.get(0);
        List entryInfoList = (List)insertEntry.get("entryInfo");
        Map map = (Map)entryInfoList.get(0);
        DynamicObject selectEntry = (DynamicObject)selectEntrys.get(0);
        Date produceDate = this.parseDate((String)map.get("producedate"));
        Date expiryDate = this.parseDate((String)map.get("expirydate"));
        selectEntry.set("lotnumber", map.get("lotnumber"));
        selectEntry.set("producedate", (Object)produceDate);
        selectEntry.set("expirydate", (Object)expiryDate);
        selectEntry.set("warehouse", map.get("warehouse"));
        DynamicObject materialInvInfo = selectEntry.getDynamicObject("material");
        HashMap<String, Comparable<Integer>> confirmMap = new HashMap<String, Comparable<Integer>>();
        confirmMap.put("entryIndex", Integer.valueOf(0));
        confirmMap.put("materialInvInfo", (Comparable<Integer>)materialInvInfo);
        confirmMap.put("expiryDate", expiryDate);
        confirmMap.put("produceDate", produceDate);
        confirmList.add(confirmMap);
        this.showExpiryDateConfirm(confirmList);
    }

    private Date parseDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sd.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
        }
    }

    private void showExpiryDateConfirm(List<Map<Object, Object>> confirmList) {
        StringBuilder alertMsg = new StringBuilder();
        Date nowDate = new Date();
        for (int i = 0; i < confirmList.size(); ++i) {
            int dateOfOverdueForOut;
            Map<Object, Object> confirmMap = confirmList.get(i);
            int rowIndex = (Integer)confirmMap.get("entryIndex");
            DynamicObject materialInvInfo = (DynamicObject)confirmMap.get("materialInvInfo");
            Date newExpiryDate = (Date)confirmMap.get("expiryDate");
            if (newExpiryDate == null) {
                return;
            }
            String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
            Date overdueDate = MatchRuleOutHelper.getDateOfOverdue(leadTimeUnit, dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout"), newExpiryDate);
            boolean dateOver = nowDate.after(overdueDate);
            if (!dateOver) continue;
            String newExpiryDateStr = this.getDateStr(newExpiryDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599[%s]\u5230\u671f\u65e5\u671f\u4e3a[%s],", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpiryDateStr);
            alertMsg.append(msg);
        }
        if (alertMsg.length() > 0) {
            throw new KDBizException(alertMsg.toString());
        }
    }

    private String getDateStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sd.format(date);
        return dateStr;
    }

    private void showConfirm(List<Map<String, Object>> entryInfoList, List<Map<String, Object>> paramList, List<String> ruleList) {
        if (null != entryInfoList) {
            StringBuilder detailMsg = new StringBuilder();
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> map = paramList.get(i);
                int index = (Integer)map.get("index");
                BigDecimal remainQty = (BigDecimal)map.get("remainQty");
                String materialName = (String)map.get("materialName");
                String outRule = MatchRuleOutHelper.getOutRule(ruleList.get(i));
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599:%s %s, \u4e0d\u8db3\u6570\u91cf\u4e3a\uff1a%s;", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]), index + 1, materialName, outRule, remainQty);
                detailMsg.append(msg);
            }
            throw new KDBizException(detailMsg.toString());
        }
    }

    private Map<String, Object> buildFilterParams(DynamicObject entry) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        DynamicObject auxpty = entry.getDynamicObject("auxpty");
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject baseunit = entry.getDynamicObject("baseunit");
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        DynamicObject locaition = entry.getDynamicObject("location");
        DynamicObject outinvtype = entry.getDynamicObject("outinvtype");
        DynamicObject outinvstatus = entry.getDynamicObject("outinvstatus");
        Object ownertype = entry.get("outownertype");
        DynamicObject owner = entry.getDynamicObject("outowner");
        Object keepertype = entry.get("outkeepertype");
        DynamicObject keeper = entry.getDynamicObject("outkeeper");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (null != auxpty) {
            paramsMap.put("auxpty", auxpty.getPkValue());
        }
        if (null != warehouse) {
            paramsMap.put("warehouse", warehouse.getPkValue());
        }
        if (null != locaition) {
            paramsMap.put("location", locaition.getPkValue());
        }
        paramsMap.put("material", DynamicObjectUtils.getPkValue((DynamicObject)material));
        paramsMap.put("invstatus", DynamicObjectUtils.getPkValue((DynamicObject)outinvstatus));
        paramsMap.put("baseunit", DynamicObjectUtils.getPkValue((DynamicObject)baseunit));
        paramsMap.put("unit", DynamicObjectUtils.getPkValue((DynamicObject)unit));
        paramsMap.put("invtype", DynamicObjectUtils.getPkValue((DynamicObject)outinvtype));
        paramsMap.put("ownertype", ownertype);
        paramsMap.put("owner", DynamicObjectUtils.getPkValue((DynamicObject)owner));
        paramsMap.put("keepertype", keepertype);
        paramsMap.put("keeper", DynamicObjectUtils.getPkValue((DynamicObject)keeper));
        return paramsMap;
    }

    private String matchingRuleOutValidateAlertMsg(DynamicObject entry, int index) {
        String msg;
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject outInvType = entry.getDynamicObject("outinvtype");
        DynamicObject outInvStatus = entry.getDynamicObject("outinvstatus");
        Object outOwnerType = entry.get("outownertype");
        DynamicObject outOwner = entry.getDynamicObject("outowner");
        Object outKeeperType = entry.get("outkeepertype");
        DynamicObject outKeeper = entry.getDynamicObject("outkeeper");
        StringBuilder alertMsg = new StringBuilder();
        if (null == material || null == unit || null == outKeeper || null == outInvType || null == outInvStatus || null == outOwnerType || null == outOwner || null == outKeeperType || BigDecimal.ZERO.compareTo(qty) == 0) {
            if (null == material) {
                alertMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == unit) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outInvType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outInvStatus) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outOwnerType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outOwner) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outKeeperType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            if (null == outKeeper) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            }
            alertMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a ", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]));
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]), index + 1);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        if (material != null && !material.getBoolean("enablelot") && !material.getBoolean("enableshelflifemgr")) {
            return IGNORE;
        }
        if (material != null && material.getBoolean("enablelot") && StringUtils.isEmpty((CharSequence)material.getString("outboundrules"))) {
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u8bbe\u7f6e\u51fa\u5e93\u89c4\u5219", (String)"GiftRecBillConvertPlugin", (String)"occ-ocpos-business", (Object[])new Object[0]), index + 1);
            return msg;
        }
        return alertMsg.toString();
    }

    private void appendSpaceMark(StringBuilder alertMsg) {
        if (alertMsg.length() > 0) {
            alertMsg.append('\u3001');
        }
    }
}

