/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.converthelper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.exception.KDBizException;
import kd.occ.ocpos.business.saleorder.SaleOrderPushHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleReturn2OcocBillPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("basebilltype");
        e.addSrcField("srcbillbiztype");
        e.addSrcField("sourcebillid");
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject ococBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            if (srcRows == null || srcRows.size() == 0) {
                throw new KDBizException("\u96f6\u552e\u9000\u8d27\u4e0b\u63a8\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u6e90\u5355\u884c\u6570\u636e\u3002");
            }
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            String msg = this.checkIsNeedPush(e, ococBill, srcRow);
            if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
            throw new KDBizException(msg);
        }
    }

    private String checkIsNeedPush(AfterCreateLinkEventArgs e, DynamicObject ococBill, DynamicObject srcRow) {
        Object billType = ((DynamicProperty)e.getFldProperties().get("basebilltype")).getValue((Object)srcRow);
        Object srcBizTypeObj = ((DynamicProperty)e.getFldProperties().get("srcbillbiztype")).getValue((Object)srcRow);
        Object sourceBillIdObj = ((DynamicProperty)e.getFldProperties().get("sourcebillid")).getValue((Object)srcRow);
        long billTypeId = CommonUtil.formatObejctToLong((Object)billType);
        String srcBizType = CommonUtil.formatStringToEmpty((Object)srcBizTypeObj);
        long sourceBillId = CommonUtil.formatObejctToLong((Object)sourceBillIdObj);
        String msg = SaleOrderPushHelper.checkSaleOrderAllowPushOcocBill(billTypeId, srcBizType, sourceBillId);
        return msg;
    }
}

