/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.fundhelper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdbd.business.helper.pos.QueryFundsHelper;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class AutoPaymentBillHelper {
    public static BigDecimal queryNoBusinessAmount(long payStoreId, Date paymentDate, Long payTypeId, long currency) {
        BigDecimal noBusinessAmount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("branch", "=", (Object)payStoreId);
        qFilter.and("nobusinessentry.paydate", "=", (Object)paymentDate);
        qFilter.and("nobusinessentry.paytype", "=", (Object)payTypeId);
        DynamicObjectCollection noBusinessBills = QueryServiceHelper.query((String)"ocpos_nobusiness", (String)"nobusinessentry.payamount,nobusinessentry.paycurrency", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)noBusinessBills)) {
            for (DynamicObject noBusinessBill : noBusinessBills) {
                BigDecimal tempAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)noBusinessBill, (String)"nobusinessentry.payamount");
                long currencyId = DynamicObjectUtil.getLong((DynamicObject)noBusinessBill, (String)"nobusinessentry.paycurrency");
                BigDecimal rate = BigDecimal.ONE;
                if (currency != 0L && currency != currencyId && currencyId != 0L && (rate = CommonUtils.getCurrencyRate((long)currencyId, (long)currency)).compareTo(BigDecimal.ZERO) == 0) {
                    rate = BigDecimal.ONE;
                }
                noBusinessAmount = noBusinessAmount.add(tempAmount.multiply(rate));
            }
        }
        return noBusinessAmount;
    }

    public static void updatePaymentList(long payStoreId, Date paymentDate) {
        QFilter filter = new QFilter("paystore", "=", (Object)payStoreId);
        filter.and("paydate", ">=", (Object)paymentDate);
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"ocpos_payment").getAllFields().keySet();
        DynamicObject[] paymentArray = BusinessDataServiceHelper.load((String)"ocpos_payment", (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray(), (String)"paydate");
        int i = 0;
        for (DynamicObject payment : paymentArray) {
            if (i == 0) {
                ++i;
                continue;
            }
            DynamicObject lastPayment = paymentArray[i - 1];
            DynamicObjectCollection lastPaymentEntry = lastPayment.getDynamicObjectCollection("paymententry");
            HashMap<String, DynamicObject> lastPaymentMap = new HashMap<String, DynamicObject>(lastPaymentEntry.size());
            for (DynamicObject lastEntry : lastPaymentEntry) {
                String payType = String.valueOf(lastEntry.getDynamicObject("paytype").getPkValue());
                lastPaymentMap.put(payType, lastEntry);
            }
            DynamicObjectCollection paymentEntry = payment.getDynamicObjectCollection("paymententry");
            for (DynamicObject entry : paymentEntry) {
                DynamicObject payTypeEntity = entry.getDynamicObject("paytype");
                Date date = entry.getDate("paymentdate");
                String payType = String.valueOf(entry.getDynamicObject("paytype").getPkValue());
                DynamicObject lastEntryRow = (DynamicObject)lastPaymentMap.get(payType);
                if (lastEntryRow == null) continue;
                BigDecimal beforeAmount = entry.getBigDecimal("beforebalapayamt");
                BigDecimal newBeforeAmount = lastEntryRow.getBigDecimal("todaybalapayamt");
                BigDecimal adjustAmount = QueryFundsHelper.getAdjustAmount((long)payStoreId, (long)DynamicObjectUtils.getPkValue((DynamicObject)payTypeEntity), (Date)date);
                BigDecimal lastAdjustAmount = entry.getBigDecimal("guestabjamt");
                entry.set("beforebalapayamt", (Object)newBeforeAmount);
                BigDecimal todayAmount = entry.getBigDecimal("todaybalapayamt").add(newBeforeAmount).subtract(beforeAmount).add(adjustAmount).subtract(lastAdjustAmount);
                entry.set("todaybalapayamt", (Object)todayAmount);
                entry.set("guestabjamt", (Object)adjustAmount);
            }
            ++i;
        }
        SaveServiceHelper.update((DynamicObject[])paymentArray);
    }

    public static void updateReceiptList(List<Long> storeId, Date receiptDate) {
        for (Long id : storeId) {
            DynamicObject[] receiptEntity = AutoPaymentBillHelper.getReceiptEntity(receiptDate, id);
            int i = 0;
            for (DynamicObject entity : receiptEntity) {
                if (i == 0) {
                    DynamicObjectCollection receiptEntry = entity.getDynamicObjectCollection("receiptentry");
                    List todayEntry = receiptEntry.stream().filter(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("store")) == id).collect(Collectors.toList());
                    for (DynamicObject entry : todayEntry) {
                        AutoPaymentBillHelper.updateRelatedAmount(id, entry);
                    }
                    ++i;
                    continue;
                }
                DynamicObject lastEntity = receiptEntity[i - 1];
                DynamicObjectCollection lastPaymentEntry = lastEntity.getDynamicObjectCollection("receiptentry");
                List lastEntry = lastPaymentEntry.stream().filter(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("store")) == id).collect(Collectors.toList());
                HashMap<String, DynamicObject> lastPaymentMap = new HashMap<String, DynamicObject>(lastPaymentEntry.size());
                for (DynamicObject row : lastEntry) {
                    String payType = String.valueOf(row.getDynamicObject("paytype").getPkValue());
                    lastPaymentMap.put(payType, row);
                }
                DynamicObjectCollection receiptEntry = entity.getDynamicObjectCollection("receiptentry");
                List todayEntry = receiptEntry.stream().filter(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("store")) == id).collect(Collectors.toList());
                for (DynamicObject entry : todayEntry) {
                    DynamicObject payTypeEntity = entry.getDynamicObject("paytype");
                    Date date = entry.getDate("receiptdate");
                    String payType = String.valueOf(payTypeEntity.getPkValue());
                    DynamicObject lastEntryRow = (DynamicObject)lastPaymentMap.get(payType);
                    if (lastEntryRow == null) continue;
                    BigDecimal beforeAmount = entry.getBigDecimal("beforebalanceamount");
                    BigDecimal newBeforeAmount = lastEntryRow.getBigDecimal("todaybalanceamount");
                    BigDecimal lastAdjustAmount = entry.getBigDecimal("adjustamount");
                    BigDecimal adjustAmount = QueryFundsHelper.getAdjustAmount((long)id, (long)DynamicObjectUtils.getPkValue((DynamicObject)payTypeEntity), (Date)date);
                    entry.set("adjustamount", (Object)adjustAmount);
                    entry.set("beforebalanceamount", (Object)newBeforeAmount);
                    BigDecimal todayAmount = entry.getBigDecimal("todaybalanceamount").add(newBeforeAmount).subtract(beforeAmount).add(adjustAmount).subtract(lastAdjustAmount);
                    entry.set("todaybalanceamount", (Object)todayAmount);
                }
                ++i;
            }
            SaveServiceHelper.update((DynamicObject[])receiptEntity);
        }
    }

    private static void updateRelatedAmount(Long id, DynamicObject entry) {
        DynamicObject payTypeEntity = entry.getDynamicObject("paytype");
        Date date = entry.getDate("receiptdate");
        BigDecimal beforeAmount = entry.getBigDecimal("beforebalanceamount");
        BigDecimal lastAdjustAmount = entry.getBigDecimal("adjustamount");
        BigDecimal adjustAmount = QueryFundsHelper.getAdjustAmount((long)id, (long)DynamicObjectUtils.getPkValue((DynamicObject)payTypeEntity), (Date)date);
        entry.set("adjustamount", (Object)adjustAmount);
        BigDecimal todayAmount = entry.getBigDecimal("todaybalanceamount").add(adjustAmount).subtract(lastAdjustAmount);
        entry.set("todaybalanceamount", (Object)todayAmount);
    }

    private static DynamicObject[] getReceiptEntity(Date receiptDate, Long id) {
        QFilter filter = new QFilter("receiptentry.store", "=", (Object)id);
        filter.and("receiptentry.receiptdate", ">=", (Object)receiptDate);
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"ocpos_receipt").getAllFields().keySet();
        return BusinessDataServiceHelper.load((String)"ocpos_receipt", (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray(), (String)"receiptentry.receiptdate");
    }

    public static void handlerAdjustmentBill(String operateKey, DynamicObjectCollection adjustEntry, IFormView view) {
        if ("audit".equals(operateKey)) {
            Date adjustDate;
            BigDecimal outAmount;
            DynamicObject inPayType;
            DynamicObject outPayType;
            long store;
            int index = 1;
            for (DynamicObject adjustInfo : adjustEntry) {
                store = DynamicObjectUtil.getPkValue((DynamicObject)adjustInfo, (String)"store");
                outPayType = DynamicObjectUtil.getDynamicObject((DynamicObject)adjustInfo, (String)"outpaytype");
                inPayType = DynamicObjectUtil.getDynamicObject((DynamicObject)adjustInfo, (String)"inpaytype");
                outAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)adjustInfo, (String)"outamount");
                adjustDate = adjustInfo.getDate("adjustdate");
                AutoPaymentBillHelper.hasPaymentBill(store, outPayType, adjustDate, index, view);
                AutoPaymentBillHelper.hasPaymentBill(store, inPayType, adjustDate, index, view);
                ++index;
            }
            for (DynamicObject adjustInfo : adjustEntry) {
                store = DynamicObjectUtil.getPkValue((DynamicObject)adjustInfo, (String)"store");
                outPayType = DynamicObjectUtil.getDynamicObject((DynamicObject)adjustInfo, (String)"outpaytype");
                inPayType = DynamicObjectUtil.getDynamicObject((DynamicObject)adjustInfo, (String)"inpaytype");
                outAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)adjustInfo, (String)"outamount");
                adjustDate = adjustInfo.getDate("adjustdate");
                AutoPaymentBillHelper.overWriteAdjustAmount(store, outPayType, adjustDate, outAmount.negate());
                AutoPaymentBillHelper.overWriteAdjustAmount(store, inPayType, adjustDate, outAmount);
            }
        }
    }

    private static void hasPaymentBill(long store, DynamicObject payType, Date adjustDate, int index, IFormView view) {
        DynamicObject paymentBill;
        boolean isNeedPay = payType.getBoolean("isneedpay");
        if (isNeedPay && (paymentBill = AutoPaymentBillHelper.getPaymentBill(store, payType, adjustDate)) == null) {
            String msg = "\u8fd8\u6ca1\u6709\u505a\u7f34\u6b3e\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u6574\uff0c\u8bf7\u5148\u5904\u7406\u7f34\u6b3e\u4e1a\u52a1";
            NotificationUtil.showDefaultTipNotify((String)("\u8c03\u6574\u660e\u7ec6\u7b2c" + index + "\u884c\u6536\u6b3e\u65b9\u5f0f\u7c7b\u578b" + payType.getString("name") + msg), (IFormView)view);
            throw new KDBizException("\u81ea\u5b9a\u4e49\u5f02\u5e38");
        }
    }

    private static void overWriteAdjustAmount(long store, DynamicObject payType, Date adjustDate, BigDecimal amount) {
        boolean isNeedPay = payType.getBoolean("isneedpay");
        if (isNeedPay) {
            AutoPaymentBillHelper.overWritePayment(store, payType, adjustDate, amount);
        } else {
            AutoPaymentBillHelper.overWriteReceipt(store, payType, adjustDate, amount);
        }
    }

    private static void overWritePayment(long store, DynamicObject payType, Date adjustDate, BigDecimal amount) {
        DynamicObject paymentBill = AutoPaymentBillHelper.getPaymentBill(store, payType, adjustDate);
        DynamicObjectCollection paymentEntry = paymentBill.getDynamicObjectCollection("paymententry");
        if (!CollectionUtils.isEmpty((Collection)paymentEntry)) {
            for (DynamicObject paymentInfo : paymentEntry) {
                if (!payType.getPkValue().equals(paymentInfo.getDynamicObject("paytype").getPkValue())) continue;
                DynamicObjectCollection paymentString = paymentInfo.getDynamicObjectCollection("paymentstring");
                DynamicObject tempInfo = paymentString.addNew();
                tempInfo.set("stringpaytype", (Object)payType);
                tempInfo.set("stringamount", (Object)amount);
                BigDecimal stringSum = BigDecimal.ZERO;
                for (DynamicObject stringInfo : paymentString) {
                    stringSum = stringSum.add(DynamicObjectUtil.getBigDecimal((DynamicObject)stringInfo, (String)"stringamount"));
                }
                paymentInfo.set("guestabjamt", (Object)stringSum);
                BigDecimal todayBalancePayAmount = QueryFundsHelper.queryTodayBalancePayAmount((DynamicObject)paymentInfo);
                paymentInfo.set("todaybalapayamt", (Object)todayBalancePayAmount);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{paymentBill});
    }

    private static void overWriteReceipt(long store, DynamicObject payType, Date adjustDate, BigDecimal amount) {
        DynamicObject bill = AutoPaymentBillHelper.getReceivedBill(store, payType, adjustDate);
        if (bill == null) {
            return;
        }
        DynamicObjectCollection paymentEntry = bill.getDynamicObjectCollection("receiptentry");
        if (!CollectionUtils.isEmpty((Collection)paymentEntry)) {
            for (DynamicObject paymentInfo : paymentEntry) {
                if (!payType.getPkValue().equals(paymentInfo.getDynamicObject("paytype").getPkValue()) || store != DynamicObjectUtils.getPkValue((DynamicObject)paymentInfo.getDynamicObject("store"))) continue;
                BigDecimal adjustAmount = paymentInfo.getBigDecimal("adjustamount");
                paymentInfo.set("adjustamount", (Object)adjustAmount.add(amount));
                AutoPaymentBillHelper.updateTodayBalanceAmount(paymentInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private static DynamicObject getPaymentBill(long store, DynamicObject payType, Date adjustDate) {
        QFilter qFilter = new QFilter("paystore", "=", (Object)store);
        qFilter.and("paymententry.paytype", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)payType));
        qFilter.and("paymententry.paymentdate", "=", (Object)adjustDate);
        return BusinessDataServiceHelper.loadSingle((String)"ocpos_payment", (String)AutoPaymentBillHelper.getBillField("ocpos_payment"), (QFilter[])qFilter.toArray());
    }

    private static DynamicObject getReceivedBill(long store, DynamicObject payType, Date adjustDate) {
        QFilter qFilter = new QFilter("receiptentry.store", "=", (Object)store);
        qFilter.and("receiptentry.paytype", "=", payType.getPkValue());
        qFilter.and("receiptentry.receiptdate", "=", (Object)adjustDate);
        return BusinessDataServiceHelper.loadSingle((String)"ocpos_receipt", (String)AutoPaymentBillHelper.getBillField("ocpos_receipt"), (QFilter[])qFilter.toArray());
    }

    private static void updateTodayBalanceAmount(DynamicObject receiptEntry) {
        BigDecimal beforebalanceamount = receiptEntry.getBigDecimal("beforebalanceamount");
        BigDecimal receivableamount = receiptEntry.getBigDecimal("receivableamount");
        BigDecimal unreceivableamount = receiptEntry.getBigDecimal("unreceivableamount");
        BigDecimal receiptamount = receiptEntry.getBigDecimal("receiptamount");
        BigDecimal serviceamount = receiptEntry.getBigDecimal("serviceamount");
        BigDecimal shouldreturnamount = receiptEntry.getBigDecimal("shouldreturnamount");
        BigDecimal adjustamount = receiptEntry.getBigDecimal("adjustamount");
        BigDecimal todaybalanceamount = unreceivableamount.add(beforebalanceamount).add(receivableamount).subtract(serviceamount).subtract(shouldreturnamount).subtract(receiptamount).add(adjustamount);
        receiptEntry.set("todaybalanceamount", (Object)todaybalanceamount);
    }

    private static String getBillField(String billName) {
        Set field = EntityMetadataCache.getDataEntityType((String)billName).getAllFields().keySet();
        return String.join((CharSequence)",", field);
    }
}

