/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataPropEdit;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class FillBatchHelper {
    private static final String[] needFillFields = new String[]{"taxrateid", "inorg", "outorg", "project", "invstatus", "invtype", "ownertype", "keepertype", "outinvstatus", "outinvtype", "outownertype", "warehouse", "qty"};

    public static void batchFill(IFormView view) {
        FillBatchHelper.batchFill(view, "entryentity", needFillFields);
    }

    public static void batchFill(IFormView view, String entryName, String[] needFillFields) {
        IDataModel model = view.getModel();
        int currentRow = model.getEntryCurrentRowIndex(entryName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        String selKey = entryGrid.getEntryState().getFocusField();
        Object o = entryGrid.getEntryState().get(selKey);
        Control control = view.getControl(selKey);
        if (control instanceof BasedataPropEdit) {
            NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5b57\u6bb5\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_3", (String)"occ-ocpos-business", (Object[])new Object[0]), (IFormView)view);
            return;
        }
        if (currentRow == -1 || CommonUtils.isNull((Object)selKey) || "0".equals(selKey) || "seq".equals(selKey)) {
            NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\uff01", (String)"FillBatchHelper_0", (String)"occ-ocpos-business", (Object[])new Object[0]), (IFormView)view);
            return;
        }
        Object selValue = model.getValue(selKey, currentRow);
        if (CommonUtils.isNull((Object)selValue)) {
            NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u503c\u586b\u5145\uff01", (String)"FillBatchHelper_1", (String)"occ-ocpos-business", (Object[])new Object[0]), (IFormView)view);
            return;
        }
        int rowCount = model.getEntryRowCount(entryName);
        List<String> needFillFieldList = Arrays.asList(needFillFields);
        for (int i = currentRow + 1; i < rowCount; ++i) {
            boolean needFill;
            boolean isFill;
            Object object = model.getValue(selKey, i);
            boolean bl = isFill = StringUtils.isBlank((Object)object) || object instanceof BigDecimal && ((BigDecimal)object).compareTo(BigDecimal.ZERO) == 0 || object instanceof Integer && "0".equals(String.valueOf(object));
            if (!isFill) continue;
            DynamicObject warehouse = null;
            if (needFillFieldList.contains(selKey)) {
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("location".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("warehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i);
                continue;
            }
            if ("owner".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "ownertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("keeper".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "keepertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("outowner".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "outownertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("outkeeper".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "outkeepertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            String name = model.getProperty(selKey).getDisplayName().getLocaleValue();
            NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)(name + "\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002"), (String)"FillBatchHelper_2", (String)"scmc-im-business", (Object[])new Object[0]), (IFormView)view);
            break;
        }
    }

    private static boolean isNeedFillByType(IDataModel model, String field, int fillRow, int curRow) {
        boolean needFill = false;
        Object ownerType = model.getValue(field, fillRow);
        Object curOwnerType = model.getValue(field, curRow);
        if (ownerType == null || curOwnerType == null) {
            return needFill;
        }
        if (ownerType.equals(curOwnerType)) {
            needFill = true;
        }
        return needFill;
    }

    private static void fillLocationCell(IFormView view, String entryName, DynamicObject warehouse, Object value, int index) {
        if (CommonUtils.isNull((Object)warehouse)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        String selKey = entryGrid.getEntryState().getFocusField();
        DynamicObjectCollection lotsCol = warehouse.getDynamicObjectCollection("entryentity");
        for (DynamicObject lots : lotsCol) {
            DynamicObject location = lots.getDynamicObject("location");
            if (((DynamicObject)value).getPkValue() != location.getPkValue()) continue;
            view.getModel().setValue(selKey, value, index);
            break;
        }
    }
}

