/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class InventoryHelper {
    public static long getInvSchemeByEntityAndBizType(String billFormID, long bizTypeId) {
        if (billFormID == null || bizTypeId == 0L) {
            return 0L;
        }
        QFilter filter = new QFilter("billform", "=", (Object)billFormID);
        filter.and("bitypeentry.biztype", "=", (Object)bizTypeId);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("bitypeentry.allowmanualadd", "=", (Object)"1");
        List invSchemeIds = QueryServiceHelper.queryPrimaryKeys((String)"im_invscheme", (QFilter[])filter.toArray(), (String)"number", (int)1);
        if (CollectionUtils.isEmpty((Collection)invSchemeIds)) {
            return 0L;
        }
        return CommonUtil.formatObejctToLong(invSchemeIds.get(0));
    }

    public static List<String> getOrderByRule(String rule) {
        ArrayList<String> orderByRule = new ArrayList<String>();
        switch (rule) {
            case "A": {
                orderByRule.add("biztime asc");
                orderByRule.add("createtime asc");
                orderByRule.add("lotnumber asc");
                break;
            }
            case "B": {
                orderByRule.add("biztime desc");
                orderByRule.add("createtime desc");
                orderByRule.add("lotnumber desc");
                break;
            }
            case "C": {
                orderByRule.add("lotnumber asc");
                break;
            }
            case "D": {
                orderByRule.add("expirydate asc");
                break;
            }
        }
        return orderByRule;
    }

    public static DataSet getLotInTracksDataSet(List<QFilter> filters) {
        String selectFields = "material.masterid as masterid, material as materialid";
        return QueryServiceHelper.queryDataSet((String)"LotInTrack", (String)"im_lotintrack", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)"");
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return InventoryHelper.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return InventoryHelper.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    public static DynamicObject getDefaultInvType(DynamicObject invScheme) {
        return InventoryHelper.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    public static DynamicObject getDefaultOutInvType(DynamicObject invScheme) {
        return InventoryHelper.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)invScheme, (String)invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (!CollectionUtils.isEmpty((Collection)entries)) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }

    public static long getDefaultOwner(String type, long orgId, long customerId) {
        return InventoryHelper.getDefOwnerValue(type, orgId, customerId);
    }

    public static long getDefaultKeeper(String type, long orgId, long customerId) {
        return InventoryHelper.getDefKeeper(type, orgId, customerId);
    }

    public static long getDefaultOutOwner(String type, long orgId, long customerId) {
        return InventoryHelper.getDefOwnerValue(type, orgId, customerId);
    }

    public static long getDefaultOutKeeper(String type, long orgId, long customerId) {
        return InventoryHelper.getDefKeeper(type, orgId, customerId);
    }

    private static long getDefOwnerValue(String type, long orgId, long customerId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return 0L;
        }
        long defOwnerId = InventoryHelper.getOwnerDefValue(orgId);
        return InventoryHelper.getOwnerOrKeeperByType(type, defOwnerId, customerId);
    }

    private static long getDefKeeper(String type, long orgId, long customerId) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return 0L;
        }
        return InventoryHelper.getOwnerOrKeeperByType(type, orgId, customerId);
    }

    private static long getOwnerOrKeeperByType(String type, long orgId, long customerId) {
        long keeperId = 0L;
        if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
            if (orgId != 0L) {
                keeperId = orgId;
            }
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"bd_customer") && customerId != 0L) {
            keeperId = customerId;
        }
        return keeperId;
    }

    private static long getOwnerDefValue(long toOrgId) {
        long defOwnerId;
        if (toOrgId == 0L) {
            return 0L;
        }
        List<Long> orgIds = InventoryHelper.getOwners(toOrgId);
        if (CollectionUtils.isEmpty(orgIds)) {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)toOrgId, (Boolean)false, (Boolean)true);
            defOwnerId = CommonUtil.formatObejctToLong(map.get("id"));
        } else {
            defOwnerId = orgIds.get(0);
        }
        return defOwnerId;
    }

    private static List<Long> getOwners(long orgId) {
        if (orgId == 0L) {
            return new ArrayList<Long>(0);
        }
        List ownerIds = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        return ownerIds.stream().distinct().collect(Collectors.toList());
    }
}

