/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class LogisticsInfoHelper {
    public static boolean haveLogisticsInfo(long deliveryEntryId) {
        DynamicObjectCollection logisticsData = LogisticsInfoHelper.getLogisticsData(deliveryEntryId);
        return !CollectionUtils.isEmpty((Collection)logisticsData);
    }

    public static DynamicObject getLogisticsInfo(long deliveryEntryId) {
        DynamicObjectCollection logisticsData = LogisticsInfoHelper.getLogisticsData(deliveryEntryId);
        if (!CollectionUtils.isEmpty((Collection)logisticsData)) {
            return (DynamicObject)logisticsData.get(0);
        }
        return null;
    }

    public static DynamicObject getLogisticsInfo(Object logisticsInfoId) {
        ORM orm = ORM.create();
        DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType("ocococ_deliveryorder.logisticsinfo");
        return BusinessDataServiceHelper.loadSingle((Object)logisticsInfoId, (DynamicObjectType)entityType);
    }

    public static DynamicObjectCollection getLogisticsData(long deliveryEntryId) {
        DynamicObject deliveryOrder = LogisticsInfoHelper.getDeliveryOrder(deliveryEntryId);
        return DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"logisticsinfo");
    }

    public static List<DynamicObject> getLogisticsInfo(long entryId, String entityId) {
        DynamicObject[] deliveryOrders = LogisticsInfoHelper.getDeliveryOrders(entryId, entityId);
        if (deliveryOrders != null && deliveryOrders.length > 0) {
            ArrayList<DynamicObject> logisticsInfo = new ArrayList<DynamicObject>();
            for (DynamicObject deliveryOrder : deliveryOrders) {
                DynamicObjectCollection logisticsData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"logisticsinfo");
                if (CollectionUtils.isEmpty((Collection)logisticsData)) continue;
                logisticsInfo.add((DynamicObject)logisticsData.get(0));
            }
            return logisticsInfo;
        }
        return new ArrayList<DynamicObject>();
    }

    public static void setLogisticsInfo(DynamicObject data, boolean isNew) {
        DynamicObject logisticsInfo;
        long deliveryEntryId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"subentryid");
        DynamicObject deliveryOrder = LogisticsInfoHelper.getDeliveryOrder(deliveryEntryId);
        DynamicObjectCollection logisticsData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"logisticsinfo");
        if (logisticsData == null) {
            return;
        }
        if (isNew) {
            logisticsInfo = logisticsData.addNew();
        } else {
            long logisticsInfoId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"lastbillentryid");
            logisticsInfo = logisticsData.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == logisticsInfoId).findFirst().orElse(null);
            if (logisticsInfo == null) {
                return;
            }
        }
        DataEntityPropertyCollection properties = logisticsInfo.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (!DynamicObjectUtils.contain((DynamicObject)data, (String)key)) continue;
            if (StringUtils.equals((CharSequence)key, (CharSequence)"drivertel")) {
                String phone = data.getString(key);
                if (StringUtils.isNotBlank((CharSequence)phone) && !phone.contains("+86-")) {
                    logisticsInfo.set(key, (Object)("+86-" + phone));
                    continue;
                }
                logisticsInfo.set(key, (Object)phone);
                continue;
            }
            logisticsInfo.set(key, data.get(key));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{deliveryOrder});
    }

    private static DynamicObject getDeliveryOrder(long deliveryEntryId) {
        QFilter filter = new QFilter("entryentity.corebillentryid", "=", (Object)deliveryEntryId);
        filter.and("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        IDataEntityType entityType = ORM.create().getDataEntityType("ocococ_deliveryorder.logisticsinfo");
        List selectFields = entityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        selectFields.removeIf(x -> x.contains("_id"));
        return BusinessDataServiceHelper.loadSingle((String)"ocococ_deliveryorder", (String)StringUtils.join((Object[])selectFields.toArray(), (char)','), (QFilter[])filter.toArray());
    }

    private static DynamicObject[] getDeliveryOrders(long entryId, String entityId) {
        QFilter filter = new QFilter("goodsentryentity.id", "=", (Object)entryId);
        DynamicObjectCollection deliveryData = QueryServiceHelper.query((String)entityId, (String)"goodsentryentity.salesorderdelivery.id", (QFilter[])filter.toArray());
        List deliveryEntryIds = deliveryData.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsentryentity.salesorderdelivery.id")).collect(Collectors.toList());
        QFilter filter_1 = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        filter_1.and("entryentity.corebillentryid", "in", deliveryEntryIds);
        IDataEntityType entityType = ORM.create().getDataEntityType("ocococ_deliveryorder.logisticsinfo");
        List selectFields = entityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        selectFields.removeIf(x -> x.contains("_id"));
        return BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)StringUtils.join((Object[])selectFields.toArray(), (char)','), (QFilter[])filter_1.toArray());
    }
}

