/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocpos.common.util.DateUtil;

public class MatchRuleOutHelper {
    private static final String algoKey = MatchRuleOutHelper.class.getName();
    private static final String[] invList = new String[]{"ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype"};

    public static List<String> getOrderByRule(String rule) {
        ArrayList<String> orderByRule = new ArrayList<String>();
        switch (rule) {
            case "A": {
                orderByRule.add("biztime asc");
                orderByRule.add("createtime asc");
                orderByRule.add("lotnumber asc");
                break;
            }
            case "B": {
                orderByRule.add("biztime desc");
                orderByRule.add("createtime desc");
                orderByRule.add("lotnumber desc");
                break;
            }
            case "C": {
                orderByRule.add("lotnumber asc");
                break;
            }
            case "D": {
                orderByRule.add("expirydate asc");
                break;
            }
        }
        return orderByRule;
    }

    public static String getOutRule(String rule) {
        String outRule = "";
        switch (rule) {
            case "A": {
                outRule = ResManager.loadKDString((String)"\u6309\u6279\u53f7\u5148\u8fdb\u5148\u51fa", (String)"MatchRuleOutHelper", (String)"occ-ocpos-business", (Object[])new Object[0]);
                break;
            }
            case "B": {
                outRule = ResManager.loadKDString((String)"\u6309\u6279\u53f7\u540e\u8fdb\u5148\u51fa", (String)"MatchRuleOutHelper", (String)"occ-ocpos-business", (Object[])new Object[0]);
                break;
            }
            case "C": {
                outRule = ResManager.loadKDString((String)"\u6309\u6279\u53f7\u987a\u5e8f", (String)"MatchRuleOutHelper", (String)"occ-ocpos-business", (Object[])new Object[0]);
                break;
            }
            case "D": {
                outRule = ResManager.loadKDString((String)"\u6309\u8fd1\u6548\u671f", (String)"MatchRuleOutHelper", (String)"occ-ocpos-business", (Object[])new Object[0]);
                break;
            }
        }
        return outRule;
    }

    public static DataSet getLotinTracksDataSet(List<QFilter> qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_lotintrack");
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        selectorSet.add("material.masterid as masterid");
        selectorSet.add("material as materialid");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"MatchRuleOutHelper", (String)"im_lotintrack", (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        return ds;
    }

    public static Map<String, Object> getInsertEntryInfo(DataSet lotintracks, BigDecimal qty, Map<String, Object> paramsMap, List<String> orderByRule) {
        String materialName = "";
        Integer precision = null;
        ArrayList<Map<String, Object>> singleEntryInfoList = new ArrayList<Map<String, Object>>(16);
        BigDecimal invAccCounts = BigDecimal.ZERO;
        Boolean isContinue = Boolean.TRUE;
        List<QFilter> qFilterList = MatchRuleOutHelper.buildFilter(paramsMap);
        DataSet invAccDataSet = MatchRuleOutHelper.getInvAccDataSet(qFilterList);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        selectorSet.add("material.name");
        selectorSet.add("avbbqty");
        selectorSet.add("avbbtndqty");
        selectorSet.add("id");
        selectorSet.remove("keycol");
        String[] strArray = selectorSet.toArray(new String[selectorSet.size()]);
        DataSet result = lotintracks.join(invAccDataSet, JoinType.INNER).on("lotnumber", "lotnum").on("producedate", "producedate").on("expirydate", "expirydate").select(new String[]{"materialid as materialInventoryId", "lotnumber", "biztime", "createtime"}, strArray).finish().orderBy(orderByRule.toArray(new String[0]));
        for (Row row : result) {
            Long unitId;
            BigDecimal avbqty;
            if (!isContinue.booleanValue() || BigDecimal.ZERO.compareTo(avbqty = row.getBigDecimal("avbbqty")) >= 0) continue;
            BigDecimal remainqty = qty.subtract(invAccCounts);
            if ((invAccCounts = invAccCounts.add(avbqty)).compareTo(qty) > 0) {
                avbqty = remainqty;
                isContinue = Boolean.FALSE;
            }
            if (invAccCounts.compareTo(qty) == 0) {
                isContinue = Boolean.FALSE;
            }
            if (null != (unitId = row.getLong("unit"))) {
                DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"precision");
                precision = (Integer)unit.get("precision");
            }
            materialName = row.getString("material.name");
            Map<String, Object> singleEntryMap = MatchRuleOutHelper.putEntryMapForStandardBill(row, strArray);
            singleEntryMap.put("qty", avbqty);
            singleEntryInfoList.add(singleEntryMap);
        }
        HashMap<String, Object> entryMap = new HashMap<String, Object>(5);
        entryMap.put("materialName", materialName);
        entryMap.put("count", invAccCounts);
        entryMap.put("qty", qty);
        entryMap.put("precision", precision);
        entryMap.put("entryInfo", singleEntryInfoList);
        return entryMap;
    }

    public static Map<String, Object> putEntryMapForStandardBill(Row row, String[] strArray) {
        HashMap<String, Object> singleEntryMap = new HashMap<String, Object>(strArray.length);
        for (String field : strArray) {
            Object value = row.get(field);
            if ("lotnum".equals(field)) {
                field = "lotnumber";
            } else if (field.equals("producedate") || field.equals("expirydate")) {
                value = MatchRuleOutHelper.getDateStr((Date)value);
            } else if (Arrays.asList(invList).contains(field)) {
                field = "out" + field;
            }
            singleEntryMap.put(field, value);
        }
        Long materialInventoryId = row.getLong("materialInventoryId");
        singleEntryMap.put("material", materialInventoryId);
        Long avbqty2nd = row.getLong("avbbtndqty");
        singleEntryMap.put("avbqty2nd", avbqty2nd);
        return singleEntryMap;
    }

    public static String getDateStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sd.format(date);
        return dateStr;
    }

    public static List<QFilter> buildFilter(Map<String, Object> paramsMap) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
            if (null == entry.getKey()) continue;
            QFilter filter = new QFilter(entry.getKey(), "=", entry.getValue());
            qFilters.add(filter);
        }
        return qFilters;
    }

    public static DataSet getInvAccDataSet(List<QFilter> qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        selectorSet.add("material.name");
        selectorSet.add("id");
        selectorSet.remove("keycol");
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        DataSet avbbaseqtyDs = MatchRuleOutHelper.getAvbBaseQty(ds);
        return avbbaseqtyDs;
    }

    public static DataSet getAvbBaseQty(DataSet ds) {
        DataSet dsC = ds.copy();
        HashSet<Long> supplyBillIds = new HashSet<Long>(0);
        for (Row row : dsC) {
            supplyBillIds.add(row.getLong("id"));
        }
        QFilter filter = new QFilter("bal_obj.id", "=", (Object)"im_inv_realbalance");
        filter.and("bal_id", "in", supplyBillIds);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"msmod_reserve_record", (String)"bal_id as supplybillid,qty as reserveqty,base_qty as reservebaseqty,qty2nd as reserveunit2ndqty", (QFilter[])filter.toArray(), null);
        DataSet invAccSumReserve = reserveData.select("Cast(supplybillid as Long) supplybillid,reservebaseqty,reserveqty,reserveunit2ndqty").groupBy(new String[]{"supplybillid"}).sum("reservebaseqty").sum("reserveqty").sum("reserveunit2ndqty").finish();
        List<String> invAccFields = MatchRuleOutHelper.getDataSetCols(ds);
        List<String> reserveFields = MatchRuleOutHelper.getDataSetCols(invAccSumReserve);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        DataSet qty = ds.join(invAccSumReserve, JoinType.LEFT).on("id", "supplybillid").hint(hint).select(invAccFields.toArray(new String[0]), reserveFields.toArray(new String[0])).finish();
        invAccFields.add("case when reserveqty is Null then 0 else reserveqty end as reserveqty");
        invAccFields.add("case when reservebaseqty is Null then 0 else reservebaseqty end as reservebaseqty");
        invAccFields.add("case when reserveunit2ndqty is Null then 0 else reserveunit2ndqty end as reserveunit2ndqty");
        DataSet avbBaseQty = qty.select(invAccFields.toArray(new String[0]));
        List<String> invAccFields1 = MatchRuleOutHelper.getDataSetCols(avbBaseQty);
        invAccFields1.add("(baseqty-reservebaseqty) as avbbaseqty");
        invAccFields1.add("(qty-reserveqty) as avbbqty");
        invAccFields1.add("(qty2nd-reserveunit2ndqty) as avbbtndqty");
        invAccFields1.add("reservebaseqty as reservoeqty");
        invAccFields1.remove("avbbaseqty");
        return avbBaseQty.select(invAccFields1.toArray(new String[0]));
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int count = fields.length;
        ArrayList<String> list = new ArrayList<String>(count);
        for (Field field : fields) {
            list.add(field.getName().toLowerCase());
        }
        return list;
    }

    public static Date getDateOfOverdue(String leadTimeUnit, int dateOfOverdue, Date expirydate) {
        dateOfOverdue *= -1;
        if ("day".equals(leadTimeUnit)) {
            return DateUtil.addDay((Date)expirydate, (int)dateOfOverdue);
        }
        if ("month".equals(leadTimeUnit)) {
            return DateUtil.addMonth((Date)expirydate, (int)dateOfOverdue);
        }
        return "year".equals(leadTimeUnit) ? DateUtil.addYear((Date)expirydate, (int)dateOfOverdue) : DateUtil.addDay((Date)expirydate, (int)dateOfOverdue);
    }
}

