/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.LRUCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class OtherInInvSchemeService {
    protected IFormView view = null;
    protected DynamicObject bill = null;
    private boolean formPage = false;
    private LRUCache<String, String> localCache = null;

    public DynamicObject getBill() {
        return this.bill;
    }

    public void setBill(DynamicObject bill) {
        this.bill = bill;
    }

    public OtherInInvSchemeService() {
    }

    public OtherInInvSchemeService(DynamicObject bill) {
        this.bill = bill;
    }

    public OtherInInvSchemeService(IFormView view) {
        this.view = view;
        this.bill = view.getModel().getDataEntity(true);
        this.formPage = true;
    }

    private IPageCache getPageCache() {
        if (this.view == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        return pageCache;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    private LRUCache<String, String> getLocalCache() {
        if (this.localCache != null) {
            return this.localCache;
        }
        DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection("entryentity");
        int size = entrys.size();
        this.localCache = new LRUCache(size * 2 + 1);
        return this.localCache;
    }

    protected String getCache(String key) {
        String value = null;
        if (this.formPage) {
            IPageCache pageCache = this.getPageCache();
            if (pageCache != null) {
                value = pageCache.get(key);
            }
        } else {
            value = (String)this.getLocalCache().get((Object)key);
        }
        return value;
    }

    protected void putCache(String key, String value) {
        if (this.formPage) {
            IPageCache pageCache = this.getPageCache();
            if (pageCache != null) {
                pageCache.put(key, value);
            }
        } else {
            this.getLocalCache().put((Object)key, (Object)value);
        }
    }

    public IFormView getView() {
        return this.view;
    }

    public Object getValue(String key) {
        return this.bill.get(key);
    }

    public Object getValue(String key, int i) {
        DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection("entryentity");
        return ((DynamicObject)entrys.get(i)).get(key);
    }

    protected Long getCompanyByOrg(Long bizOrgId) {
        Long settleOrgId = null;
        if (bizOrgId != null) {
            String nullStr = "empty";
            String cacheKey = "settleOrgIdcache_" + bizOrgId;
            String settleOrgIdStr = this.getCache(cacheKey);
            if (settleOrgIdStr == null) {
                settleOrgId = this.queryCompanyId(bizOrgId);
                if (settleOrgId != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
                    this.putCache(cacheKey, settleOrgId.toString());
                } else {
                    this.putCache(cacheKey, nullStr);
                }
            } else if (!nullStr.equals(settleOrgIdStr)) {
                settleOrgId = Long.valueOf(settleOrgIdStr);
            }
        }
        return settleOrgId;
    }

    private Long queryCompanyId(Long bizOrgId) {
        Long settleOrgId = null;
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (map != null) {
            settleOrgId = (Long)map.get("id");
        }
        return settleOrgId;
    }

    protected List<Object> getOwnerList(DynamicObject org) {
        List<Object> array = new ArrayList<Object>();
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            String cacheKey = "ownercache_" + orgId;
            String ownerArrayStr = this.getCache(cacheKey);
            if (ownerArrayStr == null) {
                array = this.queryOwnerList(orgId);
                ownerArrayStr = StringUtils.join(array, (String)",");
                this.putCache(cacheKey, ownerArrayStr);
            } else {
                String[] ownerArray;
                for (String owner : ownerArray = ownerArrayStr.split(",")) {
                    array.add(Long.valueOf(owner));
                }
            }
        }
        return array;
    }

    private List<Object> queryOwnerList(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        ArrayList<Object> ownerArray = OtherInInvSchemeService.getOwners(orgId);
        array.addAll(ownerArray);
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (companyByOrg != null && (settleOrgId = (Object)companyByOrg.get("id")) != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
            array.add(settleOrgId);
        }
        return array;
    }

    public static ArrayList<Object> getOwners(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (orgId == null) {
            return array;
        }
        List ownerOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        if (ownerOrgs != null && ownerOrgs.size() > 0) {
            for (int i = 0; i < ownerOrgs.size(); ++i) {
                Long ownerOrgId = (Long)ownerOrgs.get(i);
                if (array.contains(ownerOrgId)) continue;
                array.add(ownerOrgs.get(i));
            }
        }
        return array;
    }

    public boolean isFormPage() {
        return this.formPage;
    }

    protected void setKeeperOwnerEnable(int rowIndex, String keeperOwnerType, String keeperOwnerKey) {
        IFormView view = this.getView();
        this.setKeeperOwnerEnable(view, rowIndex, keeperOwnerType, keeperOwnerKey);
    }

    private void setKeeperOwnerEnable(IFormView view, int rowIndex, String keeperOwnerType, String keeperOwnerKey) {
        if (StringUtils.isEmpty((CharSequence)keeperOwnerType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{keeperOwnerKey});
            return;
        }
        switch (keeperOwnerType) {
            case "bos_org": {
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{keeperOwnerKey});
                break;
            }
            case "bd_customer": 
            case "bd_supplier": {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{keeperOwnerKey});
                break;
            }
        }
    }

    public Object getDefalutOwner(String type, int i) {
        return this.getDefOwerValue(type);
    }

    public Object getDefalutKeeper(String type, int i) {
        return this.getDefalutKeeper(type);
    }

    public Object getDefalutOutOwner(String type, int i) {
        return this.getDefOwerValue(type);
    }

    public Object getDefalutOutKeeper(String type, int i) {
        return this.getDefalutKeeper(type);
    }

    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    public void setOwnerF7Select(BeforeF7SelectEvent e, int i) {
        this.handleOwnerAndOutOwnerF7Logic(e, "ownertype", i);
    }

    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int i) {
        this.handleOwnerAndOutOwnerF7Logic(e, "outownertype", i);
    }

    private Object getDefOwerValue(String type) {
        Object ownerId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        if ("bos_org".equals(type)) {
            DynamicObject orgDyc = (DynamicObject)this.getValue("org");
            List<Object> ownerCache = this.getOwnerList(orgDyc);
            if (ownerCache.size() > 0) {
                ownerId = ownerCache.get(0);
            }
        } else if ("bd_customer".equals(type)) {
            ownerId = this.getValue("customer");
        }
        return ownerId;
    }

    private Object getDefalutKeeper(String type) {
        Object keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject orgDyc = (DynamicObject)this.getValue("org");
        if (orgDyc != null && "bos_org".equals(type)) {
            keeperId = orgDyc.getPkValue();
        } else if ("bd_customer".equals(type)) {
            keeperId = this.getValue("customer");
        }
        return keeperId;
    }

    private void handleOwnerAndOutOwnerF7Logic(BeforeF7SelectEvent e, String type, int rowIndex) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object ownerType = this.getValue(type, rowIndex);
        if ("bd_customer".equals(ownerType)) {
            return;
        }
        if ("bd_supplier".equals(ownerType)) {
            return;
        }
        DynamicObject orgDyc = (DynamicObject)this.getValue("org");
        if (orgDyc == null) {
            return;
        }
        List<Object> ownerCache = this.getOwnerList(orgDyc);
        QFilter ownerFilter = new QFilter("id", "in", ownerCache);
        showParameter.getListFilterParameter().setFilter(ownerFilter);
        showParameter.setCustomParam("orgFuncId", (Object)"10");
    }
}

