/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class PosStoreSerialCvtHelper {
    private static Log log = LogFactory.getLog(PosStoreSerialCvtHelper.class);
    private static final String KEY_SELECT_FEILD = "billtype,entrykey,billid,entryid,entryentity.snnumber as snnumber";

    public static void storeSnCvtBill(String sourceEntityNumber, String targetEntityNumber, Set<Object> targetBillIds) {
        String keyBill;
        String keyEntryEntity = "billentry";
        String keySrcBillEntryId = "srcbillentryid";
        String keySBillSnRelation = "ocpos_billsnrelation";
        String keyTBillSnRelation = "sbs_billsnrelation";
        log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f72:" + sourceEntityNumber + "," + targetEntityNumber);
        if ("ocpos_store_receive".equals(sourceEntityNumber) && "ocpos_store_purrefapply".equals(targetEntityNumber)) {
            keyBill = "ocpos_store_purrefapply";
        } else if ("ocpos_store_purrefapply".equals(sourceEntityNumber) && "im_purinbill".equals(targetEntityNumber)) {
            keyBill = "im_purinbill";
        } else if ("ocpos_store_delivery".equals(sourceEntityNumber) && "im_otheroutbill".equals(targetEntityNumber)) {
            keyBill = "im_otheroutbill";
        } else if ("ocpos_store_delivery".equals(sourceEntityNumber) && "im_transoutbill".equals(targetEntityNumber)) {
            keyBill = "im_transoutbill";
        } else if ("im_transoutbill".equals(sourceEntityNumber) && "ocpos_store_receive".equals(targetEntityNumber)) {
            keyBill = "ocpos_store_receive";
            keyEntryEntity = "entryentity";
            keySBillSnRelation = "sbs_billsnrelation";
            keyTBillSnRelation = "ocpos_billsnrelation";
        } else if ("pm_purorderbill".equals(sourceEntityNumber) && "ocpos_store_receive".equals(targetEntityNumber)) {
            keyBill = "im_otherinbill";
        } else if ("ocpos_store_receive".equals(sourceEntityNumber) && "im_transinbill".equals(targetEntityNumber)) {
            keyBill = "im_transinbill";
        } else if ("ocpos_store_receive".equals(sourceEntityNumber) && "im_otherinbill".equals(targetEntityNumber)) {
            keyBill = "im_otherinbill";
        } else if ("ocpos_store_receive".equals(sourceEntityNumber) && "im_purinbill".equals(targetEntityNumber)) {
            keyBill = "im_purinbill";
        } else {
            return;
        }
        if (targetBillIds == null || targetBillIds.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds.toArray());
        DynamicObjectCollection billDataEntry = QueryServiceHelper.query((String)targetEntityNumber, (String)("id," + keyEntryEntity + ".id as entryid," + keyEntryEntity + "." + keySrcBillEntryId + "," + keyEntryEntity + ".material.id as materialid," + keyEntryEntity + ".unit.id as unitid"), (QFilter[])filter.toArray());
        ArrayList<Long> lstSrcEntryId = new ArrayList<Long>(0);
        log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f73\u5165\u5e93\u5355\u7269\u6599\u884c:" + billDataEntry.size());
        for (DynamicObject dataEntity : billDataEntry) {
            long srcEntryId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)(keyEntryEntity + "." + keySrcBillEntryId));
            if (lstSrcEntryId.contains(srcEntryId)) continue;
            lstSrcEntryId.add(srcEntryId);
        }
        log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f74\u96f6\u552e\u6536\u8d27\u5355\u5e8f\u5217\u53f7\u884c:" + StringUtils.join((Object[])lstSrcEntryId.toArray(), (String)","));
        filter = new QFilter("entryid", "in", (Object)lstSrcEntryId.toArray());
        DynamicObjectCollection docBillSnRelation = QueryServiceHelper.query((String)keySBillSnRelation, (String)KEY_SELECT_FEILD, (QFilter[])filter.toArray());
        log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f75\u96f6\u552e\u6536\u8d27\u5355\u5e8f\u5217\u53f7\u884c:" + docBillSnRelation.size());
        if (CollectionUtils.isEmpty((Collection)docBillSnRelation)) {
            return;
        }
        PosStoreSerialCvtHelper.saveBillSNRelation(docBillSnRelation, keySrcBillEntryId, billDataEntry, keyTBillSnRelation, keyBill, keyEntryEntity);
    }

    public static void saveBillSNRelation(DynamicObjectCollection docBillSnRelation, String keySrcBillEntryId, DynamicObjectCollection billDataEntry, String keyBillSnRelation, String keyBill, String keyEntryEntity) {
        ArrayList<DynamicObject> lstBillSNRelation = new ArrayList<DynamicObject>(0);
        for (DynamicObject doBillSnRelation : docBillSnRelation) {
            DynamicObjectCollection docSNEntry;
            long entryId = DynamicObjectUtils.getLong((DynamicObject)doBillSnRelation, (String)"entryid");
            DynamicObject doEntry = billDataEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)(keyEntryEntity + "." + keySrcBillEntryId)) == entryId).findFirst().orElse(null);
            if (doEntry == null) continue;
            long billPkValue = DynamicObjectUtils.getLong((DynamicObject)doEntry, (String)"id");
            long entryPkValue = DynamicObjectUtils.getLong((DynamicObject)doEntry, (String)"entryid");
            long unitId = DynamicObjectUtils.getLong((DynamicObject)doEntry, (String)"unitid");
            long materialId = DynamicObjectUtils.getLong((DynamicObject)doEntry, (String)"materialid");
            log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f77\u7269\u6599\u548c\u8ba1\u91cf\u5355\u4f4d:" + materialId + "," + unitId);
            if (unitId == 0L || materialId == 0L) continue;
            String serialNo = DynamicObjectUtils.getString((DynamicObject)doBillSnRelation, (String)"snnumber");
            log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f78\u5e8f\u5217\u53f7:" + serialNo);
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)serialNo)) continue;
            DynamicObject billSNRelation = lstBillSNRelation.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"entryid") == entryPkValue).findFirst().orElse(null);
            if (billSNRelation == null) {
                billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)keyBillSnRelation);
                billSNRelation.set("billtype", (Object)keyBill);
                billSNRelation.set("entrykey", (Object)keyEntryEntity);
                billSNRelation.set("billid", (Object)billPkValue);
                billSNRelation.set("entryid", (Object)entryPkValue);
                billSNRelation.set("material", (Object)materialId);
                billSNRelation.set("unit", (Object)unitId);
                lstBillSNRelation.add(billSNRelation);
            }
            if ((docSNEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billSNRelation, (String)"entryentity")) == null) continue;
            Integer qty = (Integer)billSNRelation.get("qty");
            billSNRelation.set("qty", (Object)(qty + 1));
            DynamicObject doSNEntry = (DynamicObject)docSNEntry.getDynamicObjectType().createInstance();
            doSNEntry.set("seq", (Object)(docSNEntry.size() + 1));
            doSNEntry.set("snnumber", (Object)serialNo);
            docSNEntry.add((Object)doSNEntry);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sbs_billsnrelation");
        String ser = DynamicObjectSerializeUtil.serialize((Object[])lstBillSNRelation.toArray(), (DynamicObjectType)type);
        log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f79:" + ser);
        if (lstBillSNRelation.size() > 0) {
            OperationServiceHelper.executeOperate((String)"save", (String)keyBillSnRelation, (DynamicObject[])lstBillSNRelation.toArray(new DynamicObject[0]), null);
        }
    }
}

