/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class SerialNumberHelper {
    public static String transferSnStatus(String number) {
        switch (number) {
            case "snstatus-02": {
                return "B";
            }
            case "snstatus-04": {
                return "D";
            }
            case "snstatus-01": {
                return "A";
            }
            case "snstatus-03": {
                return "C";
            }
            case "snstatus-05": {
                return "E";
            }
        }
        return null;
    }

    public static boolean isEnableSerial(DynamicObject material) {
        return DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"enableserial");
    }

    public static void showPageEnterSerialNumber(AbstractBillPlugIn billPlugIn, Map<String, Object> customParams) {
        BaseShowParameter parameter = FormShowUtils.openNewBaseData((String)"\u5f55\u5165\u5e8f\u5217\u53f7", (String)"ocpos_billsnrelation", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        Object relationId = customParams.get("billsnrelationid");
        if (relationId != null) {
            parameter.setPkId(relationId);
        }
        billPlugIn.getView().showForm((FormShowParameter)parameter);
    }

    public static void showPageImportSerialNumber(AbstractBillPlugIn billPlugIn, Map<String, Object> customParams) {
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_importsn", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)billPlugIn, "ocpos_importsn"));
        billPlugIn.getView().showForm(parameter);
    }

    public static void showPageCheckSerialNumber(AbstractBillPlugIn billPlugIn, Map<String, Object> customParams) {
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_checksn", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        billPlugIn.getView().showForm(parameter);
    }

    public static void beforeHandleSerialNumber(AbstractBillPlugIn billPlugIn, BeforeDoOperationEventArgs e) {
        String status;
        String entityName;
        IFormView view = billPlugIn.getView();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)(entityName = "entryentity"));
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        int[] selectRows = ((EntryGrid)view.getControl(entityName)).getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u5206\u5f55\u5904\u7406\u5e8f\u5217\u53f7\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        DynamicObject entryEntity = (DynamicObject)entryEntities.get(selectRows[0]);
        DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"material");
        if (material == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        if (!SerialNumberHelper.isEnableSerial(material)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"unit");
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"baseunit");
        if (unit == null || baseUnit == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        FormOperate op = (FormOperate)e.getSource();
        String opKey = op.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"checksnnumber")) {
            return;
        }
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        boolean isFromDataBase = dataEntity.getDataEntityState().getFromDatabase();
        if (billId == 0L || !isFromDataBase) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity);
        if (entryId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5206\u5f55\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (IFormView)view);
            e.setCancel(true);
        }
        if (!StringUtils.equals((CharSequence)(status = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus")), (CharSequence)StatusEnum.DRAFT.getValue())) {
            if (StringUtils.equals((CharSequence)opKey, (CharSequence)"entersnnumber")) {
                NotificationUtil.showDefaultTipNotify((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (IFormView)view);
            } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"importsnnumber")) {
                NotificationUtil.showDefaultTipNotify((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (IFormView)view);
            }
            e.setCancel(true);
        }
    }

    public static void handleSerialNumber(AbstractBillPlugIn billPlugIn, DynamicObject dataEntity, DynamicObject entryEntity, String opKey) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        customParams.put("goods", goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"material");
        customParams.put("material", materialId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"baseunit");
        customParams.put("unit", baseUnitId);
        BigDecimal baseQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"baseqty");
        customParams.put("qty", baseQty.intValue());
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        customParams.put("billid", billId);
        String entityId = dataEntity.getDataEntityType().getName();
        customParams.put("billtype", entityId);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        customParams.put("billtypeid", billTypeId);
        long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity);
        customParams.put("entryid", entryId);
        String entityName = "entryentity";
        customParams.put("entrykey", entityName);
        long orgId = SerialNumberHelper.getBillMainOrgId(dataEntity, entityId);
        customParams.put("invorg", orgId);
        boolean isFromDataBase = dataEntity.getDataEntityState().getFromDatabase();
        if (isFromDataBase || !StringUtils.equals((CharSequence)"checksnnumber", (CharSequence)opKey)) {
            QFilter filter = new QFilter("billtype", "=", (Object)entityId);
            filter.and("billid", "=", (Object)billId);
            filter.and("entrykey", "=", (Object)entityName);
            filter.and("entryid", "=", (Object)entryId);
            DynamicObject relation = QueryServiceHelper.queryOne((String)"ocpos_billsnrelation", (String)"id", (QFilter[])filter.toArray());
            if (relation != null) {
                customParams.put("billsnrelationid", DynamicObjectUtils.getPkValue((DynamicObject)relation));
            }
        }
        SerialNumberHelper.showSerialNumberPage(billPlugIn, opKey, dataEntity, customParams);
    }

    private static void showSerialNumberPage(AbstractBillPlugIn billPlugIn, String opKey, DynamicObject dataEntity, Map<String, Object> customParams) {
        switch (opKey) {
            case "checksnnumber": {
                SerialNumberHelper.showPageCheckSerialNumber(billPlugIn, customParams);
                break;
            }
            case "entersnnumber": {
                customParams.putAll(SerialNumberHelper.getInvFluDirecData(dataEntity));
                SerialNumberHelper.showPageEnterSerialNumber(billPlugIn, customParams);
                break;
            }
            case "importsnnumber": {
                SerialNumberHelper.showPageImportSerialNumber(billPlugIn, customParams);
                break;
            }
        }
    }

    private static Map<String, String> getInvFluDirecData(DynamicObject dataEntity) {
        HashMap<String, String> invFluDirecData = new HashMap<String, String>(2);
        String invFlu = null;
        String bizDirection = null;
        long invSchemeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"invschemeid");
        if (invSchemeId == 0L) {
            invFlu = "0";
        } else {
            DynamicObject invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invSchemeId, (String)"im_invscheme", (String)"id,transceivertype");
            long transReceiveTypeId = DynamicObjectUtils.getPkValue((DynamicObject)invScheme, (String)"transceivertype");
            if (transReceiveTypeId == 0L) {
                invFlu = "0";
            } else {
                DynamicObject transReceiveType = BusinessDataServiceHelper.loadSingle((Object)transReceiveTypeId, (String)"bd_transceivertype", (String)"transceiver, bizdirection");
                String transceiver = DynamicObjectUtils.getString((DynamicObject)transReceiveType, (String)"transceiver");
                bizDirection = DynamicObjectUtils.getString((DynamicObject)transReceiveType, (String)"bizdirection");
                switch (transceiver) {
                    case "0": {
                        if (StringUtils.equals((CharSequence)bizDirection, (CharSequence)"0")) {
                            invFlu = "1";
                            break;
                        }
                        invFlu = "2";
                        break;
                    }
                    case "1": {
                        if (StringUtils.equals((CharSequence)bizDirection, (CharSequence)"0")) {
                            invFlu = "2";
                            break;
                        }
                        invFlu = "1";
                        break;
                    }
                    case "2": {
                        if (StringUtils.equals((CharSequence)bizDirection, (CharSequence)"0")) {
                            invFlu = "3";
                            break;
                        }
                        invFlu = "0";
                        break;
                    }
                }
            }
        }
        invFluDirecData.put("invflu", invFlu);
        invFluDirecData.put("direction", bizDirection);
        return invFluDirecData;
    }

    private static long getBillMainOrgId(DynamicObject dataEntity, String entityId) {
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_store_delivery")) {
            return DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"deliveryorg");
        }
        return DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
    }
}

