/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.util.Date;
import kd.occ.ocbase.common.util.DateUtil;

public class ShelfLifeDateHelper {
    public static final String MATERIAL_LIFE_DATE = "MaterialLifeDate";
    public static final String NEW_PRODUCE_DATE = "newProduceDate";
    public static final String OLD_PRODUCE_DATE = "oldProduceDate";
    public static final String NEW_EXPIRY_DATE = "newExpiryDate";
    public static final String OLD_EXPIRY_DATE = "oldExpiryDate";

    public static Date shelfLifeDateCal(String shelfLifeUnit, int shelfLife, Date inDate, String calculationForEndDate) {
        Date date;
        switch (shelfLifeUnit) {
            case "day": {
                date = ShelfLifeDateHelper.calculateDateAboutDay(calculationForEndDate, inDate, shelfLife);
                break;
            }
            case "month": {
                date = ShelfLifeDateHelper.calculateDate(calculationForEndDate, inDate, shelfLife, true);
                break;
            }
            case "year": {
                date = ShelfLifeDateHelper.calculateDate(calculationForEndDate, inDate, shelfLife, false);
                break;
            }
            default: {
                date = DateUtil.dayAdd((Date)inDate, (int)shelfLife);
            }
        }
        return date;
    }

    public static Date getDateOfOverdue(String leadTimeUnit, int dateOfOverdue, Date expiryDate) {
        Date date;
        switch (leadTimeUnit) {
            case "month": {
                date = DateUtil.monthAdd((Date)expiryDate, (int)(dateOfOverdue * -1));
                break;
            }
            case "year": {
                date = DateUtil.yearAdd((Date)expiryDate, (int)(dateOfOverdue * -1));
                break;
            }
            default: {
                date = DateUtil.dayAdd((Date)expiryDate, (int)(dateOfOverdue * -1));
            }
        }
        return date;
    }

    private static Date calculateDateAboutDay(String calculationForEndDate, Date inDate, int shelfLife) {
        Date date = null;
        switch (calculationForEndDate) {
            case "0": {
                date = DateUtil.dayAdd((Date)inDate, (int)shelfLife);
                break;
            }
            case "1": {
                date = DateUtil.dayAdd((Date)inDate, (int)(shelfLife > 0 ? shelfLife - 1 : shelfLife + 1));
                break;
            }
            case "2": {
                date = DateUtil.getLastDayOfMonth((Date)DateUtil.dayAdd((Date)inDate, (int)shelfLife));
                break;
            }
        }
        return date;
    }

    private static Date calculateDate(String calculationForEndDate, Date inDate, int shelfLife, boolean isMonth) {
        Date date = null;
        Date date_0 = isMonth ? DateUtil.monthAdd((Date)inDate, (int)shelfLife) : DateUtil.yearAdd((Date)inDate, (int)shelfLife);
        switch (calculationForEndDate) {
            case "0": {
                date = date_0;
                break;
            }
            case "1": {
                if (shelfLife < 0) {
                    date = DateUtil.getNextDate((Date)date_0);
                    break;
                }
                date = DateUtil.getDayLast((Date)date_0);
                break;
            }
            case "2": {
                date = DateUtil.getLastDayOfMonth((Date)date_0);
                break;
            }
        }
        return date;
    }
}

